/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.samples;

import com.android.tools.idea.ui.properties.BindingsManager;
import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.SettableValue;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.properties.core.ObservableString;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.android.tools.idea.ui.properties.expressions.Expression;
import com.android.tools.idea.ui.properties.expressions.string.StringExpression;
import com.android.tools.idea.ui.properties.expressions.value.TransformOptionalExpression;
import com.android.tools.idea.ui.properties.swing.TextProperty;
import com.android.tools.idea.ui.validation.Validator;
import com.android.tools.idea.ui.validation.ValidatorPanel;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.WizardModel;
import com.appspot.gsamplesindex.samplesindex.model.Sample;
import com.google.gct.studio.samples.SampleModel;
import com.google.gct.studio.util.GctStudioBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SampleSetupStep
extends ModelWizardStep<SampleModel> {
    private static final String DEFAULT_SAMPLE_NAME = GctStudioBundle.message("sample.default.name", new Object[0]);
    private final StudioWizardStepPanel myStudioPanel;
    private final ValidatorPanel myValidatorPanel;
    private final BindingsManager myBindings;
    private final StringProperty myProjectName;
    private final StringProperty myDir;
    private final ObservableString myNameToPathExpression;
    private JTextField myProjectNameField;
    private HyperlinkLabel myUrlField;
    private TextFieldWithBrowseButton myProjectLocationField;
    private JPanel myPanel;
    @NotNull
    private String myUrl;

    public SampleSetupStep(@NotNull SampleModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/google/gct/studio/samples/SampleSetupStep", "<init>"));
        }
        super((WizardModel)model, GctStudioBundle.message("sample.setup.title", new Object[0]));
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myUrl = "";
        this.myProjectName = new TextProperty((JTextComponent)this.myProjectNameField);
        this.myDir = new TextProperty((JTextComponent)this.myProjectLocationField.getTextField());
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, this.myPanel);
        this.myStudioPanel = new StudioWizardStepPanel((JPanel)this.myValidatorPanel, GctStudioBundle.message("sample.setup.description", new Object[0]));
        this.myNameToPathExpression = new StringExpression(new ObservableValue[]{this.myProjectName}){

            @NotNull
            public String get() {
                String string = SampleSetupStep.getFileLocation((String)SampleSetupStep.this.myProjectName.get()).getAbsolutePath();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/samples/SampleSetupStep$1", "get"));
                }
                return string;
            }
        };
    }

    private static String getUniqueName(String projectName) {
        File file = SampleSetupStep.getFileLocation(projectName);
        String name = projectName;
        int i = 0;
        while (file.exists()) {
            name = projectName + ++i;
            file = SampleSetupStep.getFileLocation(name);
        }
        return name;
    }

    private static File getFileLocation(String projectName) {
        return new File(WizardUtils.getProjectLocationParent(), projectName.replaceAll("[^a-zA-Z0-9_\\-.]", ""));
    }

    public void setUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/google/gct/studio/samples/SampleSetupStep", "setUrl"));
        }
        this.myUrl = url;
    }

    @NotNull
    protected JComponent getComponent() {
        StudioWizardStepPanel studioWizardStepPanel = this.myStudioPanel;
        if (studioWizardStepPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/samples/SampleSetupStep", "getComponent"));
        }
        return studioWizardStepPanel;
    }

    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myProjectNameField;
    }

    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizard", "com/google/gct/studio/samples/SampleSetupStep", "onWizardStarting"));
        }
        this.myProjectLocationField.addBrowseFolderListener(GctStudioBundle.message("select.project.location", new Object[0]), null, null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myBindings.bind((SettableValue)this.myProjectName, (ObservableValue)new TransformOptionalExpression<Sample, String>("", ((SampleModel)this.getModel()).sample()){

            @NotNull
            protected String transform(@NotNull Sample sample) {
                if (sample == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sample", "com/google/gct/studio/samples/SampleSetupStep$2", "transform"));
                }
                String name = sample.getTitle();
                String string = SampleSetupStep.getUniqueName(StringUtil.isEmpty((String)name) ? DEFAULT_SAMPLE_NAME : name);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/samples/SampleSetupStep$2", "transform"));
                }
                return string;
            }
        });
        BoolValueProperty isNameDirSynced = new BoolValueProperty(Boolean.valueOf(true));
        this.myDir.addListener(new InvalidationListener((BoolProperty)isNameDirSynced){
            final /* synthetic */ BoolProperty val$isNameDirSynced;
            {
                this.val$isNameDirSynced = boolProperty;
            }

            public void onInvalidated(@NotNull ObservableValue<?> sender) {
                if (sender == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/google/gct/studio/samples/SampleSetupStep$3", "onInvalidated"));
                }
                this.val$isNameDirSynced.set((Object)((String)SampleSetupStep.this.myDir.get()).equals(SampleSetupStep.this.myNameToPathExpression.get()));
            }
        });
        this.myBindings.bind((SettableValue)this.myDir, (ObservableValue)this.myNameToPathExpression, (ObservableValue)isNameDirSynced);
        this.myValidatorPanel.registerValidator((ObservableValue)this.myProjectName, (Validator)new Validator<String>(){

            @NotNull
            public Validator.Result validate(@NotNull String projectName) {
                if (projectName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectName", "com/google/gct/studio/samples/SampleSetupStep$4", "validate"));
                }
                Validator.Result result = StringUtil.isEmptyOrSpaces((String)projectName) ? new Validator.Result(Validator.Severity.ERROR, GctStudioBundle.message("application.name.not.set", new Object[0])) : Validator.Result.OK;
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/samples/SampleSetupStep$4", "validate"));
                }
                return result;
            }
        });
        PathValidator pathValidator = PathValidator.createDefault((String)"sample location");
        Expression<File> myDirFile = new Expression<File>(new ObservableValue[]{this.myDir}){

            @NotNull
            public File get() {
                File file = new File((String)SampleSetupStep.this.myDir.get());
                if (file == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/samples/SampleSetupStep$5", "get"));
                }
                return file;
            }
        };
        this.myValidatorPanel.registerValidator((ObservableValue)myDirFile, (Validator)pathValidator);
    }

    protected void onEntering() {
        this.myUrlField.setHyperlinkTarget(this.myUrl);
        this.myUrlField.setHyperlinkText(this.myUrl);
        this.myDir.set(this.myNameToPathExpression.get());
    }

    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/samples/SampleSetupStep", "canGoForward"));
        }
        return observableBool;
    }

    protected void onProceeding() {
        ((SampleModel)this.getModel()).projectName().setValue(this.myProjectName.get());
        ((SampleModel)this.getModel()).dir().setValue((Object)new File((String)this.myDir.get()));
    }

    public void dispose() {
        this.myBindings.releaseAll();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        HyperlinkLabel hyperlinkLabel;
        JTextField jTextField;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myProjectNameField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myUrlField = hyperlinkLabel = new HyperlinkLabel();
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("GitHub URL:");
        jBLabel.setHorizontalAlignment(10);
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Project location:");
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Application name:");
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProjectLocationField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

