/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.samples;

import com.android.tools.idea.ui.wizard.StudioWizardDialogBuilder;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.appspot.gsamplesindex.samplesindex.SamplesIndex;
import com.appspot.gsamplesindex.samplesindex.model.SampleCollection;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.gct.login.stats.UsageTrackerService;
import com.google.gct.studio.samples.SampleBrowserStep;
import com.google.gct.studio.samples.SampleModel;
import com.google.gct.studio.util.GctStudioBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import icons.GoogleCloudToolsIcons;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;

public class SampleImportAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(SampleImportAction.class);

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/google/gct/studio/samples/SampleImportAction", "update"));
        }
        if (NewWelcomeScreen.isNewWelcomeScreen((AnActionEvent)e)) {
            e.getPresentation().setIcon(GoogleCloudToolsIcons.Welcome.IMPORT_CODE_SAMPLE);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        SamplesIndex.Builder myBuilder = new SamplesIndex.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory(), null);
        final SamplesIndex samplesService = myBuilder.build();
        final AtomicReference<Object> sampleList = new AtomicReference<Object>(null);
        new Task.Modal(null, GctStudioBundle.message("sample.import.title", new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/google/gct/studio/samples/SampleImportAction$1", "run"));
                }
                indicator.setText(GctStudioBundle.message("sample.index.downloading", new Object[0]));
                try {
                    sampleList.set(samplesService.samples().listSamples().set("technology", (Object)"android").execute());
                }
                catch (IOException ex) {
                    LOG.warn(GctStudioBundle.message("sample.index.download.failed", new Object[0]));
                    sampleList.set(null);
                }
            }
        }.queue();
        if (sampleList.get() == null || ((SampleCollection)sampleList.get()).size() == 0) {
            Messages.showErrorDialog((String)GctStudioBundle.message("sample.index.download.failed", new Object[0]), (String)GctStudioBundle.message("sample.import.error.title", new Object[0]));
            return;
        }
        UsageTrackerService.getInstance().trackEvent("com.google.cloud.tools", "sample.importer", "browse", null);
        if (!AndroidSdkUtils.isAndroidSdkAvailable()) {
            String title = "SDK problem";
            String msg = "<html>Your Android SDK is missing or out of date.<br>You can configure your SDK via <b>Configure | Project Defaults | Project Structure | SDKs</b></html>";
            Messages.showErrorDialog((String)msg, (String)title);
            return;
        }
        ModelWizard.Builder wizardBuilder = new ModelWizard.Builder(new ModelWizardStep[0]);
        SampleModel model = new SampleModel();
        wizardBuilder.addStep((ModelWizardStep)new SampleBrowserStep(model, sampleList.get()));
        ModelWizard wizard = wizardBuilder.build();
        ModelWizardDialog dialog = new StudioWizardDialogBuilder(wizard, GctStudioBundle.message("sample.import.title", new Object[0])).build();
        dialog.show();
    }
}

