/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.appengine.wizard;

import com.android.tools.idea.npw.FormFactorUtils;
import com.android.tools.idea.npw.ModuleTemplate;
import com.android.tools.idea.npw.NewModuleDynamicPath;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizardPath;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.Lists;
import com.google.gct.studio.appengine.wizard.CloudModuleUtils;
import com.google.gct.studio.appengine.wizard.NewCloudModuleDynamicWizardStep;
import com.google.gct.studio.util.GctStudioBundle;
import icons.GoogleCloudToolsIcons;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewCloudModuleDynamicWizardPath
extends DynamicWizardPath
implements NewModuleDynamicPath {
    static final ScopedStateStore.Key<String> KEY_MODULE_NAME = ScopedStateStore.createKey((String)"moduleName", (ScopedStateStore.Scope)ScopedStateStore.Scope.PATH, String.class);
    static final ScopedStateStore.Key<String> KEY_PACKAGE_NAME = ScopedStateStore.createKey((String)"packageName", (ScopedStateStore.Scope)ScopedStateStore.Scope.PATH, String.class);
    static final ScopedStateStore.Key<String> KEY_CLIENT_MODULE_NAME = ScopedStateStore.createKey((String)"myClientModuleName", (ScopedStateStore.Scope)ScopedStateStore.Scope.PATH, String.class);
    static final ScopedStateStore.Key<File> KEY_SELECTED_TEMPLATE_FILE = ScopedStateStore.createKey((String)"myTemplateFile", (ScopedStateStore.Scope)ScopedStateStore.Scope.WIZARD, File.class);
    @NonNls
    private static final String PATH_NAME = "New Cloud Module Path";
    List<ModuleTemplate> myModuleTemplates;

    protected void init() {
        assert (this.getProject() != null);
        this.initPrefilledValues();
        this.addStep((DynamicWizardStep)new NewCloudModuleDynamicWizardStep(this.getProject(), this.myWizard.getDisposable()));
    }

    private void initPrefilledValues() {
        String userName = System.getProperty("user.name");
        String examplePackageName = userName == null ? GctStudioBundle.message("appengine.wizard.prefilled_package_name", new Object[0]) : GctStudioBundle.message("appengine.wizard.prefilled_user_package_name", userName);
        this.myState.put(KEY_MODULE_NAME, (Object)GctStudioBundle.message("appengine.wizard.prefilled_module_name", new Object[0]));
        this.myState.put(KEY_PACKAGE_NAME, (Object)examplePackageName);
    }

    @NotNull
    public String getPathName() {
        if (PATH_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/appengine/wizard/NewCloudModuleDynamicWizardPath", "getPathName"));
        }
        return PATH_NAME;
    }

    @NotNull
    public Iterable<ModuleTemplate> getModuleTemplates() {
        this.myModuleTemplates = Lists.newArrayList((Object[])new ModuleTemplate[]{new NewCloudModuleTemplate()});
        List<ModuleTemplate> list = this.myModuleTemplates;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/appengine/wizard/NewCloudModuleDynamicWizardPath", "getModuleTemplates"));
        }
        return list;
    }

    public boolean isPathVisible() {
        ModuleTemplate moduleTemplate = (ModuleTemplate)this.myWizard.getState().get(WizardConstants.SELECTED_MODULE_TYPE_KEY);
        return moduleTemplate != null && this.myModuleTemplates != null && this.myModuleTemplates.contains(moduleTemplate);
    }

    public boolean performFinishingActions() {
        File templateFile = (File)this.myState.get(KEY_SELECTED_TEMPLATE_FILE);
        String newModuleName = (String)this.myState.get(KEY_MODULE_NAME);
        String packageName = (String)this.myState.get(KEY_PACKAGE_NAME);
        String clientModuleName = (String)this.myState.get(KEY_CLIENT_MODULE_NAME);
        assert (this.getProject() != null && templateFile != null && newModuleName != null && packageName != null);
        CloudModuleUtils.createModule(this.getProject(), templateFile, newModuleName, packageName, clientModuleName);
        return true;
    }

    private static final class NewCloudModuleTemplate
    implements ModuleTemplate {
        private NewCloudModuleTemplate() {
        }

        @NotNull
        public String getName() {
            String string = GctStudioBundle.message("appengine.wizard.gallery_title", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/appengine/wizard/NewCloudModuleDynamicWizardPath$NewCloudModuleTemplate", "getName"));
            }
            return string;
        }

        @Nullable
        public String getDescription() {
            return GctStudioBundle.message("appengine.wizard.gallery_description", new Object[0]);
        }

        @Nullable
        public Icon getIcon() {
            return GoogleCloudToolsIcons.CLOUD_MODULE;
        }

        public void updateWizardState(@NotNull ScopedStateStore state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/google/gct/studio/appengine/wizard/NewCloudModuleDynamicWizardPath$NewCloudModuleTemplate", "updateWizardState"));
            }
        }

        @Nullable
        public FormFactorUtils.FormFactor getFormFactor() {
            return null;
        }

        public String toString() {
            return this.getName();
        }
    }
}

