/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb.renderers.formatters.libstdcpp;

import com.android.tools.ndk.run.lldb.renderers.TemplateParamsParser;
import com.android.tools.ndk.run.lldb.renderers.TypeNameFormatterCategory;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class SimpleContainerTypeNameFormatter
implements TypeNameFormatterCategory.TypeNameFormatter {
    private final String myContainerName;

    public SimpleContainerTypeNameFormatter(@NotNull String containerName) {
        if (containerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containerName", "com/android/tools/ndk/run/lldb/renderers/formatters/libstdcpp/SimpleContainerTypeNameFormatter", "<init>"));
        }
        this.myContainerName = containerName;
    }

    @Override
    public String format(@NotNull String input) {
        int numParams;
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/android/tools/ndk/run/lldb/renderers/formatters/libstdcpp/SimpleContainerTypeNameFormatter", "format"));
        }
        ArrayList<String> templateParams = TemplateParamsParser.getTemplateParams(input);
        int n = numParams = templateParams == null ? 0 : templateParams.size();
        if (numParams == 0 || numParams > 2) {
            return input;
        }
        String elementType = templateParams.get(0);
        String angleBracketSpace = TemplateParamsParser.spaceBetweenAngleBracket(elementType);
        if (numParams == 2 && !templateParams.get(1).contentEquals(String.format("std::allocator<%s%s>", elementType, angleBracketSpace))) {
            return input;
        }
        TypeNameFormatterCategory.TypeNameFormatter elementTypeFormatter = TypeNameFormatterCategory.lookupTypeNameFormatter(elementType);
        return String.format("%s<%s%s>", this.myContainerName, elementTypeFormatter != null ? elementTypeFormatter.format(elementType) : elementType, angleBracketSpace);
    }
}

