/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.ndk.run.AndroidNativeDeviceException;
import com.android.tools.ndk.run.AttachProgressReporter;
import com.android.tools.ndk.run.ClientShellHelper;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.RootSessionStarterImpl;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class RunAsSessionStarterImpl
extends RootSessionStarterImpl {
    private static final Logger LOG = Logger.getInstance(RunAsSessionStarterImpl.class);
    private final ClientShellHelper myShellHelper;

    public RunAsSessionStarterImpl(@NotNull JdwpConnector jdwpConnector, @NotNull Client client, @NotNull File localServerFile, @NotNull File localStartScriptFile, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull AttachProgressReporter progressReporter, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws ExecutionException {
        if (jdwpConnector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdwpConnector", "com/android/tools/ndk/run/lldb/RunAsSessionStarterImpl", "<init>"));
        }
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/ndk/run/lldb/RunAsSessionStarterImpl", "<init>"));
        }
        if (localServerFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localServerFile", "com/android/tools/ndk/run/lldb/RunAsSessionStarterImpl", "<init>"));
        }
        if (localStartScriptFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localStartScriptFile", "com/android/tools/ndk/run/lldb/RunAsSessionStarterImpl", "<init>"));
        }
        if (debuggerState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerState", "com/android/tools/ndk/run/lldb/RunAsSessionStarterImpl", "<init>"));
        }
        if (progressReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressReporter", "com/android/tools/ndk/run/lldb/RunAsSessionStarterImpl", "<init>"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/ndk/run/lldb/RunAsSessionStarterImpl", "<init>"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/ndk/run/lldb/RunAsSessionStarterImpl", "<init>"));
        }
        super(jdwpConnector, client, localServerFile, localStartScriptFile, debuggerState, progressReporter, launchStatus, printer);
        try {
            this.myShellHelper = new ClientShellHelper(client);
        }
        catch (Exception e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected String executeCommand(@NotNull String command, long maxTimeToOutputResponse, TimeUnit timeUnit) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, AndroidNativeDeviceException {
        void maxTimeUnits;
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/android/tools/ndk/run/lldb/RunAsSessionStarterImpl", "executeCommand"));
        }
        String output = super.executeCommand(command, maxTimeToOutputResponse, (TimeUnit)maxTimeUnits);
        String runAsBrokenMessage = String.format("run-as: Package '%s' is unknown", this.myClient.getClientData().getClientDescription());
        if (output.startsWith(runAsBrokenMessage)) {
            String errorMessage = "run-as is broken (please see http://b.android.com/187955 for details)";
            LOG.error("run-as is broken (please see http://b.android.com/187955 for details)");
            throw new AndroidNativeDeviceException("run-as is broken (please see http://b.android.com/187955 for details)");
        }
        String string = output;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/RunAsSessionStarterImpl", "executeCommand"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String getClientCommand(@NotNull String command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/android/tools/ndk/run/lldb/RunAsSessionStarterImpl", "getClientCommand"));
        }
        String string = this.myShellHelper.getRunAsCommand(command);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/RunAsSessionStarterImpl", "getClientCommand"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String getTargetDataDir() {
        String string = this.myClient.getClientData().getDataDir();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/RunAsSessionStarterImpl", "getTargetDataDir"));
        }
        return string;
    }
}

