/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.ndk.GradleWorkspace;
import com.android.tools.ndk.ModulePathManager;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.run.AttachProgressReporter;
import com.android.tools.ndk.run.crash.AndroidLLDBBreakpadIntegration;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriver;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.android.tools.ndk.run.lldb.renderers.AndroidLLDBValueRendererFactory;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.evaluation.ValueRendererFactory;
import java.io.File;
import java.io.FileFilter;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLLDBDriverConfiguration
extends LLDBDriverConfiguration {
    @NotNull
    private final Project myProject;
    @NotNull
    private final NativeAndroidDebuggerState myDebuggerState;
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private final SessionStarter mySessionStarter;
    @Nullable
    private final List<String> myStartupCommands;
    @NotNull
    private final List<String> myPostAttachCommands;
    @NotNull
    private final AttachProgressReporter myAttachProgressReporter;
    @NotNull
    private final File myFrameworkFile;
    private static final Logger LOG = Logger.getInstance(AndroidLLDBDriverConfiguration.class);
    private final AndroidFacet myFacet;
    private final ConsolePrinter myPrinter;

    public AndroidLLDBDriverConfiguration(@NotNull Project project, @NotNull AndroidFacet facet, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull ConsolePrinter consolePrinter, @NotNull IDevice device, @NotNull SessionStarter sessionStarter, @Nullable List<String> startupCommands, @NotNull List<String> postAttachCommands, @NotNull AttachProgressReporter attachProgressReporter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "<init>"));
        }
        if (debuggerState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerState", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "<init>"));
        }
        if (consolePrinter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consolePrinter", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "<init>"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "<init>"));
        }
        if (sessionStarter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionStarter", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "<init>"));
        }
        if (postAttachCommands == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postAttachCommands", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "<init>"));
        }
        if (attachProgressReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attachProgressReporter", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "<init>"));
        }
        this.myProject = project;
        this.myFacet = facet;
        this.myDebuggerState = debuggerState;
        this.myPrinter = consolePrinter;
        this.myDevice = device;
        this.mySessionStarter = sessionStarter;
        this.myStartupCommands = startupCommands;
        this.myPostAttachCommands = postAttachCommands;
        this.myAttachProgressReporter = attachProgressReporter;
        this.myFrameworkFile = this.findFrameworkFile();
        LOG.info("LLDB framework file: " + this.myFrameworkFile.getAbsolutePath());
    }

    @NotNull
    public IDevice getDevice() {
        IDevice iDevice = this.myDevice;
        if (iDevice == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "getDevice"));
        }
        return iDevice;
    }

    @NotNull
    public SessionStarter getSessionStarter() {
        SessionStarter sessionStarter = this.mySessionStarter;
        if (sessionStarter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "getSessionStarter"));
        }
        return sessionStarter;
    }

    @Nullable
    public List<String> getStartupCommands() {
        return this.myStartupCommands;
    }

    @NotNull
    public List<String> getPostAttachCommands() {
        List<String> list = this.myPostAttachCommands;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "getPostAttachCommands"));
        }
        return list;
    }

    @NotNull
    public AttachProgressReporter getAttachProgressReporter() {
        AttachProgressReporter attachProgressReporter = this.myAttachProgressReporter;
        if (attachProgressReporter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "getAttachProgressReporter"));
        }
        return attachProgressReporter;
    }

    @NotNull
    public DebuggerDriver createDriver(@NotNull DebuggerDriver.Handler handler) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "createDriver"));
        }
        AndroidLLDBDriver androidLLDBDriver = new AndroidLLDBDriver(handler, this.myFacet, this.myDebuggerState, this, this.myPrinter);
        if (androidLLDBDriver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "createDriver"));
        }
        return androidLLDBDriver;
    }

    @NotNull
    private File getLLDBPlatformBinFile(@NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "getLLDBPlatformBinFile"));
        }
        File file = ModulePathManager.getSdkLLDBFile(relativePath);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "getLLDBPlatformBinFile"));
        }
        return file;
    }

    @NotNull
    protected File getLLDBBinFile(@NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "getLLDBBinFile"));
        }
        File file = this.getLLDBPlatformBinFile(new File("bin", relativePath).getPath());
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "getLLDBBinFile"));
        }
        return file;
    }

    @NotNull
    private File getLLDBLibDir() {
        File file = this.getLLDBPlatformBinFile(new File("lib").getPath());
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "getLLDBLibDir"));
        }
        return file;
    }

    @NotNull
    private File findFrameworkFile() {
        if (SystemInfo.isWindows) {
            File file = this.getLLDBBinFile("liblldb.dll");
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "findFrameworkFile"));
            }
            return file;
        }
        if (SystemInfo.isLinux) {
            File file = this.findLinuxFrameworkFile();
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "findFrameworkFile"));
            }
            return file;
        }
        if (SystemInfo.isMac) {
            File file = this.getLLDBPlatformBinFile("LLDB.framework");
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "findFrameworkFile"));
            }
            return file;
        }
        throw new RuntimeException("Unsupported platform");
    }

    @NotNull
    private File findLinuxFrameworkFile() {
        File[] libFiles = this.getLLDBLibDir().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().startsWith("liblldb.so");
            }
        });
        if (libFiles == null || libFiles.length > 1) {
            throw new RuntimeException("Found broken Linux LLDB configuration");
        }
        File file = libFiles[0];
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "findLinuxFrameworkFile"));
        }
        return file;
    }

    @NotNull
    protected File getLLDBFrameworkFile() {
        File file = this.myFrameworkFile;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "getLLDBFrameworkFile"));
        }
        return file;
    }

    protected void configureDriverCommandLine(@NotNull GeneralCommandLine result) {
        File libStdCxxPrinterPath;
        File ndkPath;
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "configureDriverCommandLine"));
        }
        String workingDir = this.myDebuggerState.getWorkingDir();
        if (!workingDir.isEmpty()) {
            result.withWorkDirectory(workingDir);
        }
        if (!Projects.isBuildWithGradle((Project)this.myProject)) {
            return;
        }
        Map environment = result.getEnvironment();
        File galaPath = ModulePathManager.getRepoLLDBStlPrintersFolder();
        if (galaPath.exists()) {
            environment.put("AS_GALA_PATH", galaPath.getAbsolutePath());
        }
        if ((ndkPath = GradleWorkspace.getInstance(this.myProject).getNdkPath()) != null && (libStdCxxPrinterPath = NdkHelper.getLibStdCxxPrintersPath(ndkPath, "4.9")).exists()) {
            environment.put("AS_LIBSTDCXX_PRINTER_PATH", libStdCxxPrinterPath.getAbsolutePath());
        }
    }

    @NotNull
    public GeneralCommandLine createDriverCommandLine(@NotNull DebuggerDriver driver, @NotNull Installer installer, @NotNull String architecture) throws ExecutionException {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "createDriverCommandLine"));
        }
        if (installer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installer", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "createDriverCommandLine"));
        }
        if (architecture == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "architecture", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "createDriverCommandLine"));
        }
        File lldbFrameworkFile = this.getLLDBFrameworkFile();
        if (!lldbFrameworkFile.exists()) {
            throw new ExecutionException(lldbFrameworkFile + " not found");
        }
        File frontendExecutable = this.getLLDBBinFile(SystemInfo.isWindows ? "LLDBFrontend.exe" : "LLDBFrontend");
        if (!frontendExecutable.exists()) {
            throw new ExecutionException(frontendExecutable.getAbsolutePath() + " not found");
        }
        GeneralCommandLine result = new GeneralCommandLine();
        result.setExePath(frontendExecutable.getAbsolutePath());
        result.addParameter(String.valueOf(((LLDBDriver)driver).getPort()));
        AndroidLLDBDriverConfiguration.setupCommonParameters((GeneralCommandLine)result);
        Map env = result.getEnvironment();
        if (SystemInfo.isLinux) {
            env.put("LD_LIBRARY_PATH", this.getLLDBLibDir().getAbsolutePath());
        } else if (SystemInfo.isMac) {
            env.put("DYLD_FRAMEWORK_PATH", lldbFrameworkFile.getParent());
        }
        if (!SystemInfo.isMac) {
            env.put("PYTHONHOME", this.getLLDBLibDir().getParent());
        }
        AndroidLLDBBreakpadIntegration.setUpRunEnvironment(env);
        this.configureDriverCommandLine(result);
        GeneralCommandLine generalCommandLine = result;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "createDriverCommandLine"));
        }
        return generalCommandLine;
    }

    @NotNull
    public ValueRendererFactory getValueRenderersFactory() {
        AndroidLLDBValueRendererFactory androidLLDBValueRendererFactory = new AndroidLLDBValueRendererFactory();
        if (androidLLDBValueRendererFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration", "getValueRenderersFactory"));
        }
        return androidLLDBValueRendererFactory;
    }
}

