/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.android.builder.model.BuildType;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.Variant;
import com.android.repository.api.Downloader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RepoManager;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.android.tools.idea.sdkv2.StudioDownloader;
import com.android.tools.idea.sdkv2.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdkv2.StudioProgressRunner;
import com.android.tools.idea.sdkv2.StudioSettingsController;
import com.android.tools.ndk.run.lldb.LLDBSdkPkgInstaller;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.concurrency.FutureResult;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.jdom.Element;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;

public class NativeAndroidDebuggerState
extends AndroidDebuggerState {
    private static final String SYMBOL_DIRS = "symbol_dirs";
    private static final String SYMBOL_PATH = "symbol_path";
    private static final String SDK_CHECK_FAIL_WARNING = "SDK check failed.";
    private List<String> mySymbolDirs = Lists.newLinkedList();
    public String WORKING_DIR = "";
    public String TARGET_LOGGING_CHANNELS = "lldb process:gdb-remote packets";

    @NotNull
    public List<ValidationError> validate(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/ndk/run/editor/NativeAndroidDebuggerState", "validate"));
        }
        ArrayList errors = Lists.newArrayList();
        AndroidGradleModel androidModel = AndroidGradleModel.get((AndroidFacet)facet);
        if (androidModel != null && Projects.isBuildWithGradle((Module)facet.getModule())) {
            Variant selectedVariant = androidModel.getSelectedVariant();
            BuildTypeContainer buildTypeContainer = androidModel.findBuildType(selectedVariant.getBuildType());
            if (buildTypeContainer == null) {
                errors.add(ValidationError.fatal((String)("Build type " + selectedVariant.getBuildType() + " not found")));
                ArrayList arrayList = errors;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/editor/NativeAndroidDebuggerState", "validate"));
                }
                return arrayList;
            }
            BuildType buildType = buildTypeContainer.getBuildType();
            if (!buildType.isDebuggable()) {
                errors.add(ValidationError.fatal((String)"Build type isn't debuggable"));
            }
            if (!buildType.isJniDebuggable()) {
                errors.add(ValidationError.fatal((String)"Build type isn't JNI debuggable"));
            }
        } else {
            Manifest manifest = facet.getManifest();
            if (manifest == null) {
                errors.add(ValidationError.fatal((String)"Manifest is not found"));
                ArrayList arrayList = errors;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/editor/NativeAndroidDebuggerState", "validate"));
                }
                return arrayList;
            }
            if (!Boolean.valueOf((String)manifest.getApplication().getDebuggable().getValue()).booleanValue()) {
                errors.add(ValidationError.fatal((String)"Application is not debuggable"));
            }
        }
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(((Object)((Object)this)).getClass());
        RepoManager mgr = AndroidSdkUtils.tryToChooseSdkHandler().getSdkManager((ProgressIndicator)progress);
        final FutureResult localResult = new FutureResult();
        final FutureResult remoteUnavailableResult = new FutureResult();
        final FutureResult remoteUpdateResult = new FutureResult();
        StudioProgressRunner runner = new StudioProgressRunner(false, true, false, "Updating LLDB status", false, facet.getModule().getProject());
        RepoManager.RepoLoadedCallback localCallback = new RepoManager.RepoLoadedCallback(){

            public void doRun(@NotNull RepositoryPackages packages) {
                if (packages == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/android/tools/ndk/run/editor/NativeAndroidDebuggerState$1", "doRun"));
                }
                LocalPackage p = (LocalPackage)packages.getLocalPackages().get(LLDBSdkPkgInstaller.COMPATIBLE_PKG_PATH);
                if (p == null) {
                    localResult.set((Object)ValidationError.fatal((String)"C++ debugger package is missing or incompatible.", (Runnable)new LLDBSdkPkgInstaller()));
                } else {
                    localResult.set(null);
                }
            }
        };
        RepoManager.RepoLoadedCallback remoteCallback = new RepoManager.RepoLoadedCallback(){

            public void doRun(@NotNull RepositoryPackages packages) {
                if (packages == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/android/tools/ndk/run/editor/NativeAndroidDebuggerState$2", "doRun"));
                }
                UpdatablePackage p = (UpdatablePackage)packages.getConsolidatedPkgs().get(LLDBSdkPkgInstaller.COMPATIBLE_PKG_PATH);
                if (p == null || !p.hasRemote()) {
                    remoteUnavailableResult.set((Object)ValidationError.fatal((String)"C++ debugger package needs to be updated or installed but is unavailable."));
                    remoteUpdateResult.set(null);
                } else if (p.isUpdate()) {
                    remoteUpdateResult.set((Object)ValidationError.fatal((String)"C++ debugger is not up to date.", (Runnable)new LLDBSdkPkgInstaller()));
                    remoteUnavailableResult.set(null);
                } else {
                    remoteUnavailableResult.set(null);
                    remoteUpdateResult.set(null);
                }
            }
        };
        Runnable errorCallback = new Runnable(){

            @Override
            public void run() {
                localResult.set((Object)ValidationError.warning((String)NativeAndroidDebuggerState.SDK_CHECK_FAIL_WARNING));
                remoteUnavailableResult.set((Object)ValidationError.warning((String)NativeAndroidDebuggerState.SDK_CHECK_FAIL_WARNING));
                remoteUpdateResult.set((Object)ValidationError.warning((String)NativeAndroidDebuggerState.SDK_CHECK_FAIL_WARNING));
            }
        };
        mgr.load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, (List)ImmutableList.of((Object)localCallback), (List)ImmutableList.of((Object)remoteCallback), (List)ImmutableList.of((Object)errorCallback), (ProgressRunner)runner, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), false);
        try {
            ValidationError localError = (ValidationError)localResult.get();
            if (localError != null) {
                if (localError.getSeverity() == ValidationError.Severity.FATAL) {
                    errors.add(localError);
                } else {
                    ValidationError remoteError = (ValidationError)remoteUnavailableResult.get();
                    if (remoteError != null) {
                        errors.add(remoteError);
                    } else {
                        errors.add(localError);
                    }
                }
            } else {
                ValidationError remoteError = (ValidationError)remoteUpdateResult.get();
                if (remoteError != null) {
                    errors.add(remoteError);
                }
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        ArrayList arrayList = errors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/editor/NativeAndroidDebuggerState", "validate"));
        }
        return arrayList;
    }

    @NotNull
    public List<String> getSymbolDirs() {
        List<String> list = this.mySymbolDirs;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/editor/NativeAndroidDebuggerState", "getSymbolDirs"));
        }
        return list;
    }

    public void setSymbolDirs(@NotNull List<String> symDirs) {
        if (symDirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symDirs", "com/android/tools/ndk/run/editor/NativeAndroidDebuggerState", "setSymbolDirs"));
        }
        this.mySymbolDirs.clear();
        this.mySymbolDirs.addAll(symDirs);
    }

    public void addSymbolDir(@NotNull String symDir) {
        if (symDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symDir", "com/android/tools/ndk/run/editor/NativeAndroidDebuggerState", "addSymbolDir"));
        }
        if (this.mySymbolDirs.indexOf(symDir) == -1) {
            this.mySymbolDirs.add(symDir);
        }
    }

    @NotNull
    public String getWorkingDir() {
        String string = this.WORKING_DIR;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/editor/NativeAndroidDebuggerState", "getWorkingDir"));
        }
        return string;
    }

    public void setWorkingDir(@NotNull String workingDir) {
        if (workingDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "com/android/tools/ndk/run/editor/NativeAndroidDebuggerState", "setWorkingDir"));
        }
        this.WORKING_DIR = workingDir;
    }

    @NotNull
    public String getTargetLoggingChannels() {
        String string = this.TARGET_LOGGING_CHANNELS;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/editor/NativeAndroidDebuggerState", "getTargetLoggingChannels"));
        }
        return string;
    }

    public void setTargetLoggingChannels(@NotNull String targetLoggingChannels) {
        if (targetLoggingChannels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetLoggingChannels", "com/android/tools/ndk/run/editor/NativeAndroidDebuggerState", "setTargetLoggingChannels"));
        }
        this.TARGET_LOGGING_CHANNELS = targetLoggingChannels;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.mySymbolDirs = JDOMExternalizer.loadStringsList((Element)element, (String)SYMBOL_DIRS, (String)SYMBOL_PATH);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        JDOMExternalizer.saveStringsList((Element)element, (String)SYMBOL_DIRS, (String)SYMBOL_PATH, (String[])this.mySymbolDirs.toArray(new String[0]));
    }
}

