/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.android.ddmlib.Client;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.run.ApkProviderUtil;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.editor.AndroidDebuggerConfigurable;
import com.android.tools.idea.run.editor.AndroidDebuggerImplBase;
import com.android.tools.idea.run.tasks.DebugConnectorTask;
import com.android.tools.ndk.run.AndroidNativeDebugProcess;
import com.android.tools.ndk.run.AttachProgressReporter;
import com.android.tools.ndk.run.attach.AndroidNativeAttachConfiguration;
import com.android.tools.ndk.run.attach.AndroidNativeAttachConfigurationType;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerConfigurable;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.javaawarecpp.AndroidJavaAwareNativeDebugProcess;
import com.android.tools.ndk.run.lldb.ConnectLLDBTask;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.HashSet;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrLineBreakpointType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeAndroidDebugger
extends AndroidDebuggerImplBase<NativeAndroidDebuggerState> {
    public static final String ID = "Native";
    private static final String RUN_CONFIGURATION_NAME_PATTERN = "Android %s Debugger (%d)";
    private static final Logger LOG = Logger.getInstance(NativeAndroidDebugger.class);
    private static final String JAVA_AWARE_NATIVE_DEBUG_OPTION = "-N";
    private static final int MIN_JAVA_AWARE_NATIVE_DEBUG_API_LEVEL = 24;
    public static final Set<Class<? extends XBreakpointType<?, ?>>> NATIVE_BREAKPOINT_TYPES = ImmutableSet.of(CidrLineBreakpointType.class);

    public NativeAndroidDebugger() {
        super(NATIVE_BREAKPOINT_TYPES);
    }

    protected NativeAndroidDebugger(Set<Class<? extends XBreakpointType<?, ?>>> breakpointTypeCls) {
        super(breakpointTypeCls);
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getId"));
        }
        return ID;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.getId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public NativeAndroidDebuggerState createState() {
        NativeAndroidDebuggerState nativeAndroidDebuggerState = new NativeAndroidDebuggerState();
        if (nativeAndroidDebuggerState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "createState"));
        }
        return nativeAndroidDebuggerState;
    }

    @NotNull
    public AndroidDebuggerConfigurable<NativeAndroidDebuggerState> createConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "createConfigurable"));
        }
        NativeAndroidDebuggerConfigurable nativeAndroidDebuggerConfigurable = new NativeAndroidDebuggerConfigurable(project);
        if (nativeAndroidDebuggerConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "createConfigurable"));
        }
        return nativeAndroidDebuggerConfigurable;
    }

    @NotNull
    public DebugConnectorTask getConnectDebuggerTask(@NotNull ExecutionEnvironment env, @NotNull Set<String> applicationIds, @NotNull AndroidFacet facet, @NotNull NativeAndroidDebuggerState state, @NotNull String runConfigTypeId) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getConnectDebuggerTask"));
        }
        if (applicationIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationIds", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getConnectDebuggerTask"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getConnectDebuggerTask"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getConnectDebuggerTask"));
        }
        if (runConfigTypeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfigTypeId", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getConnectDebuggerTask"));
        }
        ConnectLLDBTask connectLLDBTask = new ConnectLLDBTask(env, applicationIds, facet, state, this, runConfigTypeId);
        if (connectLLDBTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getConnectDebuggerTask"));
        }
        return connectLLDBTask;
    }

    public boolean supportsProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "supportsProject"));
        }
        return AndroidProjectInfo.get((Project)project).hasNativeModules();
    }

    public void attachToClient(@NotNull Project project, @NotNull Client client) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "attachToClient"));
        }
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "attachToClient"));
        }
        String clientDescr = client.getClientData().getClientDescription();
        Module module = null;
        List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
        for (AndroidFacet facet : facets) {
            try {
                String packageName = ApkProviderUtil.computePackageName((AndroidFacet)facet);
                if (!clientDescr.startsWith(packageName)) continue;
                module = facet.getModule();
                break;
            }
            catch (ApkProvisionException e) {
                LOG.warn((Throwable)e);
            }
        }
        if (module == null) {
            throw new RuntimeException("Cannot find module by package name");
        }
        if (this.hasExistingSession(project, client)) {
            return;
        }
        DebuggerSession debuggerSession = NativeAndroidDebugger.findJdwpDebuggerSession((Project)project, (String)NativeAndroidDebugger.getClientDebugPort((Client)client));
        if (debuggerSession != null) {
            debuggerSession.getProcess().stop(false);
        }
        AndroidNativeAttachConfigurationType attachConfigurationType = AndroidNativeAttachConfigurationType.getInstance();
        ConfigurationFactory factory = attachConfigurationType.getFactory();
        String runConfigurationName = String.format(RUN_CONFIGURATION_NAME_PATTERN, this.getId(), client.getClientData().getPid());
        RunnerAndConfigurationSettings runSettings = RunManager.getInstance((Project)project).createRunConfiguration(runConfigurationName, factory);
        AndroidNativeAttachConfiguration configuration = (AndroidNativeAttachConfiguration)runSettings.getConfiguration();
        configuration.setClient(client);
        configuration.DEBUGGER_TYPE = this.getId();
        ((JavaRunConfigurationModule)configuration.getConfigurationModule()).setModule(module);
        ProgramRunnerUtil.executeConfiguration((Project)project, (RunnerAndConfigurationSettings)runSettings, (Executor)DefaultDebugExecutor.getDebugExecutorInstance());
    }

    protected static void detachXDebugSession(@NotNull XDebugSession debugSession) {
        if (debugSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugSession", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "detachXDebugSession"));
        }
        RunContentDescriptor descriptor = debugSession.getRunContentDescriptor();
        ProcessHandler processHandler = descriptor.getProcessHandler();
        if (processHandler != null) {
            processHandler.detachProcess();
        }
    }

    protected boolean hasExistingSession(@NotNull Project project, @NotNull Client client) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "hasExistingSession"));
        }
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "hasExistingSession"));
        }
        XDebugSession nativeDebugSession = NativeAndroidDebugger.findNativeDebugSession(project, client);
        if (nativeDebugSession != null) {
            return NativeAndroidDebugger.activateDebugSessionWindow((Project)project, (RunContentDescriptor)nativeDebugSession.getRunContentDescriptor());
        }
        return false;
    }

    @Nullable
    protected static XDebugSession findNativeDebugSession(@NotNull Project project, final @NotNull Client client) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "findNativeDebugSession"));
        }
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "findNativeDebugSession"));
        }
        return NativeAndroidDebugger.findXDebugSession(project, new NotNullFunction<XDebugProcess, Boolean>(){

            @NotNull
            public Boolean fun(XDebugProcess debugProcess) {
                if (!(debugProcess instanceof AndroidNativeDebugProcess)) {
                    Boolean bl = false;
                    if (bl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/editor/NativeAndroidDebugger$1", "fun"));
                    }
                    return bl;
                }
                AndroidNativeDebugProcess nativeDebugProcess = (AndroidNativeDebugProcess)debugProcess;
                Boolean bl = nativeDebugProcess.getClient().getClientData().getPid() == client.getClientData().getPid();
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/editor/NativeAndroidDebugger$1", "fun"));
                }
                return bl;
            }
        });
    }

    @Nullable
    protected static XDebugSession findXDebugSession(@NotNull Project project, @NotNull NotNullFunction<XDebugProcess, Boolean> debugProcessFilter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "findXDebugSession"));
        }
        if (debugProcessFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcessFilter", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "findXDebugSession"));
        }
        for (XDebugSession debugSession : XDebuggerManager.getInstance((Project)project).getDebugSessions()) {
            XDebugProcess debugProcess = debugSession.getDebugProcess();
            if (debugProcess == null || !((Boolean)debugProcessFilter.fun((Object)debugProcess)).booleanValue()) continue;
            return debugSession;
        }
        return null;
    }

    @NotNull
    public String getAmStartOptions(@NotNull AndroidVersion version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getAmStartOptions"));
        }
        String baseOptions = super.getAmStartOptions(version);
        if (this.supportsJavaAwareNativeDebugging(version)) {
            String string = baseOptions + (baseOptions.length() > 0 ? " " : "") + JAVA_AWARE_NATIVE_DEBUG_OPTION;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getAmStartOptions"));
            }
            return string;
        }
        String string = baseOptions;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getAmStartOptions"));
        }
        return string;
    }

    @NotNull
    public Set<XBreakpointType<?, ?>> getSupportedBreakpointTypes(@NotNull AndroidVersion version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getSupportedBreakpointTypes"));
        }
        Set baseSet = super.getSupportedBreakpointTypes(version);
        if (this.supportsJavaAwareNativeDebugging(version)) {
            XDebuggerUtil debuggerUtil = XDebuggerUtil.getInstance();
            ArrayList<XBreakpointType> list = new ArrayList<XBreakpointType>(baseSet);
            list.add(debuggerUtil.findBreakpointType(JavaLineBreakpointType.class));
            HashSet hashSet = new HashSet(list);
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getSupportedBreakpointTypes"));
            }
            return hashSet;
        }
        Set set = baseSet;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getSupportedBreakpointTypes"));
        }
        return set;
    }

    public boolean supportsJavaAwareNativeDebugging(@NotNull AndroidVersion version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "supportsJavaAwareNativeDebugging"));
        }
        return version.getFeatureLevel() >= 24;
    }

    @NotNull
    public AndroidNativeDebugProcess getAndroidNativeDebugProcess(@NotNull AndroidVersion version, @NotNull Project project, @NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, @NotNull ConsolePrinter printer, @NotNull SessionStarter sessionStarter, @NotNull Client client, @NotNull AttachProgressReporter attachProgressReporter, boolean detachOnStop) throws ExecutionException {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getAndroidNativeDebugProcess"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getAndroidNativeDebugProcess"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getAndroidNativeDebugProcess"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getAndroidNativeDebugProcess"));
        }
        if (consoleBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleBuilder", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getAndroidNativeDebugProcess"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getAndroidNativeDebugProcess"));
        }
        if (sessionStarter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionStarter", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getAndroidNativeDebugProcess"));
        }
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getAndroidNativeDebugProcess"));
        }
        if (attachProgressReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attachProgressReporter", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getAndroidNativeDebugProcess"));
        }
        if (client.getClientData().isNativeDebuggable()) {
            AndroidJavaAwareNativeDebugProcess androidJavaAwareNativeDebugProcess = new AndroidJavaAwareNativeDebugProcess(project, parameters, session, consoleBuilder, printer, sessionStarter, client, attachProgressReporter, detachOnStop);
            if (androidJavaAwareNativeDebugProcess == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getAndroidNativeDebugProcess"));
            }
            return androidJavaAwareNativeDebugProcess;
        }
        AndroidNativeDebugProcess androidNativeDebugProcess = new AndroidNativeDebugProcess(project, parameters, session, consoleBuilder, printer, sessionStarter, client, attachProgressReporter, detachOnStop);
        if (androidNativeDebugProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getAndroidNativeDebugProcess"));
        }
        return androidNativeDebugProcess;
    }

    @NotNull
    protected static String prepareSetSettingsCommand(String ... options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "prepareSetSettingsCommand"));
        }
        String string = "settings set " + StringUtil.join((String[])options, (String)" ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "prepareSetSettingsCommand"));
        }
        return string;
    }

    @NotNull
    public List<String> getPostAttachCommands(@NotNull Client client, @NotNull AndroidFacet facet, @NotNull ProcessHandlerConsolePrinter printer) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getPostAttachCommands"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getPostAttachCommands"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getPostAttachCommands"));
        }
        ArrayList cmds = Lists.newArrayList((Object[])new String[]{NativeAndroidDebugger.prepareSetSettingsCommand("auto-confirm", "true")});
        ArrayList javaDirs = Lists.newArrayList((Iterable)facet.getMainSourceProvider().getJavaDirectories());
        int numJavaDirs = javaDirs.size();
        if (client.getClientData().isNativeDebuggable() && numJavaDirs > 0) {
            String firstJavaDir = ((File)javaDirs.get(0)).getAbsolutePath();
            Collections.addAll(cmds, NativeAndroidDebugger.prepareSetSettingsCommand("plugin.jit-loader.gdb.enable-jit-breakpoint", "true"), NativeAndroidDebugger.prepareSetSettingsCommand("target.move-to-nearest-code", "false"), NativeAndroidDebugger.prepareSetSettingsCommand("target.source-map", "$JAVA_SRC_ROOT", "\"" + firstJavaDir + "\""));
            if (numJavaDirs > 1) {
                printer.stderr("The project has more than one Java source directories.\nBreakpoints in source files in " + firstJavaDir + " will only be active.");
            }
        } else {
            cmds.add(NativeAndroidDebugger.prepareSetSettingsCommand("plugin.jit-loader.gdb.enable-jit-breakpoint", "false"));
        }
        ArrayList arrayList = cmds;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/editor/NativeAndroidDebugger", "getPostAttachCommands"));
        }
        return arrayList;
    }

    public boolean supportsHybridDebugging() {
        return false;
    }
}

