/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.crash;

import com.android.tools.ndk.run.crash.NativeClientCrashException;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriver;
import com.google.common.io.PatternFilenameFilter;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLLDBBreakpadIntegration {
    private static final Logger LOG = Logger.getInstance(AndroidLLDBBreakpadIntegration.class);
    private static final Object MINIDUMP_MUTEX = new Object();
    private static final boolean ENABLE_CRASH_DUMPS = true;
    static final String CRASH_MESSAGE = "The technical details of the error report found on the \u2018Attachments\u2019\ntab will be sent to Google\u2019s Android team to help identify and fix\nthe problem.  https://www.google.com/policies/privacy/";

    @Nullable
    private static File getMinidumpDir() {
        File folder = new File(PathManager.getTempPath(), "lldb");
        if (folder.exists() ? !folder.isDirectory() : !folder.mkdir()) {
            return null;
        }
        return folder;
    }

    private static int checkForMinidumps(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/ndk/run/crash/AndroidLLDBBreakpadIntegration", "checkForMinidumps"));
        }
        File dir = AndroidLLDBBreakpadIntegration.getMinidumpDir();
        if (dir == null) {
            return 0;
        }
        File[] minidumps = dir.listFiles((FilenameFilter)new PatternFilenameFilter(".*\\.dmp"));
        int count = 0;
        for (File minidump : minidumps) {
            try {
                LOG.error((Throwable)NativeClientCrashException.create(message, minidump));
                ++count;
            }
            catch (IOException e) {
                LOG.error("Error reading native client crash dump.", (Throwable)e);
            }
            minidump.delete();
        }
        return count;
    }

    public static void setUpRunEnvironment(Map<String, String> env) {
        File dir = AndroidLLDBBreakpadIntegration.getMinidumpDir();
        if (dir != null) {
            env.put("LLDBFRONTEND_DUMPDIR", dir.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkForStaleMinidumps() {
        Object object = MINIDUMP_MUTEX;
        synchronized (object) {
            return AndroidLLDBBreakpadIntegration.checkForMinidumps("Previous session of Android Studio's C++ debugger had unexpectedly stopped") > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkForCrashes(@NotNull AndroidLLDBDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/android/tools/ndk/run/crash/AndroidLLDBBreakpadIntegration", "checkForCrashes"));
        }
        Object object = MINIDUMP_MUTEX;
        synchronized (object) {
            if (AndroidLLDBBreakpadIntegration.checkForMinidumps("Android Studio's C++ debugger stopped unexpectedly") > 0) {
                driver.setCrashed(true);
            }
            return driver.isCrashed();
        }
    }

    public static void monitorForCrashes(final @NotNull AndroidLLDBDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/android/tools/ndk/run/crash/AndroidLLDBBreakpadIntegration", "monitorForCrashes"));
        }
        driver.getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                AndroidLLDBBreakpadIntegration.checkForCrashes(driver);
            }
        });
    }
}

