/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.NativeLibrary;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.Variant;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.ndk.MemoryRegionMap;
import com.android.tools.ndk.run.AndroidNativeExecutionStack;
import com.android.tools.ndk.run.AttachProgressReporter;
import com.android.tools.ndk.run.crash.AndroidLLDBBreakpadIntegration;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.hybrid.NativeDebugProcess;
import com.android.tools.ndk.run.hybrid.StepIntoNativeBreakpointHandler;
import com.android.tools.ndk.run.hybrid.StepIntoNativeBreakpointType;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriver;
import com.android.tools.ndk.run.lldb.LLDBUsageTracker;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointType;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidNativeDebugProcess
extends CidrDebugProcess
implements NativeDebugProcess {
    private static final Logger LOG = Logger.getInstance(AndroidNativeDebugProcess.class);
    private static final String LIBART_SO = "libart.so";
    private static final String ART_SIGSEGV_FAULT = "art_sigsegv_fault";
    private static final List<String> SKIPPABLE_UNITY_SIGNALS = ImmutableList.of((Object)"SIGPWR", (Object)"SIGXCPU");
    private static final List<String> UNITY_IDENTIFYING_LIBRARIES = ImmutableList.of((Object)"libil2cpp.so", (Object)"libmono.so");
    private static final CidrSymbolicBreakpointType SYMBOLIC_BREAKPOINT_TYPE = (CidrSymbolicBreakpointType)XBreakpointType.EXTENSION_POINT_NAME.findExtension(CidrSymbolicBreakpointType.class);
    private final Project myProject;
    private final ConsolePrinter myPrinter;
    private final SessionStarter mySessionStarter;
    private final Client myClient;
    private final AttachProgressReporter myAttachProgressReporter;
    private XBreakpoint<CidrSymbolicBreakpointType.Properties> myArtSigSegvFaultBp;
    private boolean myArt;
    private final MemoryRegionMap myArtMemRegionMap;
    private final StepIntoNativeBreakpointHandler myStepIntoNativeBreakpointHandler;
    @Nullable
    private XDebugSession myJavaSession;
    private final boolean myDetachOnStop;
    private static final Map<String, String> DANGEROUS_COMPILER_FLAGS = ImmutableMap.of((Object)"-flto", (Object)"Combining -flto with -g is currently experimental and expected to produce unexpected results");

    public AndroidNativeDebugProcess(@NotNull Project project, @NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, @NotNull ConsolePrinter printer, @NotNull SessionStarter sessionStarter, @NotNull Client client, @NotNull AttachProgressReporter attachProgressReporter, boolean detachOnStop) throws ExecutionException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "<init>"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "<init>"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "<init>"));
        }
        if (consoleBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleBuilder", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "<init>"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "<init>"));
        }
        if (sessionStarter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionStarter", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "<init>"));
        }
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "<init>"));
        }
        if (attachProgressReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attachProgressReporter", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "<init>"));
        }
        super(parameters, session, consoleBuilder);
        this.myArt = false;
        this.myArtMemRegionMap = new MemoryRegionMap(Arrays.asList(".*\\.dex", ".*\\.odex", ".*\\.oat"));
        this.myProject = project;
        this.myPrinter = printer;
        this.mySessionStarter = sessionStarter;
        this.myClient = client;
        this.myAttachProgressReporter = attachProgressReporter;
        this.myStepIntoNativeBreakpointHandler = this.createStepIntoNativeHandler();
        this.myDetachOnStop = detachOnStop;
    }

    @NotNull
    public Client getClient() {
        Client client = this.myClient;
        if (client == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "getClient"));
        }
        return client;
    }

    @NotNull
    private StepIntoNativeBreakpointHandler createStepIntoNativeHandler() {
        StepIntoNativeBreakpointHandler stepIntoNativeBreakpointHandler = new StepIntoNativeBreakpointHandler(this, StepIntoNativeBreakpointType.class);
        if (stepIntoNativeBreakpointHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "createStepIntoNativeHandler"));
        }
        return stepIntoNativeBreakpointHandler;
    }

    protected boolean isRemote() {
        return true;
    }

    public boolean isDetachDefault() {
        return this.myDetachOnStop;
    }

    public boolean checkCanInitBreakpoints() {
        return false;
    }

    protected void doStart(@NotNull DebuggerDriver driver) throws ExecutionException {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "doStart"));
        }
    }

    protected void doLaunchTarget(@NotNull DebuggerDriver driver) throws ExecutionException {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "doLaunchTarget"));
        }
        this.getProcessHandler().startNotify();
        try {
            LOG.info("Pushing files to device");
            this.myAttachProgressReporter.step("Pushing files to device");
            this.mySessionStarter.pushFilesToDevice();
            LOG.info("Loading driver");
            this.myAttachProgressReporter.step("Loading debugger driver");
            driver.loadForRemote(null);
            ClientData clientData = this.myClient.getClientData();
            LOG.info(String.format("Attaching to inferior: pid=%d, ABI=%s, native debuggable=%b", clientData.getPid(), clientData.getAbi(), clientData.isNativeDebuggable()));
            this.myAttachProgressReporter.step("Attaching to the app");
            driver.attachTo(clientData.getPid());
            this.myArt = this.isArtVM(driver);
            if (this.myArt) {
                LOG.info("Running in ART VM");
                this.initArtSigSegvFaultBreakpoint();
            } else {
                LOG.info("Running in Dalvik VM");
            }
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    AndroidNativeDebugProcess.this.getSession().initBreakpoints();
                }
            });
            LOG.info("Resuming paused inferior");
            this.myAttachProgressReporter.step("Resuming the app process");
            driver.resume();
            this.myAttachProgressReporter.step("Resuming the app VM");
            this.mySessionStarter.resumeVm();
            LOG.info("Launch has been completed");
        }
        catch (ExecutionException e) {
            this.myPrinter.stderr("Failed to attach native debugger: " + e.getMessage());
            AndroidNativeDebugProcess.reportError(e);
            throw e;
        }
        finally {
            this.myAttachProgressReporter.finish();
        }
    }

    @NotNull
    private XBreakpointManager getBreakpointManager() {
        XBreakpointManager xBreakpointManager = XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager();
        if (xBreakpointManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "getBreakpointManager"));
        }
        return xBreakpointManager;
    }

    @NotNull
    private static Application getApp() {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "getApp"));
        }
        return application;
    }

    private void initArtSigSegvFaultBreakpoint() throws ExecutionException {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                for (XBreakpoint bp : AndroidNativeDebugProcess.this.getBreakpointManager().getBreakpoints((XBreakpointType)SYMBOLIC_BREAKPOINT_TYPE)) {
                    CidrSymbolicBreakpointType.Properties bpProps = (CidrSymbolicBreakpointType.Properties)bp.getProperties();
                    if (!bpProps.getModuleName().equals(AndroidNativeDebugProcess.LIBART_SO) || !bpProps.getSymbolPattern().equals(AndroidNativeDebugProcess.ART_SIGSEGV_FAULT)) continue;
                    AndroidNativeDebugProcess.this.myArtSigSegvFaultBp = bp;
                    break;
                }
            }
        });
        if (this.myArtSigSegvFaultBp != null) {
            return;
        }
        AndroidNativeDebugProcess.getApp().invokeLater(new Runnable(){

            @Override
            public void run() {
                AndroidNativeDebugProcess.getApp().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        CidrSymbolicBreakpointType.Properties props = new CidrSymbolicBreakpointType.Properties(AndroidNativeDebugProcess.ART_SIGSEGV_FAULT, AndroidNativeDebugProcess.LIBART_SO);
                        AndroidNativeDebugProcess.this.myArtSigSegvFaultBp = AndroidNativeDebugProcess.this.getBreakpointManager().addBreakpoint((XBreakpointType)SYMBOLIC_BREAKPOINT_TYPE, (XBreakpointProperties)props);
                    }
                });
            }
        });
    }

    private boolean isArtVM(@NotNull DebuggerDriver driver) throws ExecutionException {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "isArtVM"));
        }
        return this.readProcMapsFile(driver).contains(LIBART_SO);
    }

    public void stop() {
        super.stop();
        XDebugSession javaSession = this.getJavaSession();
        if (javaSession != null) {
            javaSession.stop();
        }
        AndroidNativeDebugProcess.getApp().invokeLater(new Runnable(){

            @Override
            public void run() {
                AndroidNativeDebugProcess.getApp().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        if (AndroidNativeDebugProcess.this.myArtSigSegvFaultBp != null && !AndroidNativeDebugProcess.this.myProject.isDisposed()) {
                            XDebuggerManager.getInstance((Project)AndroidNativeDebugProcess.this.myProject).getBreakpointManager().removeBreakpoint(AndroidNativeDebugProcess.this.myArtSigSegvFaultBp);
                            AndroidNativeDebugProcess.this.myArtSigSegvFaultBp = null;
                        }
                    }
                });
            }
        });
    }

    private boolean isUnityApp(@NotNull DebuggerDriver driver) throws ExecutionException {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "isUnityApp"));
        }
        String procMapsFile = this.readProcMapsFile(driver);
        for (String unityLibrary : UNITY_IDENTIFYING_LIBRARIES) {
            if (!procMapsFile.contains(unityLibrary)) continue;
            return true;
        }
        return false;
    }

    public void handleSignal(final @NotNull List<LLThread> threads, final int currentThreadIndex, final @NotNull String signal, final @NotNull String meaning) {
        if (threads == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threads", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "handleSignal"));
        }
        if (signal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signal", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "handleSignal"));
        }
        if (meaning == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meaning", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "handleSignal"));
        }
        if (SKIPPABLE_UNITY_SIGNALS.contains(signal)) {
            this.postCommand(new CidrDebugProcess.DebuggerCommand(){

                public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                    if (driver == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/android/tools/ndk/run/AndroidNativeDebugProcess$5", "run"));
                    }
                    if (AndroidNativeDebugProcess.this.isUnityApp(driver)) {
                        for (String skippableUnixSignal : SKIPPABLE_UNITY_SIGNALS) {
                            driver.handleSignal(skippableUnixSignal, false, true, false);
                        }
                        driver.resume();
                    } else {
                        AndroidNativeDebugProcess.super.handleSignal(threads, currentThreadIndex, signal, meaning);
                    }
                }
            });
            return;
        }
        if (this.myArt && signal.equals("SIGSEGV")) {
            this.postCommand(new CidrDebugProcess.DebuggerCommand(){

                public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                    if (driver == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/android/tools/ndk/run/AndroidNativeDebugProcess$6", "run"));
                    }
                    if (!AndroidNativeDebugProcess.this.handleArtSigSegv(driver, threads, currentThreadIndex)) {
                        AndroidNativeDebugProcess.super.handleSignal(threads, currentThreadIndex, signal, meaning);
                    }
                }
            });
            return;
        }
        super.handleSignal(threads, currentThreadIndex, signal, meaning);
    }

    private boolean handleArtSigSegv(@NotNull DebuggerDriver driver, @NotNull List<LLThread> threads, int currentThreadIndex) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "handleArtSigSegv"));
        }
        if (threads == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threads", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "handleArtSigSegv"));
        }
        LLThread thread = threads.get(currentThreadIndex);
        try {
            List frames = driver.getFrames(thread.getId());
            if (frames.isEmpty()) {
                return false;
            }
            LLFrame firstFrame = (LLFrame)frames.get(0);
            LOG.info(String.format("Got SIGSEGV signal, PC address: 0x%X", firstFrame.getProgramCounter()));
            MemoryRegionMap.Region region = this.myArtMemRegionMap.getRegionByAddress(firstFrame.getProgramCounter());
            if (region == null || !region.isExecutable()) {
                this.myArtMemRegionMap.clear();
                String procMapsContent = this.readProcMapsFile(driver);
                this.myArtMemRegionMap.addMapEntries(StringUtil.splitByLines((String)procMapsContent));
            }
            if ((region = this.myArtMemRegionMap.getRegionByAddress(firstFrame.getProgramCounter())) != null && region.isExecutable()) {
                LOG.info(String.format("SIGSEGV came from ART module '%s' - resuming the inferior", region.getFileName()));
                driver.resume();
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return false;
    }

    @NotNull
    private String readProcMapsFile(@NotNull DebuggerDriver driver) throws ExecutionException {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "readProcMapsFile"));
        }
        String command = String.format("cat /proc/%d/maps", this.myClient.getClientData().getPid());
        String string = driver.executeShellCommand(command, null, 0).getOutput();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "readProcMapsFile"));
        }
        return string;
    }

    @NotNull
    private static Set<String> getAbiNameSet(@NotNull List<Abi> abis) {
        if (abis == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abis", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "getAbiNameSet"));
        }
        HashSet abiNames = Sets.newHashSetWithExpectedSize((int)abis.size());
        for (Abi abi : abis) {
            abiNames.add(abi.toString());
        }
        HashSet hashSet = abiNames;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "getAbiNameSet"));
        }
        return hashSet;
    }

    private static void visitNativeLibraries(@NotNull AndroidArtifact androidArtifact, @NotNull Project project, @NotNull Set<String> abiNames, @NotNull NativeLibraryVisitor visitor) {
        if (androidArtifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidArtifact", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "visitNativeLibraries"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "visitNativeLibraries"));
        }
        if (abiNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abiNames", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "visitNativeLibraries"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "visitNativeLibraries"));
        }
        Collection nativeLibraries = androidArtifact.getNativeLibraries();
        if (nativeLibraries != null) {
            for (NativeLibrary library : nativeLibraries) {
                if (!abiNames.contains(library.getAbi())) continue;
                visitor.visit(library);
            }
        }
        for (AndroidLibrary lib : androidArtifact.getDependencies().getLibraries()) {
            AndroidGradleModel moduleModel;
            AndroidFacet moduleFacet;
            Module module;
            String projectName = lib.getProject();
            if (projectName == null || (module = GradleUtil.findModuleByGradlePath((Project)project, (String)projectName)) == null || (moduleFacet = AndroidFacet.getInstance((Module)module)) == null || (moduleModel = AndroidGradleModel.get((AndroidFacet)moduleFacet)) == null) continue;
            AndroidNativeDebugProcess.visitNativeLibraries(moduleModel.getMainArtifact(), project, abiNames, visitor);
        }
    }

    @NotNull
    public static List<File> getSymbolsDir(@NotNull AndroidFacet facet, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull List<Abi> abis) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "getSymbolsDir"));
        }
        if (debuggerState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerState", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "getSymbolsDir"));
        }
        if (abis == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abis", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "getSymbolsDir"));
        }
        final ArrayList libFolders = Lists.newArrayList();
        AndroidGradleModel androidModel = AndroidGradleModel.get((AndroidFacet)facet);
        if (androidModel != null) {
            for (SourceProvider sourceProvider : androidModel.getActiveSourceProviders()) {
                for (File jniLib : sourceProvider.getJniLibsDirectories()) {
                    if (!jniLib.exists()) continue;
                    for (Abi abi : abis) {
                        File abiJniLib = new File(jniLib, abi.toString());
                        if (!abiJniLib.exists()) continue;
                        libFolders.add(abiJniLib);
                    }
                }
            }
            Variant selectedVariant = androidModel.getSelectedVariant();
            AndroidNativeDebugProcess.visitNativeLibraries(selectedVariant.getMainArtifact(), facet.getModule().getProject(), AndroidNativeDebugProcess.getAbiNameSet(abis), new NativeLibraryVisitor(){

                @Override
                public void visit(@NotNull NativeLibrary nativeLibrary) {
                    if (nativeLibrary == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeLibrary", "com/android/tools/ndk/run/AndroidNativeDebugProcess$7", "visit"));
                    }
                    libFolders.addAll(nativeLibrary.getDebuggableLibraryFolders());
                }
            });
        }
        for (String symDir : debuggerState.getSymbolDirs()) {
            libFolders.add(new File(symDir));
        }
        ArrayList arrayList = libFolders;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "getSymbolsDir"));
        }
        return arrayList;
    }

    public static void verifyNativeModel(@NotNull AndroidFacet facet, @NotNull List<Abi> abis, final @NotNull ConsolePrinter printer) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "verifyNativeModel"));
        }
        if (abis == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abis", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "verifyNativeModel"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "verifyNativeModel"));
        }
        AndroidGradleModel androidModel = AndroidGradleModel.get((AndroidFacet)facet);
        if (androidModel == null) {
            return;
        }
        Variant selectedVariant = androidModel.getSelectedVariant();
        Collection nativeLibraries = selectedVariant.getMainArtifact().getNativeLibraries();
        if (nativeLibraries == null) {
            printer.stderr("Selected build variant doesn't have native libraries");
            return;
        }
        AndroidNativeDebugProcess.visitNativeLibraries(selectedVariant.getMainArtifact(), facet.getModule().getProject(), AndroidNativeDebugProcess.getAbiNameSet(abis), new NativeLibraryVisitor(){

            @Override
            public void visit(@NotNull NativeLibrary nativeLibrary) {
                if (nativeLibrary == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeLibrary", "com/android/tools/ndk/run/AndroidNativeDebugProcess$8", "visit"));
                }
                HashSet compilerFlags = Sets.newHashSet();
                compilerFlags.addAll(nativeLibrary.getCCompilerFlags());
                compilerFlags.addAll(nativeLibrary.getCppCompilerFlags());
                HashMap foundDangerousFlags = Maps.newHashMap();
                for (Map.Entry flag : DANGEROUS_COMPILER_FLAGS.entrySet()) {
                    if (!compilerFlags.contains(flag.getKey())) continue;
                    foundDangerousFlags.put(flag.getKey(), flag.getValue());
                }
                if (!foundDangerousFlags.isEmpty()) {
                    printer.stderr(String.format("Native library %s %s is using compiler flags which may be debug incompatible:", nativeLibrary.getAbi(), nativeLibrary.getName()));
                    for (Map.Entry flag : foundDangerousFlags.entrySet()) {
                        printer.stderr(String.format("%s: %s", flag.getKey(), flag.getValue()));
                    }
                }
            }
        });
    }

    @NotNull
    protected XExecutionStack newExecutionStack(@NotNull DebuggerDriver driver, @NotNull LLThread thread, boolean current, @Nullable CidrSuspensionCause suspensionCause) throws ExecutionException {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "newExecutionStack"));
        }
        if (thread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "newExecutionStack"));
        }
        if (System.getProperty("com.google.android-studio.lazy-backtraces", "yes").equals("yes")) {
            AndroidNativeExecutionStack androidNativeExecutionStack = new AndroidNativeExecutionStack(this, driver, thread, current, suspensionCause);
            if (androidNativeExecutionStack == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "newExecutionStack"));
            }
            return androidNativeExecutionStack;
        }
        XExecutionStack xExecutionStack = super.newExecutionStack(driver, thread, current, suspensionCause);
        if (xExecutionStack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "newExecutionStack"));
        }
        return xExecutionStack;
    }

    public void handleBreakpoint(int number, @NotNull List<LLThread> threads, int currentThreadIndex) {
        if (threads == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threads", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "handleBreakpoint"));
        }
        final XBreakpoint bp = this.myStepIntoNativeBreakpointHandler.getCodepoint(number);
        if (bp == null) {
            super.handleBreakpoint(number, threads, currentThreadIndex);
            return;
        }
        ((StepIntoNativeBreakpointType.Properties)bp.getProperties()).setCalled(true);
        AndroidNativeDebugProcess.getApp().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                AndroidNativeDebugProcess.getApp().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        AndroidNativeDebugProcess.this.removeStepIntoNativeBreakpoint(AndroidNativeDebugProcess.this.getBreakpointManager(), (XBreakpoint<StepIntoNativeBreakpointType.Properties>)bp);
                    }
                });
            }
        }, ModalityState.defaultModalityState());
        this.handleXBreakpoint(threads, currentThreadIndex, bp);
    }

    private void removeStepIntoNativeBreakpoint(XBreakpointManager bpManager, XBreakpoint<StepIntoNativeBreakpointType.Properties> bp) {
        bpManager.removeBreakpoint(bp);
        this.myStepIntoNativeBreakpointHandler.unregisterBreakpoint(bp, false);
    }

    @Override
    @NotNull
    public XBreakpoint<StepIntoNativeBreakpointType.Properties> registerStepIntoNativeBreakpoint(@NotNull String jniMethodName, int tid) {
        if (jniMethodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jniMethodName", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "registerStepIntoNativeBreakpoint"));
        }
        final StepIntoNativeBreakpointType.Properties props = new StepIntoNativeBreakpointType.Properties(jniMethodName, tid);
        final Ref bpRef = new Ref();
        AndroidNativeDebugProcess.getApp().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                AndroidNativeDebugProcess.getApp().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        XBreakpoint bp = AndroidNativeDebugProcess.this.getBreakpointManager().addBreakpoint((XBreakpointType)StepIntoNativeBreakpointType.INSTANCE, (XBreakpointProperties)props);
                        AndroidNativeDebugProcess.this.myStepIntoNativeBreakpointHandler.registerBreakpoint((XBreakpoint<StepIntoNativeBreakpointType.Properties>)bp);
                        bpRef.set((Object)bp);
                    }
                });
            }
        }, ModalityState.defaultModalityState());
        XBreakpoint xBreakpoint = (XBreakpoint)bpRef.get();
        if (xBreakpoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "registerStepIntoNativeBreakpoint"));
        }
        return xBreakpoint;
    }

    @Override
    public void removeAllStepIntoNativeBreakpoints() {
        final LinkedList bps = Lists.newLinkedList();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                bps.addAll(AndroidNativeDebugProcess.this.getBreakpointManager().getBreakpoints((XBreakpointType)StepIntoNativeBreakpointType.INSTANCE));
            }
        });
        if (bps.isEmpty()) {
            return;
        }
        AndroidNativeDebugProcess.getApp().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                AndroidNativeDebugProcess.getApp().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        XBreakpointManager bpManager = AndroidNativeDebugProcess.this.getBreakpointManager();
                        for (XBreakpoint bp : bps) {
                            AndroidNativeDebugProcess.this.removeStepIntoNativeBreakpoint(bpManager, (XBreakpoint<StepIntoNativeBreakpointType.Properties>)bp);
                        }
                    }
                });
            }
        }, ModalityState.defaultModalityState());
    }

    @Override
    public synchronized void setJavaSession(@NotNull XDebugSession javaSession) {
        if (javaSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaSession", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "setJavaSession"));
        }
        this.myJavaSession = javaSession;
    }

    @Nullable
    private synchronized XDebugSession getJavaSession() {
        return this.myJavaSession;
    }

    protected void handleCommandException(@NotNull ExecutionException e, @NotNull DebuggerDriver driver) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "handleCommandException"));
        }
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "handleCommandException"));
        }
        AndroidNativeDebugProcess.reportError(e);
        if (!AndroidLLDBBreakpadIntegration.checkForCrashes((AndroidLLDBDriver)driver)) {
            super.handleCommandException(e, driver);
        }
    }

    private static void reportError(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/ndk/run/AndroidNativeDebugProcess", "reportError"));
        }
        LLDBUsageTracker.trackSessionFailed(e);
    }

    private static interface NativeLibraryVisitor {
        public void visit(@NotNull NativeLibrary var1);
    }
}

