/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni;

import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import java.util.ArrayList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JniNameMangler {
    @Nullable
    public static PsiMethod findDeclaration(@NotNull Project project, @NotNull String jniMethodName) {
        PsiMethod[] methods;
        int methodEnd;
        int methodBegin;
        int classBegin;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/jni/JniNameMangler", "findDeclaration"));
        }
        if (jniMethodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jniMethodName", "com/android/tools/ndk/jni/JniNameMangler", "findDeclaration"));
        }
        if (!jniMethodName.startsWith("Java_")) {
            return null;
        }
        int pkgStart = "Java_".length();
        int length = jniMethodName.length();
        boolean lastWasUnderscore = false;
        for (classBegin = pkgStart; classBegin < length; ++classBegin) {
            char c = jniMethodName.charAt(classBegin);
            if (c == '_') {
                lastWasUnderscore = true;
                continue;
            }
            if (Character.isUpperCase(c) && lastWasUnderscore) break;
            lastWasUnderscore = false;
        }
        if ((methodBegin = jniMethodName.indexOf(95, classBegin) + 1) == 0) {
            return null;
        }
        lastWasUnderscore = true;
        while (methodBegin < length) {
            char c = jniMethodName.charAt(methodBegin);
            if (c == '_') {
                lastWasUnderscore = true;
            } else {
                if (Character.isLowerCase(c) && lastWasUnderscore) break;
                lastWasUnderscore = false;
            }
            ++methodBegin;
        }
        if ((methodEnd = jniMethodName.indexOf("__", methodBegin)) == -1) {
            methodEnd = length;
        }
        String pkg = classBegin > pkgStart ? JniNameMangler.jniDecodeUnderscore(jniMethodName.substring(pkgStart, classBegin - 1), true) : null;
        String cls = JniNameMangler.jniDecodeUnderscore(jniMethodName.substring(classBegin, methodBegin - 1), false);
        String methodName = JniNameMangler.jniDecodeUnderscore(jniMethodName.substring(methodBegin, methodEnd), false);
        String fqn = pkg != null ? pkg + '.' + cls : cls;
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass psiClass = psiFacade.findClass(fqn, GlobalSearchScope.allScope((Project)project));
        if (psiClass == null) {
            cls = cls.replace('_', '.');
            fqn = pkg != null ? pkg + '.' + cls : cls;
            psiClass = psiFacade.findClass(fqn, GlobalSearchScope.allScope((Project)project));
            if (psiClass == null) {
                return null;
            }
        }
        if ((methods = psiClass.findMethodsByName(methodName, false)).length == 1) {
            return methods[0];
        }
        ArrayList nativeMethods = Lists.newArrayListWithExpectedSize((int)methods.length);
        for (PsiMethod method : methods) {
            if (!method.hasModifierProperty("native")) continue;
            nativeMethods.add(method);
        }
        if (nativeMethods.size() == 1) {
            return (PsiMethod)nativeMethods.get(0);
        }
        if (nativeMethods.isEmpty()) {
            return null;
        }
        for (PsiMethod method : nativeMethods) {
            String escaped = JniNameMangler.getJniMethodName(method, true);
            if (!jniMethodName.equals(escaped)) continue;
            return method;
        }
        for (PsiMethod method : nativeMethods) {
            String escaped = JniNameMangler.getJniMethodName(method, false);
            if (!jniMethodName.equals(escaped)) continue;
            return method;
        }
        return (PsiMethod)nativeMethods.get(0);
    }

    static PsiMethod findDeclaration(@NotNull OCDeclarator element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/ndk/jni/JniNameMangler", "findDeclaration"));
        }
        String jniMethodName = element.getName();
        if (jniMethodName != null) {
            return JniNameMangler.findDeclaration(element.getProject(), jniMethodName);
        }
        return null;
    }

    @NotNull
    public static String getJniMethodName(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/android/tools/ndk/jni/JniNameMangler", "getJniMethodName"));
        }
        boolean overloaded = JniNameMangler.isOverloaded(method);
        String string = JniNameMangler.getJniMethodName(method, overloaded);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniMethodName"));
        }
        return string;
    }

    public static boolean isOverloaded(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/android/tools/ndk/jni/JniNameMangler", "isOverloaded"));
        }
        PsiClass containingClass = method.getContainingClass();
        return containingClass != null && containingClass.findMethodsByName(method.getName(), false).length > 1;
    }

    @NotNull
    public static String getJniMethodName(@NotNull PsiMethod method, boolean overloaded) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/android/tools/ndk/jni/JniNameMangler", "getJniMethodName"));
        }
        String string = JniNameMangler.getJniMethodName(JniNameMangler.getJniClassName(method.getContainingClass()), method.getName(), method.getParameterList().getParameters(), overloaded);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniMethodName"));
        }
        return string;
    }

    @NotNull
    public static String getJniMethodName(String jniClassName, String name, PsiParameter[] parameters, boolean overloaded) {
        StringBuilder sb = new StringBuilder();
        sb.append("Java_");
        sb.append(jniClassName);
        sb.append('_');
        sb.append(JniNameMangler.jniEncodeUnderscore(name, false));
        if (overloaded) {
            sb.append('_').append('_');
            for (PsiParameter parameter : parameters) {
                PsiType type = parameter.getType();
                type = TypeConversionUtil.erasure((PsiType)type);
                String internal = JniNameMangler.getJvmType(type);
                sb.append(JniNameMangler.jniEscape(internal));
            }
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniMethodName"));
        }
        return string;
    }

    @NotNull
    public static String getJniClassName(@Nullable PsiClass psiClass) {
        if (psiClass != null) {
            String qualifiedName = psiClass.getQualifiedName();
            if (qualifiedName != null) {
                String string = JniNameMangler.jniEncodeUnderscore(qualifiedName, true);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniClassName"));
                }
                return string;
            }
            String string = JniNameMangler.jniEncodeUnderscore(psiClass.getName(), false);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniClassName"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniClassName"));
        }
        return "";
    }

    public static String jniEncodeUnderscore(@NotNull String javaName, boolean isPackageName) {
        if (javaName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaName", "com/android/tools/ndk/jni/JniNameMangler", "jniEncodeUnderscore"));
        }
        if (isPackageName) {
            return javaName.replaceAll("_", "_1").replace('.', '_');
        }
        return javaName.replaceAll("_", "_1");
    }

    private static String jniDecodeUnderscore(@NotNull String nativeName, boolean isPackageName) {
        if (nativeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeName", "com/android/tools/ndk/jni/JniNameMangler", "jniDecodeUnderscore"));
        }
        if (isPackageName) {
            return nativeName.replace('_', '.').replaceAll("\\.1", "_");
        }
        return nativeName.replaceAll("_1", "_");
    }

    @NotNull
    public static String getJniType(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/ndk/jni/JniNameMangler", "getJniType"));
        }
        if (type == PsiType.VOID) {
            if ("void" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniType"));
            }
            return "void";
        }
        if (type == PsiType.BOOLEAN) {
            if ("jboolean" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniType"));
            }
            return "jboolean";
        }
        if (type == PsiType.INT) {
            if ("jint" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniType"));
            }
            return "jint";
        }
        if (type == PsiType.LONG) {
            if ("jlong" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniType"));
            }
            return "jlong";
        }
        if (type == PsiType.FLOAT) {
            if ("jfloat" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniType"));
            }
            return "jfloat";
        }
        if (type == PsiType.DOUBLE) {
            if ("jdouble" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniType"));
            }
            return "jdouble";
        }
        if (type == PsiType.BYTE) {
            if ("jbyte" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniType"));
            }
            return "jbyte";
        }
        if (type == PsiType.CHAR) {
            if ("jchar" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniType"));
            }
            return "jchar";
        }
        if (type == PsiType.SHORT) {
            if ("jshort" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniType"));
            }
            return "jshort";
        }
        if (type instanceof PsiArrayType) {
            if ((type = ((PsiArrayType)type).getComponentType()) == PsiType.BOOLEAN) {
                if ("jbooleanArray" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniType"));
                }
                return "jbooleanArray";
            }
            if (type == PsiType.INT) {
                if ("jintArray" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniType"));
                }
                return "jintArray";
            }
            if (type == PsiType.LONG) {
                if ("jlongArray" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniType"));
                }
                return "jlongArray";
            }
            if (type == PsiType.DOUBLE) {
                if ("jdoubleArray" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniType"));
                }
                return "jdoubleArray";
            }
            if (type == PsiType.CHAR) {
                if ("jcharArray" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniType"));
                }
                return "jcharArray";
            }
            if (type == PsiType.FLOAT) {
                if ("jfloatArray" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniType"));
                }
                return "jfloatArray";
            }
            if (type == PsiType.SHORT) {
                if ("jshortArray" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniType"));
                }
                return "jshortArray";
            }
            if (type == PsiType.BYTE) {
                if ("jbyteArray" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniType"));
                }
                return "jbyteArray";
            }
            if ("jobjectArray" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniType"));
            }
            return "jobjectArray";
        }
        if (JniNameMangler.isString(type)) {
            if ("jstring" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniType"));
            }
            return "jstring";
        }
        if (JniNameMangler.isClass(type)) {
            if ("jclass" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniType"));
            }
            return "jclass";
        }
        if (JniNameMangler.isThrowable(type)) {
            if ("jthrowable" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniType"));
            }
            return "jthrowable";
        }
        if ("jobject" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJniType"));
        }
        return "jobject";
    }

    @Contract(value="null -> false")
    public static boolean isClass(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/ndk/jni/JniNameMangler", "isClass"));
        }
        return "java.lang.Class".equals(type.getCanonicalText());
    }

    @Contract(value="null -> false")
    public static boolean isString(@NotNull PsiType type) {
        String shortName;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/ndk/jni/JniNameMangler", "isString"));
        }
        if (type instanceof PsiClassType && !Comparing.equal((String)(shortName = ((PsiClassType)type).getClassName()), (String)"String")) {
            return false;
        }
        return "java.lang.String".equals(type.getCanonicalText());
    }

    @Contract(value="null -> false")
    public static boolean isThrowable(@Nullable PsiType type) {
        return type != null && InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.Throwable");
    }

    @NotNull
    private static String getJvmType(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/ndk/jni/JniNameMangler", "getJvmType"));
        }
        if (PsiType.BOOLEAN == type) {
            if ("Z" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJvmType"));
            }
            return "Z";
        }
        if (PsiType.BYTE == type) {
            if ("B" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJvmType"));
            }
            return "B";
        }
        if (PsiType.CHAR == type) {
            if ("C" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJvmType"));
            }
            return "C";
        }
        if (PsiType.SHORT == type) {
            if ("S" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJvmType"));
            }
            return "S";
        }
        if (PsiType.INT == type) {
            if ("I" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJvmType"));
            }
            return "I";
        }
        if (PsiType.LONG == type) {
            if ("J" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJvmType"));
            }
            return "J";
        }
        if (PsiType.FLOAT == type) {
            if ("F" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJvmType"));
            }
            return "F";
        }
        if (PsiType.DOUBLE == type) {
            if ("D" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJvmType"));
            }
            return "D";
        }
        if (PsiType.VOID == type) {
            if ("V" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJvmType"));
            }
            return "V";
        }
        String string = "L" + type.getCanonicalText().replace('.', '/') + ";";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniNameMangler", "getJvmType"));
        }
        return string;
    }

    static String jniEscape(String name) {
        int len = name.length();
        StringBuilder sb = new StringBuilder(len);
        block6: for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                sb.append(c);
                continue;
            }
            switch (c) {
                case '.': 
                case '/': {
                    sb.append('_');
                    continue block6;
                }
                case '_': {
                    sb.append('_').append('1');
                    continue block6;
                }
                case ';': {
                    sb.append('_').append('2');
                    continue block6;
                }
                case '[': {
                    sb.append('_').append('3');
                    continue block6;
                }
                default: {
                    sb.append('_').append('0');
                    sb.append((int)c);
                }
            }
        }
        return sb.toString();
    }
}

