/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.compiler.CidrCompilerResult;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.toolchains.CompilerInfoCache;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NdkCompilerInfoCache {
    private final CompilerInfoCache myCompilerInfoCache = new CompilerInfoCache();

    @NotNull
    public NdkCompilerInfo getCompilerInfo(@NotNull Project project, @NotNull OCCompilerSettings compilerSettings, @NotNull OCLanguageKind lang, @Nullable VirtualFile sourceFile) throws NdkCompilerInvocationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/NdkCompilerInfoCache", "getCompilerInfo"));
        }
        if (compilerSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerSettings", "com/android/tools/ndk/NdkCompilerInfoCache", "getCompilerInfo"));
        }
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/android/tools/ndk/NdkCompilerInfoCache", "getCompilerInfo"));
        }
        CidrCompilerResult compilerResult = this.myCompilerInfoCache.getCompilerInfoCache(project, compilerSettings, lang, sourceFile);
        CompilerInfoCache.Entry compilerInfo = (CompilerInfoCache.Entry)compilerResult.getResult();
        if (compilerInfo == null) {
            Throwable error = compilerResult.getError();
            if (error != null) {
                throw new NdkCompilerInvocationException(error);
            }
            throw new NdkCompilerInvocationException("Failed to get the compiler information for file " + sourceFile.getPath());
        }
        NdkCompilerInfo ndkCompilerInfo = new NdkCompilerInfo(compilerInfo);
        if (ndkCompilerInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/NdkCompilerInfoCache", "getCompilerInfo"));
        }
        return ndkCompilerInfo;
    }

    public static class NdkCompilerInvocationException
    extends Exception {
        private NdkCompilerInvocationException(String message) {
            super(message);
        }

        private NdkCompilerInvocationException(Throwable cause) {
            super(cause);
        }
    }

    public static class NdkCompilerInfo {
        @NotNull
        private final CompilerInfoCache.Entry myInfo;

        private NdkCompilerInfo(@NotNull CompilerInfoCache.Entry info) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/android/tools/ndk/NdkCompilerInfoCache$NdkCompilerInfo", "<init>"));
            }
            this.myInfo = info;
        }

        @NotNull
        public String getDefines() {
            String string = this.myInfo.defines;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/NdkCompilerInfoCache$NdkCompilerInfo", "getDefines"));
            }
            return string;
        }

        @NotNull
        public Map<String, String> getFeatures() {
            Map map = this.myInfo.features;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/NdkCompilerInfoCache$NdkCompilerInfo", "getFeatures"));
            }
            return map;
        }

        @NotNull
        public Map<String, String> getExtensions() {
            Map map = this.myInfo.extensions;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/NdkCompilerInfoCache$NdkCompilerInfo", "getExtensions"));
            }
            return map;
        }

        @NotNull
        public List<HeadersSearchRoot> getHeaderSearchPaths() {
            List list = this.myInfo.headerSearchPaths;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/NdkCompilerInfoCache$NdkCompilerInfo", "getHeaderSearchPaths"));
            }
            return list;
        }
    }
}

