/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repositoryv2.meta.DetailsTypes;
import com.android.tools.idea.sdkv2.StudioLoggerProgressIndicator;
import com.android.tools.ndk.run.lldb.LLDBSdkPkgInstaller;
import com.intellij.openapi.application.PathManager;
import java.io.File;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;

public class ModulePathManager {
    @NotNull
    public static File getRepoLLDBBinFile(@NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/android/tools/ndk/ModulePathManager", "getRepoLLDBBinFile"));
        }
        File lldbBin = new File(PathManager.getBinPath(), "lldb");
        File file = new File(lldbBin, relativePath);
        if (file.exists()) {
            File file2 = file;
            if (file2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/ModulePathManager", "getRepoLLDBBinFile"));
            }
            return file2;
        }
        File file3 = new File(new File(PathManager.getHomePath(), "../vendor/google/android-ndk/bin/lldb"), relativePath);
        if (file3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/ModulePathManager", "getRepoLLDBBinFile"));
        }
        return file3;
    }

    @NotNull
    public static File getSdkLLDBDir() {
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(ModulePathManager.class);
        String path = DetailsTypes.getLldbPath((Revision)LLDBSdkPkgInstaller.PINNED_REVISION);
        LocalPackage p = AndroidSdkUtils.tryToChooseSdkHandler().getLocalPackage(path, (ProgressIndicator)progress);
        if (p == null) {
            throw new IllegalStateException("LLDB package hasn't been found");
        }
        File file = p.getLocation();
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/ModulePathManager", "getSdkLLDBDir"));
        }
        return file;
    }

    @NotNull
    public static File getSdkLLDBFile(@NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/android/tools/ndk/ModulePathManager", "getSdkLLDBFile"));
        }
        File file = new File(ModulePathManager.getSdkLLDBDir(), relativePath);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/ModulePathManager", "getSdkLLDBFile"));
        }
        return file;
    }

    @NotNull
    public static File getSdkLLDBAndroidFile(@NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/android/tools/ndk/ModulePathManager", "getSdkLLDBAndroidFile"));
        }
        File file = new File(new File(ModulePathManager.getSdkLLDBDir(), "android"), relativePath);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/ModulePathManager", "getSdkLLDBAndroidFile"));
        }
        return file;
    }

    @NotNull
    public static File getRepoLLDBSharedBinFile(@NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/android/tools/ndk/ModulePathManager", "getRepoLLDBSharedBinFile"));
        }
        File file = ModulePathManager.getRepoLLDBBinFile(new File("shared", relativePath).getPath());
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/ModulePathManager", "getRepoLLDBSharedBinFile"));
        }
        return file;
    }

    @NotNull
    public static File getRepoLLDBStlPrintersFolder() {
        File file = ModulePathManager.getRepoLLDBSharedBinFile("stl_printers");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/ModulePathManager", "getRepoLLDBStlPrintersFolder"));
        }
        return file;
    }

    @NotNull
    public static File getRepoLLDBStlPrintersBinFile(@NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/android/tools/ndk/ModulePathManager", "getRepoLLDBStlPrintersBinFile"));
        }
        File file = new File(ModulePathManager.getRepoLLDBStlPrintersFolder(), relativePath);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/ModulePathManager", "getRepoLLDBStlPrintersBinFile"));
        }
        return file;
    }
}

