/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.android.builder.model.NativeFolder;
import com.android.builder.model.NativeLibrary;
import com.android.builder.model.NativeSettings;
import com.android.builder.model.NativeToolchain;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.NativeAndroidGradleModel;
import com.android.tools.idea.gradle.facet.NativeAndroidGradleFacet;
import com.android.tools.idea.gradle.messages.Message;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.service.notification.errors.NdkLocationNotFoundErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.sdk.SdkPaths;
import com.android.tools.idea.stats.UsageTracker;
import com.android.tools.ndk.ModuleResolveConfiguration;
import com.android.tools.ndk.NdkCompilerInfoCache;
import com.android.tools.ndk.run.AndroidNativeRunConfiguration;
import com.android.tools.ndk.run.AndroidNativeRunConfigurationType;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiFileSystemItem;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeaderRoots;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleWorkspace
extends AbstractProjectComponent
implements OCWorkspace {
    private static final String GRADLE_LANGUAGE_TYPE_C = "c";
    private static final String GRADLE_LANGUAGE_TYPE_CPP = "c++";
    private static final Logger LOG = Logger.getInstance(GradleWorkspace.class);
    @NotNull
    private final NdkCompilerInfoCache myCompilerInfoCache;
    @NotNull
    private final OCWorkspaceModificationTrackers myTrackers;
    @NotNull
    private final Map<String, OCLanguageKind> myProjectFileExtensions;
    @NotNull
    private Set<VirtualFile> myProjectJniFiles;
    @NotNull
    private Map<String, ModuleResolveConfiguration> myResolveConfigurations;

    @NotNull
    public static GradleWorkspace getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/GradleWorkspace", "getInstance"));
        }
        GradleWorkspace instance = (GradleWorkspace)((Object)project.getComponent(GradleWorkspace.class));
        assert (instance != null);
        GradleWorkspace gradleWorkspace = instance;
        if (gradleWorkspace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/GradleWorkspace", "getInstance"));
        }
        return gradleWorkspace;
    }

    public GradleWorkspace(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/GradleWorkspace", "<init>"));
        }
        super(project);
        this.myCompilerInfoCache = new NdkCompilerInfoCache();
        this.myProjectFileExtensions = Maps.newHashMap();
        this.myProjectJniFiles = ImmutableSet.of();
        this.myResolveConfigurations = ImmutableMap.of();
        if (!Projects.isBuildWithGradle((Project)project)) {
            GradleWorkspace.setCppSupportDisabled(project, true);
        }
        this.myTrackers = new OCWorkspaceModificationTrackers(project);
        GradleSyncState.subscribe((Project)this.myProject, (GradleSyncListener)new GradleSyncListener.Adapter(){

            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/GradleWorkspace$1", "syncSucceeded"));
                }
                GradleWorkspace.this.scheduleGradleWorkspaceUpdate();
            }

            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/GradleWorkspace$1", "syncFailed"));
                }
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/ndk/GradleWorkspace$1", "syncFailed"));
                }
                GradleWorkspace.this.scheduleGradleWorkspaceUpdate();
            }

            public void syncSkipped(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/GradleWorkspace$1", "syncSkipped"));
                }
                GradleWorkspace.this.scheduleGradleWorkspaceUpdate();
            }
        });
    }

    private static void setCppSupportDisabled(@NotNull Project project, boolean disabled) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/GradleWorkspace", "setCppSupportDisabled"));
        }
        project.putUserData(OCLanguage.LANGUAGE_SUPPORT_DISABLED, (Object)disabled);
    }

    private void scheduleGradleWorkspaceUpdate() {
        this.myProjectFileExtensions.clear();
        this.myProjectJniFiles = ImmutableSet.of();
        this.myResolveConfigurations = ImmutableMap.of();
        new Task.Backgroundable(this.myProject, "Resolving C/C++ Configurations", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/ndk/GradleWorkspace$2", "run"));
                }
                GradleWorkspace.this.updateGradleWorkspace(indicator);
            }
        }.queue();
    }

    private void updateGradleWorkspace(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/ndk/GradleWorkspace", "updateGradleWorkspace"));
        }
        indicator.setIndeterminate(true);
        String incompatibleModelVersion = GradleWorkspace.getModelVersionIfIncompatible(this.myProject);
        boolean isNdkSpecified = this.isNdkDefined() && SdkPaths.validateAndroidNdk((File)this.getNdkPath(), (boolean)false).success;
        HashSet projectJniFiles = Sets.newHashSet();
        HashMap projectResolveConfigurations = Maps.newHashMap();
        ArrayList nativeAppModules = Lists.newArrayList();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            Object moduleFileExtensions;
            Map<String, ModuleResolveConfiguration> moduleResolveConfigurations;
            Set<Object> moduleJniFiles = Sets.newHashSet();
            AndroidFacet facet = AndroidFacet.getInstance((Module)module);
            if (facet != null) {
                AndroidGradleModel androidModel = AndroidGradleModel.get((AndroidFacet)facet);
                if (androidModel == null) continue;
                moduleJniFiles = GradleWorkspace.getJniFiles(GradleWorkspace.getJniDirectories(facet));
                moduleResolveConfigurations = GradleWorkspace.getResolveConfigurations(this.myProject, this.myCompilerInfoCache, androidModel);
                moduleFileExtensions = ImmutableMap.of();
                if (!moduleJniFiles.isEmpty() && !moduleResolveConfigurations.isEmpty()) {
                    nativeAppModules.add(module);
                }
            } else {
                NativeAndroidGradleModel nativeAndroidModel;
                NativeAndroidGradleFacet nativeAndroidFacet = NativeAndroidGradleFacet.getInstance((Module)module);
                if (nativeAndroidFacet == null || (nativeAndroidModel = NativeAndroidGradleModel.get((NativeAndroidGradleFacet)nativeAndroidFacet)) == null) continue;
                NativeAndroidProject nativeAndroidProject = nativeAndroidModel.getNativeAndroidProject();
                for (NativeArtifact artifact : nativeAndroidProject.getArtifacts()) {
                    VirtualFile virtualFile;
                    for (NativeFolder folder : artifact.getSourceFolders()) {
                        virtualFile = VfsUtil.findFileByIoFile((File)folder.getFolderPath(), (boolean)true);
                        if (virtualFile == null) continue;
                        moduleJniFiles.addAll(GradleWorkspace.getJniFiles((Set<VirtualFile>)ImmutableSet.of((Object)virtualFile)));
                    }
                    for (NativeFile file : artifact.getSourceFiles()) {
                        virtualFile = VfsUtil.findFileByIoFile((File)file.getFilePath(), (boolean)true);
                        if (virtualFile == null) continue;
                        moduleJniFiles.add(virtualFile);
                    }
                }
                moduleResolveConfigurations = GradleWorkspace.getResolveConfigurations(this.myProject, this.myCompilerInfoCache, nativeAndroidModel);
                moduleFileExtensions = GradleWorkspace.getFileExtensions(nativeAndroidModel);
            }
            if (!moduleJniFiles.isEmpty()) {
                if (incompatibleModelVersion != null) {
                    GradleWorkspace.addModelVersionIncompatibilityNotification(incompatibleModelVersion, this.myProject);
                    return;
                }
                if (!isNdkSpecified) {
                    this.addNdkNotSpecifiedNotification(this.myProject, this.isNdkDefined());
                    return;
                }
            }
            projectJniFiles.addAll(moduleJniFiles);
            projectResolveConfigurations.putAll(moduleResolveConfigurations);
            this.myProjectFileExtensions.putAll((Map<String, OCLanguageKind>)moduleFileExtensions);
        }
        this.myProjectJniFiles = ImmutableSet.copyOf((Collection)projectJniFiles);
        this.myResolveConfigurations = ImmutableMap.copyOf((Map)projectResolveConfigurations);
        boolean isValidNdkProject = !this.myProjectJniFiles.isEmpty() && !this.myResolveConfigurations.isEmpty();
        GradleWorkspace.setCppSupportDisabled(this.myProject, !isValidNdkProject);
        if (isValidNdkProject) {
            UsageTracker.getInstance().trackEvent("gradle", "cppSyncCompleted", null, null);
        }
        new ReadAction(){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/ndk/GradleWorkspace$3", "run"));
                }
                if (GradleWorkspace.this.myProject.isDisposed()) {
                    return;
                }
                GradleWorkspace.this.myTrackers.getProjectFilesListTracker().incModificationCount();
                GradleWorkspace.this.myTrackers.getSourceFilesListTracker().incModificationCount();
                GradleWorkspace.this.myTrackers.getBuildConfigurationChangesTracker().incModificationCount();
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    GradleWorkspace.this.myTrackers.getBuildSettingsChangesTracker().incModificationCount();
                }
            }
        }.execute();
        AndroidProjectInfo projectInfo = AndroidProjectInfo.get((Project)this.myProject);
        projectInfo.setHasNativeModules(!nativeAppModules.isEmpty());
        GradleWorkspace.createAndroidNativeRunConfigurations(this.myProject, nativeAppModules);
    }

    @Nullable
    private static String getModelVersionIfIncompatible(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/GradleWorkspace", "getModelVersionIfIncompatible"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidProject androidProject;
            String version;
            AndroidGradleModel androidModel;
            AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module);
            if (androidFacet == null || (androidModel = AndroidGradleModel.get((AndroidFacet)androidFacet)) == null || (version = GradleWorkspace.getModelVersionIfIncompatible(androidProject = androidModel.getAndroidProject())) == null) continue;
            return version;
        }
        return null;
    }

    private static void addModelVersionIncompatibilityNotification(@NotNull String modelVersion, @NotNull Project project) {
        if (modelVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelVersion", "com/android/tools/ndk/GradleWorkspace", "addModelVersionIncompatibilityNotification"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/GradleWorkspace", "addModelVersionIncompatibilityNotification"));
        }
        String text = String.format("Android plugin version %1$s is not compatible with the NDK support. ", modelVersion) + "Please use the experimental plugin.";
        ProjectSyncMessages.getInstance((Project)project).add(new Message("Gradle Sync Issue", Message.Type.WARNING, new String[]{text}), new NotificationHyperlink[0]);
        String title = "Incompatible Android Plugin Version";
        AndroidGradleNotification.getInstance((Project)project).showBalloon(title, text, NotificationType.WARNING);
    }

    private void addNdkNotSpecifiedNotification(@NotNull Project project, boolean isNdkDefined) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/GradleWorkspace", "addNdkNotSpecifiedNotification"));
        }
        boolean ndkInSdk = this.isNdkInSdk();
        NotificationHyperlink downloadLink = NdkLocationNotFoundErrorHandler.getSelectNdkNotificationHyperlink((!ndkInSdk ? 1 : 0) != 0);
        AndroidGradleNotification.getInstance((Project)project).showBalloon("Project Sync Error", String.format("Android NDK location is not %1$s.", isNdkDefined ? "valid" : "specified"), NotificationType.ERROR, new NotificationHyperlink[]{downloadLink});
    }

    @NotNull
    private static Set<VirtualFile> getJniDirectories(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/ndk/GradleWorkspace", "getJniDirectories"));
        }
        HashSet jniDirectories = Sets.newHashSet();
        for (IdeaSourceProvider provider : IdeaSourceProvider.getAllIdeaSourceProviders((AndroidFacet)facet)) {
            jniDirectories.addAll(provider.getJniDirectories());
        }
        HashSet hashSet = jniDirectories;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/GradleWorkspace", "getJniDirectories"));
        }
        return hashSet;
    }

    @NotNull
    private static Set<VirtualFile> getJniFiles(@NotNull Set<VirtualFile> jniDirectories) {
        if (jniDirectories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jniDirectories", "com/android/tools/ndk/GradleWorkspace", "getJniFiles"));
        }
        final HashSet jniFiles = Sets.newHashSet();
        for (VirtualFile directory : jniDirectories) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)directory, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/ndk/GradleWorkspace$4", "visitFile"));
                    }
                    if (file.getFileType() == OCFileType.INSTANCE) {
                        jniFiles.add(file);
                    }
                    return true;
                }
            });
        }
        HashSet hashSet = jniFiles;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/GradleWorkspace", "getJniFiles"));
        }
        return hashSet;
    }

    @NotNull
    private static Map<String, ModuleResolveConfiguration> getResolveConfigurations(@NotNull Project project, @NotNull NdkCompilerInfoCache compilerInfoCache, @NotNull AndroidGradleModel androidModel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/GradleWorkspace", "getResolveConfigurations"));
        }
        if (compilerInfoCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerInfoCache", "com/android/tools/ndk/GradleWorkspace", "getResolveConfigurations"));
        }
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/ndk/GradleWorkspace", "getResolveConfigurations"));
        }
        HashMap configurations = Maps.newHashMap();
        AndroidProject androidProject = androidModel.getAndroidProject();
        Map<String, NativeToolchain> toolchains = GradleWorkspace.getToolchainsByName(androidProject);
        for (Variant variant : androidProject.getVariants()) {
            Collection<NativeLibrary> nativeLibraries = GradleWorkspace.getNativeLibraries(variant, androidProject);
            for (NativeLibrary library : nativeLibraries) {
                NativeToolchain toolchain = toolchains.get(library.getToolchainName());
                String key = GradleWorkspace.getResolvedConfigurationKey(androidModel.getModuleName(), variant.getName(), library.getAbi());
                if (toolchain == null || configurations.containsKey(key)) continue;
                ModuleResolveConfiguration configuration = new ModuleResolveConfiguration(project, androidModel.getRootDirPath(), compilerInfoCache, library, toolchain);
                configurations.put(key, configuration);
            }
        }
        HashMap hashMap = configurations;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/GradleWorkspace", "getResolveConfigurations"));
        }
        return hashMap;
    }

    @NotNull
    private static Map<String, NativeToolchain> getToolchainsByName(@NotNull AndroidProject androidProject) {
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/ndk/GradleWorkspace", "getToolchainsByName"));
        }
        if (GradleWorkspace.isModelVersionIncompatible(androidProject)) {
            Map<String, NativeToolchain> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/GradleWorkspace", "getToolchainsByName"));
            }
            return map;
        }
        HashMap toolchains = Maps.newHashMap();
        for (NativeToolchain toolchain : androidProject.getNativeToolchains()) {
            toolchains.put(toolchain.getName(), toolchain);
        }
        HashMap hashMap = toolchains;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/GradleWorkspace", "getToolchainsByName"));
        }
        return hashMap;
    }

    @NotNull
    private static String getResolvedConfigurationKey(String ... keyElements) {
        if (keyElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyElements", "com/android/tools/ndk/GradleWorkspace", "getResolvedConfigurationKey"));
        }
        String string = Joiner.on((char)':').join((Object[])keyElements);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/GradleWorkspace", "getResolvedConfigurationKey"));
        }
        return string;
    }

    private static void createAndroidNativeRunConfigurations(@NotNull Project project, @NotNull List<Module> nativeModules) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/GradleWorkspace", "createAndroidNativeRunConfigurations"));
        }
        if (nativeModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeModules", "com/android/tools/ndk/GradleWorkspace", "createAndroidNativeRunConfigurations"));
        }
        for (Module module : nativeModules) {
            AndroidFacet facet = AndroidFacet.getInstance((Module)module);
            if (facet == null || facet.isLibraryProject()) continue;
            RunManager runManager = RunManager.getInstance((Project)project);
            ConfigurationFactory configurationFactory = AndroidNativeRunConfigurationType.getInstance().getFactory();
            List configs = runManager.getConfigurationsList(configurationFactory.getType());
            boolean found = false;
            for (RunConfiguration config : configs) {
                AndroidNativeRunConfiguration androidNativeRunConfig;
                if (!(config instanceof AndroidNativeRunConfiguration) || ((JavaRunConfigurationModule)(androidNativeRunConfig = (AndroidNativeRunConfiguration)config).getConfigurationModule()).getModule() != module) continue;
                found = true;
                break;
            }
            if (found) continue;
            RunnerAndConfigurationSettings settings = runManager.createRunConfiguration(module.getName() + "-native", configurationFactory);
            AndroidNativeRunConfiguration configuration = (AndroidNativeRunConfiguration)settings.getConfiguration();
            configuration.setModule(module);
            configuration.setTargetSelectionMode(TargetSelectionMode.SHOW_DIALOG);
            runManager.addConfiguration(settings, false);
        }
    }

    @NotNull
    private static Map<String, ModuleResolveConfiguration> getResolveConfigurations(@NotNull Project project, @NotNull NdkCompilerInfoCache compilerInfoCache, @NotNull NativeAndroidGradleModel nativeAndroidModel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/GradleWorkspace", "getResolveConfigurations"));
        }
        if (compilerInfoCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerInfoCache", "com/android/tools/ndk/GradleWorkspace", "getResolveConfigurations"));
        }
        if (nativeAndroidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeAndroidModel", "com/android/tools/ndk/GradleWorkspace", "getResolveConfigurations"));
        }
        HashMap configurations = Maps.newHashMap();
        for (NativeAndroidGradleModel.NativeVariant variant : nativeAndroidModel.getVariants()) {
            for (NativeArtifact artifact : variant.getArtifacts()) {
                NativeToolchain toolchain = nativeAndroidModel.findToolchain(artifact.getToolChain());
                if (toolchain == null) continue;
                Set<String> settingsNames = GradleWorkspace.getSettingsNames(artifact);
                for (String settingsName : settingsNames) {
                    NativeSettings settings = nativeAndroidModel.findSettings(settingsName);
                    if (settings == null) continue;
                    String key = GradleWorkspace.getResolvedConfigurationKey(nativeAndroidModel.getModuleName(), artifact.getName(), toolchain.getName(), settings.getName());
                    if (configurations.containsKey(key)) continue;
                    ModuleResolveConfiguration configuration = new ModuleResolveConfiguration(project, nativeAndroidModel.getRootDirPath(), compilerInfoCache, toolchain, artifact, settings);
                    configurations.put(key, configuration);
                }
            }
        }
        HashMap hashMap = configurations;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/GradleWorkspace", "getResolveConfigurations"));
        }
        return hashMap;
    }

    @NotNull
    private static Set<String> getSettingsNames(@NotNull NativeArtifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/ndk/GradleWorkspace", "getSettingsNames"));
        }
        HashSet settingsNames = Sets.newHashSet();
        for (NativeFolder folder : artifact.getSourceFolders()) {
            settingsNames.addAll(folder.getPerLanguageSettings().values());
        }
        for (NativeFile file : artifact.getSourceFiles()) {
            settingsNames.add(file.getSettingsName());
        }
        HashSet hashSet = settingsNames;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/GradleWorkspace", "getSettingsNames"));
        }
        return hashSet;
    }

    @NotNull
    private static Map<String, OCLanguageKind> getFileExtensions(@NotNull NativeAndroidGradleModel nativeAndroidModel) {
        if (nativeAndroidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeAndroidModel", "com/android/tools/ndk/GradleWorkspace", "getFileExtensions"));
        }
        HashMap fileExtensions = Maps.newHashMap();
        for (Map.Entry entry : nativeAndroidModel.getNativeAndroidProject().getFileExtensions().entrySet()) {
            String fileExtension = (String)entry.getKey();
            String languageType = (String)entry.getValue();
            OCLanguageKind languageKind = null;
            if (GRADLE_LANGUAGE_TYPE_C.equals(languageType)) {
                languageKind = OCLanguageKind.C;
            } else if (GRADLE_LANGUAGE_TYPE_CPP.equals(languageType)) {
                languageKind = OCLanguageKind.CPP;
            }
            if (languageKind == null) {
                LOG.warn(String.format("Unknown language type '%1$s' found in '%2$s'", languageType, nativeAndroidModel.getModuleName()));
                continue;
            }
            fileExtensions.put(fileExtension, languageKind);
        }
        HashMap hashMap = fileExtensions;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/GradleWorkspace", "getFileExtensions"));
        }
        return hashMap;
    }

    public boolean isNdkDefined() {
        return this.getNdkPath() != null;
    }

    @Nullable
    public File getNdkPath() {
        try {
            return new LocalProperties(this.myProject).getAndroidNdkPath();
        }
        catch (IOException e) {
            String msg = String.format("Unable to read local.properties file of Project '%1$s'", this.myProject.getName());
            LOG.info(msg, (Throwable)e);
            return null;
        }
    }

    @Nullable
    public File getSdkPath() {
        try {
            return new LocalProperties(this.myProject).getAndroidSdkPath();
        }
        catch (IOException e) {
            String msg = String.format("Unable to read local.properties file of Project '%1$s'", this.myProject.getName());
            LOG.info(msg, (Throwable)e);
            return null;
        }
    }

    private boolean isNdkInSdk() {
        return this.getNdkPath() != null && FileUtil.filesEqual((File)this.getNdkPath().getParentFile(), (File)this.getSdkPath());
    }

    public boolean isInSDK(@Nullable VirtualFile file) {
        return false;
    }

    public boolean areFromSameProject(@Nullable VirtualFile a, @Nullable VirtualFile b) {
        return false;
    }

    public boolean areFromSamePackage(@Nullable VirtualFile a, @Nullable VirtualFile b) {
        return false;
    }

    public boolean isFromWrongSDK(@NotNull OCSymbol symbol, @Nullable VirtualFile contextFile) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/android/tools/ndk/GradleWorkspace", "isFromWrongSDK"));
        }
        return false;
    }

    @NotNull
    public Collection<VirtualFile> getLibraryFilesToBuildSymbols() {
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/GradleWorkspace", "getLibraryFilesToBuildSymbols"));
        }
        return list;
    }

    @NotNull
    public List<? extends OCResolveConfiguration> getConfigurations() {
        ArrayList arrayList = Lists.newArrayList(this.myResolveConfigurations.values());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/GradleWorkspace", "getConfigurations"));
        }
        return arrayList;
    }

    @NotNull
    public List<? extends OCResolveConfiguration> getConfigurationsForFile(@Nullable VirtualFile file) {
        if (file == null || !file.isValid() || this.myResolveConfigurations.isEmpty()) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/GradleWorkspace", "getConfigurationsForFile"));
            }
            return immutableList;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.myProject);
        if (module == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/GradleWorkspace", "getConfigurationsForFile"));
            }
            return immutableList;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module);
        if (androidFacet != null) {
            List<? extends OCResolveConfiguration> list = this.getResolvedConfigurations(module, androidFacet);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/GradleWorkspace", "getConfigurationsForFile"));
            }
            return list;
        }
        NativeAndroidGradleFacet nativeAndroidFacet = NativeAndroidGradleFacet.getInstance((Module)module);
        if (nativeAndroidFacet != null) {
            List<? extends OCResolveConfiguration> list = this.getResolvedConfigurations(file, module, nativeAndroidFacet);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/GradleWorkspace", "getConfigurationsForFile"));
            }
            return list;
        }
        ArrayList configurations = Lists.newArrayList();
        block0: for (ModuleResolveConfiguration configuration : this.myResolveConfigurations.values()) {
            HeaderRoots headerRoots = configuration.getLibraryHeadersRoots(new OCResolveRootAndConfiguration(null, file));
            for (PsiFileSystemItem root : headerRoots.getRoots()) {
                VirtualFile rootFile = root.getVirtualFile();
                if (rootFile == null || !VfsUtilCore.isAncestor((VirtualFile)rootFile, (VirtualFile)file, (boolean)true)) continue;
                configurations.add(configuration);
                continue block0;
            }
        }
        ImmutableList immutableList = ImmutableList.copyOf((Collection)configurations);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/GradleWorkspace", "getConfigurationsForFile"));
        }
        return immutableList;
    }

    @NotNull
    private List<? extends OCResolveConfiguration> getResolvedConfigurations(@NotNull Module module, @NotNull AndroidFacet androidFacet) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/ndk/GradleWorkspace", "getResolvedConfigurations"));
        }
        if (androidFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidFacet", "com/android/tools/ndk/GradleWorkspace", "getResolvedConfigurations"));
        }
        AndroidGradleModel androidModel = AndroidGradleModel.get((AndroidFacet)androidFacet);
        if (androidModel == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/GradleWorkspace", "getResolvedConfigurations"));
            }
            return immutableList;
        }
        ArrayList configurations = Lists.newArrayList();
        Variant variant = androidModel.getSelectedVariant();
        Collection<NativeLibrary> nativeLibraries = GradleWorkspace.getNativeLibraries(variant, androidModel.getAndroidProject());
        for (NativeLibrary nativeLibrary : nativeLibraries) {
            String key = GradleWorkspace.getResolvedConfigurationKey(module.getName(), variant.getName(), nativeLibrary.getAbi());
            ModuleResolveConfiguration configuration = this.myResolveConfigurations.get(key);
            if (configuration == null) continue;
            configurations.add(configuration);
        }
        ArrayList arrayList = configurations;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/GradleWorkspace", "getResolvedConfigurations"));
        }
        return arrayList;
    }

    private List<? extends OCResolveConfiguration> getResolvedConfigurations(@NotNull VirtualFile file, @NotNull Module module, @NotNull NativeAndroidGradleFacet nativeAndroidFacet) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/ndk/GradleWorkspace", "getResolvedConfigurations"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/ndk/GradleWorkspace", "getResolvedConfigurations"));
        }
        if (nativeAndroidFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeAndroidFacet", "com/android/tools/ndk/GradleWorkspace", "getResolvedConfigurations"));
        }
        NativeAndroidGradleModel nativeAndroidModel = nativeAndroidFacet.getNativeAndroidGradleModel();
        if (nativeAndroidModel == null) {
            return ImmutableList.of();
        }
        HashMap configurations = Maps.newHashMap();
        for (NativeArtifact artifact : nativeAndroidModel.getSelectedVariant().getArtifacts()) {
            for (NativeFile sourceFile : artifact.getSourceFiles()) {
                ModuleResolveConfiguration configuration;
                String key;
                if (!sourceFile.getFilePath().getPath().equals(file.getPath()) || configurations.containsKey(key = GradleWorkspace.getResolvedConfigurationKey(module.getName(), artifact.getName(), artifact.getToolChain(), sourceFile.getSettingsName())) || (configuration = this.myResolveConfigurations.get(key)) == null) continue;
                configurations.put(key, configuration);
            }
            for (NativeFolder sourceFolder : artifact.getSourceFolders()) {
                ModuleResolveConfiguration configuration;
                String key;
                String settingsName;
                String languageType;
                if (!FileUtil.isAncestor((String)sourceFolder.getFolderPath().getPath(), (String)file.getPath(), (boolean)true) || (languageType = (String)nativeAndroidModel.getNativeAndroidProject().getFileExtensions().get(FileUtilRt.getExtension((String)file.getName()))) == null || (settingsName = (String)sourceFolder.getPerLanguageSettings().get(languageType)) == null || configurations.containsKey(key = GradleWorkspace.getResolvedConfigurationKey(module.getName(), artifact.getName(), artifact.getToolChain(), settingsName)) || (configuration = this.myResolveConfigurations.get(key)) == null) continue;
                configurations.put(key, configuration);
            }
        }
        return ImmutableList.copyOf(configurations.values());
    }

    @NotNull
    private static Collection<NativeLibrary> getNativeLibraries(@NotNull Variant variant, @NotNull AndroidProject androidProject) {
        if (variant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/android/tools/ndk/GradleWorkspace", "getNativeLibraries"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/ndk/GradleWorkspace", "getNativeLibraries"));
        }
        if (GradleWorkspace.isModelVersionIncompatible(androidProject)) {
            List<NativeLibrary> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/GradleWorkspace", "getNativeLibraries"));
            }
            return list;
        }
        AndroidArtifact mainArtifact = variant.getMainArtifact();
        Collection nativeLibraries = mainArtifact.getNativeLibraries();
        if (nativeLibraries != null) {
            Collection collection = nativeLibraries;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/GradleWorkspace", "getNativeLibraries"));
            }
            return collection;
        }
        List<NativeLibrary> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/GradleWorkspace", "getNativeLibraries"));
        }
        return list;
    }

    private static boolean isModelVersionIncompatible(@NotNull AndroidProject androidProject) {
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/ndk/GradleWorkspace", "isModelVersionIncompatible"));
        }
        return GradleWorkspace.getModelVersionIfIncompatible(androidProject) != null;
    }

    @Nullable
    private static String getModelVersionIfIncompatible(@NotNull AndroidProject androidProject) {
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/ndk/GradleWorkspace", "getModelVersionIfIncompatible"));
        }
        String modelVersion = androidProject.getModelVersion();
        if (!modelVersion.startsWith("1.0") && !modelVersion.startsWith("1.1") && androidProject.getApiVersion() >= 3) {
            return null;
        }
        return modelVersion;
    }

    @Nullable
    public OCResolveConfiguration getSelectedResolveConfiguration() {
        return null;
    }

    @NotNull
    public OCWorkspaceModificationTrackers getModificationTrackers() {
        OCWorkspaceModificationTrackers oCWorkspaceModificationTrackers = this.myTrackers;
        if (oCWorkspaceModificationTrackers == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/GradleWorkspace", "getModificationTrackers"));
        }
        return oCWorkspaceModificationTrackers;
    }

    @Nullable
    public OCLanguageKind getLanguageKind(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/android/tools/ndk/GradleWorkspace", "getLanguageKind"));
        }
        if (!OCFileTypeHelpers.isSourceFile((String)fileName)) {
            return null;
        }
        String fileExtension = FileUtilRt.getExtension((String)fileName);
        OCLanguageKind languageKind = this.myProjectFileExtensions.get(fileExtension);
        if (languageKind == null) {
            languageKind = fileExtension.equalsIgnoreCase(GRADLE_LANGUAGE_TYPE_C) ? OCLanguageKind.C : OCLanguageKind.CPP;
            LOG.warn(String.format("Unable to find language kind for files with extension '%1$s', assuming it as '%2$s'", fileExtension, languageKind));
            this.myProjectFileExtensions.put(fileExtension, languageKind);
        }
        return languageKind;
    }
}

