/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.gradle.api.ApkOutputFile;
import com.android.build.gradle.internal.model.FilterDataImpl;
import com.android.build.gradle.internal.publishing.FilterDataPersistence;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.tasks.SplitFileSupplier;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Task;

public abstract class SplitRelatedTask
extends BaseTask {
    public abstract File getApkMetadataFile();

    public abstract List<ApkOutputFile> getOutputSplitFiles();

    public abstract List<FilterData> getSplitsData();

    public List<SplitFileSupplier> getOutputFileSuppliers() {
        ImmutableList.Builder suppliers = ImmutableList.builder();
        for (final FilterData filterData : this.getSplitsData()) {
            ApkOutputFile outputFile = (ApkOutputFile)Iterables.find(this.getOutputSplitFiles(), (Predicate)new Predicate<ApkOutputFile>(){

                public boolean apply(ApkOutputFile apkOutputFile) {
                    return filterData.getIdentifier().equals(apkOutputFile.getFilter(filterData.getFilterType()));
                }
            });
            if (outputFile == null) continue;
            final File file = outputFile.getOutputFile();
            final FilterData data = filterData;
            suppliers.add((Object)new SplitFileSupplier(){

                public File get() {
                    return file;
                }

                @Override
                public Task getTask() {
                    return SplitRelatedTask.this;
                }

                @Override
                public FilterData getFilterData() {
                    return data;
                }
            });
        }
        return suppliers.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveApkMetadataFile() throws IOException {
        File metadataFile = this.getApkMetadataFile();
        if (metadataFile == null) {
            return;
        }
        OutputStreamWriter fileWriter = null;
        try {
            metadataFile.getParentFile().mkdirs();
            fileWriter = new FileWriter(metadataFile);
            FilterDataPersistence persistence = new FilterDataPersistence();
            persistence.persist(this.getOutputFileSuppliers(), fileWriter);
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
    }

    protected static void addAllFilterData(ImmutableList.Builder<FilterData> to, Collection<String> identifiers, OutputFile.FilterType filterType) {
        for (String identifier : identifiers) {
            to.add((Object)FilterDataImpl.build(filterType.toString(), identifier));
        }
    }
}

