/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.shrinker;

import com.android.build.gradle.shrinker.DependencyType;
import com.android.build.gradle.shrinker.KeepRules;
import com.android.build.gradle.shrinker.ShrinkerGraph;
import com.android.build.gradle.shrinker.ShrinkerLogger;
import com.android.build.gradle.shrinker.TypeHierarchyTraverser;
import com.android.build.gradle.shrinker.parser.AnnotationSpecification;
import com.android.build.gradle.shrinker.parser.ClassSpecification;
import com.android.build.gradle.shrinker.parser.FieldSpecification;
import com.android.build.gradle.shrinker.parser.Flags;
import com.android.build.gradle.shrinker.parser.InheritanceSpecification;
import com.android.build.gradle.shrinker.parser.Matcher;
import com.android.build.gradle.shrinker.parser.MethodSpecification;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProguardFlagsKeepRules
implements KeepRules {
    private final Flags mFlags;
    private final ShrinkerLogger mShrinkerLogger;

    public ProguardFlagsKeepRules(Flags flags, ShrinkerLogger shrinkerLogger) {
        this.mFlags = flags;
        this.mShrinkerLogger = shrinkerLogger;
    }

    @Override
    public <T> Map<T, DependencyType> getSymbolsToKeep(T klass, ShrinkerGraph<T> graph) {
        HashMap result = Maps.newHashMap();
        for (ClassSpecification spec : this.mFlags.getKeepClassSpecs()) {
            if (!this.matchesClass(klass, spec, graph)) continue;
            result.put(klass, DependencyType.REQUIRED_CLASS_STRUCTURE);
            result.put(graph.getMemberReference(graph.getClassName(klass), "<init>", "()V"), DependencyType.REQUIRED_CLASS_STRUCTURE);
            for (T member : ProguardFlagsKeepRules.findMatchingMembers(klass, spec, graph)) {
                result.put(member, DependencyType.REQUIRED_CLASS_STRUCTURE);
            }
        }
        for (ClassSpecification spec : this.mFlags.getKeepClassMembersSpecs()) {
            if (!this.matchesClass(klass, spec, graph)) continue;
            for (T member : ProguardFlagsKeepRules.findMatchingMembers(klass, spec, graph)) {
                result.put(member, DependencyType.IF_CLASS_KEPT);
                graph.addDependency(klass, member, DependencyType.CLASS_IS_KEPT);
            }
        }
        for (ClassSpecification spec : this.mFlags.getKeepClassesWithMembersSpecs()) {
            if (!this.matchesClass(klass, spec, graph)) continue;
            for (T t : ProguardFlagsKeepRules.handleKeepClassesWithMembers(spec, klass, graph)) {
                result.put(t, DependencyType.REQUIRED_CLASS_STRUCTURE);
            }
        }
        return result;
    }

    private static <T> List<T> handleKeepClassesWithMembers(ClassSpecification classSpec, T klass, ShrinkerGraph<T> graph) {
        boolean found;
        ArrayList result = Lists.newArrayList();
        for (MethodSpecification methodSpec : classSpec.getMethodSpecifications()) {
            found = false;
            for (T method : graph.getMethods(klass)) {
                if (!ProguardFlagsKeepRules.matchesMethod(method, methodSpec, graph)) continue;
                found = true;
                result.add(method);
            }
            if (found) continue;
            return Collections.emptyList();
        }
        for (FieldSpecification fieldSpec : classSpec.getFieldSpecifications()) {
            found = false;
            for (T method : graph.getMethods(klass)) {
                if (!ProguardFlagsKeepRules.matchesField(method, fieldSpec, graph)) continue;
                found = true;
                result.add(method);
            }
            if (found) continue;
            return Collections.emptyList();
        }
        result.add(klass);
        return result;
    }

    private static <T> List<T> findMatchingMembers(T klass, ClassSpecification spec, ShrinkerGraph<T> graph) {
        ArrayList result = Lists.newArrayList();
        for (T method : graph.getMethods(klass)) {
            for (MethodSpecification methodSpec : spec.getMethodSpecifications()) {
                if (!ProguardFlagsKeepRules.matchesMethod(method, methodSpec, graph)) continue;
                result.add(method);
            }
        }
        for (T field : graph.getFields(klass)) {
            for (FieldSpecification fieldSpecification : spec.getFieldSpecifications()) {
                if (!ProguardFlagsKeepRules.matchesField(field, fieldSpecification, graph)) continue;
                result.add(field);
            }
        }
        return result;
    }

    private static <T> boolean matchesField(T field, FieldSpecification spec, ShrinkerGraph<T> graph) {
        return ProguardFlagsKeepRules.matches(spec.getName(), graph.getFieldName(field)) && ProguardFlagsKeepRules.matches(spec.getModifier(), graph.getMemberModifiers(field)) && ProguardFlagsKeepRules.matches(spec.getTypeSignature(), graph.getFieldDesc(field)) && ProguardFlagsKeepRules.matchesAnnotations(field, spec.getAnnotations(), graph);
    }

    private static <T> boolean matchesMethod(T method, MethodSpecification spec, ShrinkerGraph<T> graph) {
        return ProguardFlagsKeepRules.matches(spec.getName(), graph.getMethodNameAndDesc(method)) && ProguardFlagsKeepRules.matches(spec.getModifiers(), graph.getMemberModifiers(method)) && ProguardFlagsKeepRules.matchesAnnotations(method, spec.getAnnotations(), graph);
    }

    private <T> boolean matchesClass(T klass, ClassSpecification spec, ShrinkerGraph<T> graph) {
        int classModifiers = graph.getClassModifiers(klass);
        return ProguardFlagsKeepRules.matches(spec.getName(), graph.getClassName(klass)) && ProguardFlagsKeepRules.matches(spec.getClassType(), classModifiers) && ProguardFlagsKeepRules.matches(spec.getModifier(), classModifiers) && ProguardFlagsKeepRules.matchesAnnotations(klass, spec.getAnnotation(), graph) && this.matchesInheritance(klass, spec.getInheritance(), graph);
    }

    private static <U> boolean matches(Matcher<U> matcher, U value) {
        return matcher == null || matcher.matches(value);
    }

    private static <T> boolean matchesAnnotations(T classOrMember, AnnotationSpecification annotation, ShrinkerGraph<T> graph) {
        if (annotation == null) {
            return true;
        }
        for (String annotationName : graph.getAnnotations(classOrMember)) {
            if (!annotation.getName().matches(annotationName)) continue;
            return true;
        }
        return false;
    }

    private <T> boolean matchesInheritance(T klass, InheritanceSpecification spec, ShrinkerGraph<T> graph) {
        if (spec == null) {
            return true;
        }
        FluentIterable superTypes = TypeHierarchyTraverser.superclassesAndInterfaces(graph, this.mShrinkerLogger).preOrderTraversal(klass).skip(1);
        for (Object superType : superTypes) {
            String name = graph.getClassName(superType);
            if (!spec.getNameSpec().matches(name)) continue;
            return true;
        }
        return false;
    }
}

