/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.transforms.ChangeRecords;
import com.android.build.gradle.internal.transforms.InstantRunBuildType;
import com.android.build.gradle.tasks.ColdswapArtifactsKickerTask;
import com.android.build.gradle.tasks.MarkerFile;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.gradle.api.logging.Logger;
import org.objectweb.asm.ClassWriter;

public class InstantRunSlicer
extends Transform {
    public static final String MAIN_SLICE_NAME = "main_slice";
    @VisibleForTesting
    static final String PACKAGE_FOR_GUARD_CLASSS = "com/android/tools/fd/dummy";
    public static final int NUMBER_OF_SLICES_FOR_PROJECT_CLASSES = 10;
    private final ILogger logger;
    private final VariantScope variantScope;

    public InstantRunSlicer(Logger logger, VariantScope variantScope) {
        this.logger = new LoggerWrapper(logger);
        this.variantScope = variantScope;
    }

    public String getName() {
        return "instantRunSlicer";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return EnumSet.of(QualifiedContent.Scope.PROJECT, QualifiedContent.Scope.SUB_PROJECTS);
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(TransformInvocation transformInvocation) throws IOException, TransformException, InterruptedException {
        TransformOutputProvider outputProvider = transformInvocation.getOutputProvider();
        boolean isIncremental = transformInvocation.isIncremental();
        Collection inputs = transformInvocation.getInputs();
        if (outputProvider == null) {
            this.logger.error(null, "null TransformOutputProvider for InstantRunSlicer", new Object[0]);
            return;
        }
        if (MarkerFile.Command.BLOCK == MarkerFile.readMarkerFile(ColdswapArtifactsKickerTask.ConfigAction.getMarkerFile(this.variantScope))) {
            return;
        }
        Slices slices = new Slices();
        if (isIncremental) {
            this.sliceIncrementally(inputs, outputProvider, slices);
        } else {
            this.slice(inputs, outputProvider, slices);
            this.combineAllJars(inputs, outputProvider);
        }
    }

    private void slice(Collection<TransformInput> inputs, TransformOutputProvider outputProvider, Slices slices) throws IOException, TransformException, InterruptedException {
        File dependenciesLocation = InstantRunSlicer.getDependenciesSliceOutputFolder(outputProvider, Format.DIRECTORY);
        for (TransformInput input : inputs) {
            for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
                File inputDir = directoryInput.getFile();
                FluentIterable files = Files.fileTreeTraverser().breadthFirstTraversal((Object)directoryInput.getFile());
                for (File file : files) {
                    if (file.isDirectory()) continue;
                    String packagePath = FileUtils.relativePossiblyNonExistingPath((File)file.getParentFile(), (File)inputDir);
                    if (directoryInput.getScopes().contains(QualifiedContent.Scope.PROJECT) || directoryInput.getScopes().contains(QualifiedContent.Scope.SUB_PROJECTS)) {
                        slices.addElement(packagePath, file);
                        continue;
                    }
                    File outputFile = new File(dependenciesLocation, new File(packagePath, file.getName()).getPath());
                    Files.createParentDirs((File)outputFile);
                    Files.copy((File)file, (File)outputFile);
                }
            }
        }
        slices.writeTo(outputProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void combineAllJars(Collection<TransformInput> inputs, TransformOutputProvider outputProvider) throws IOException {
        ArrayList<JarInput> jarFilesToProcess = new ArrayList<JarInput>();
        for (TransformInput input : inputs) {
            for (JarInput jarInput : input.getJarInputs()) {
                File mainSliceOutput;
                File jarFile = jarInput.getFile();
                if (jarFile.getName().equals("instant-run.jar")) {
                    mainSliceOutput = InstantRunSlicer.getMainSliceOutputFolder(outputProvider, null);
                    Files.copy((File)jarFile, (File)mainSliceOutput);
                    continue;
                }
                if (jarFile.getAbsolutePath().contains("incremental-classes")) {
                    mainSliceOutput = InstantRunSlicer.getMainSliceOutputFolder(outputProvider, "b");
                    Files.copy((File)jarFile, (File)mainSliceOutput);
                    continue;
                }
                if (!jarInput.getFile().exists()) continue;
                jarFilesToProcess.add(jarInput);
            }
        }
        if (jarFilesToProcess.isEmpty()) {
            return;
        }
        File dependenciesJar = InstantRunSlicer.getDependenciesSliceOutputFolder(outputProvider, Format.JAR);
        HashSet<String> entries = new HashSet<String>();
        Files.createParentDirs((File)dependenciesJar);
        JarOutputStream jarOutputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(dependenciesJar)));
        try {
            for (JarInput jarInput : jarFilesToProcess) {
                this.mergeJarInto(jarInput, entries, jarOutputStream);
            }
        }
        finally {
            jarOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeJarInto(JarInput jarInput, Set<String> entries, JarOutputStream dependenciesJar) throws IOException {
        JarFile jarFile = new JarFile(jarInput.getFile());
        try {
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                if (jarEntry.isDirectory()) continue;
                if (entries.contains(jarEntry.getName())) {
                    this.logger.verbose(String.format("Entry %1$s is duplicated, ignore the one from %2$s", jarEntry.getName(), jarInput.getName()), new Object[0]);
                    continue;
                }
                dependenciesJar.putNextEntry(new JarEntry(jarEntry.getName()));
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                try {
                    ByteStreams.copy((InputStream)inputStream, (OutputStream)dependenciesJar);
                }
                finally {
                    inputStream.close();
                }
                dependenciesJar.closeEntry();
                entries.add(jarEntry.getName());
            }
        }
        finally {
            jarFile.close();
        }
    }

    private void sliceIncrementally(Collection<TransformInput> inputs, TransformOutputProvider outputProvider, Slices slices) throws IOException, TransformException, InterruptedException {
        this.processChangesSinceLastRestart(inputs, outputProvider, slices);
        for (TransformInput input : inputs) {
            for (JarInput jarInput : input.getJarInputs()) {
                if (jarInput.getStatus() == Status.NOTCHANGED) continue;
                this.combineAllJars(inputs, outputProvider);
                return;
            }
        }
        this.logger.info("No jar merging necessary, all input jars unchanged", new Object[0]);
    }

    private DirectoryInput getInputFor(Collection<TransformInput> inputs, File file) {
        for (TransformInput input : inputs) {
            for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
                if (!file.getAbsolutePath().startsWith(directoryInput.getFile().getAbsolutePath())) continue;
                return directoryInput;
            }
        }
        return null;
    }

    public Collection<SecondaryFile> getSecondaryFiles() {
        return ImmutableList.of((Object)new SecondaryFile(ColdswapArtifactsKickerTask.ConfigAction.getMarkerFile(this.variantScope), true));
    }

    private void processChangesSinceLastRestart(final Collection<TransformInput> inputs, final TransformOutputProvider outputProvider, final Slices slices) throws TransformException, InterruptedException, IOException {
        File incrementalChangesFile = InstantRunBuildType.RESTART.getIncrementalChangesFile(this.variantScope);
        ChangeRecords.process(incrementalChangesFile, new ChangeRecords.RecordHandler(){

            @Override
            public void handle(String filePath, Status status) throws IOException, TransformException {
                File fileToProcess = new File(filePath);
                DirectoryInput directoryInput = InstantRunSlicer.this.getInputFor(inputs, fileToProcess);
                if (directoryInput == null) {
                    InstantRunSlicer.this.logger.info("Cannot find input directory for " + filePath, new Object[0]);
                    return;
                }
                File sliceOutputLocation = InstantRunSlicer.getOutputStreamForFile(outputProvider, directoryInput, fileToProcess, slices);
                Files.write((CharSequence)String.valueOf(InstantRunSlicer.this.variantScope.getInstantRunBuildContext().getBuildId()), (File)new File(sliceOutputLocation, "buildId.txt"), (Charset)Charsets.UTF_8);
                String relativePath = FileUtils.relativePossiblyNonExistingPath((File)fileToProcess, (File)directoryInput.getFile());
                File outputFile = new File(sliceOutputLocation, relativePath);
                switch (status) {
                    case ADDED: 
                    case CHANGED: {
                        Files.createParentDirs((File)outputFile);
                        Files.copy((File)fileToProcess, (File)outputFile);
                        break;
                    }
                    case REMOVED: {
                        if (outputFile.delete()) break;
                        throw new TransformException(String.format("Cannot delete file %1$s", outputFile.getAbsolutePath()));
                    }
                    default: {
                        throw new TransformException("Unhandled status " + status);
                    }
                }
            }
        });
    }

    private static File getOutputStreamForFile(TransformOutputProvider transformOutputProvider, DirectoryInput input, File file, Slices slices) {
        String relativePackagePath = FileUtils.relativePossiblyNonExistingPath((File)file.getParentFile(), (File)input.getFile());
        if (input.getScopes().contains(QualifiedContent.Scope.PROJECT) || input.getScopes().contains(QualifiedContent.Scope.SUB_PROJECTS)) {
            Slice slice = slices.getSliceFor(new Slice.SlicedElement(relativePackagePath, file));
            return transformOutputProvider.getContentLocation(slice.name, TransformManager.CONTENT_CLASS, (Set)Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.SUB_PROJECTS}), Format.DIRECTORY);
        }
        return InstantRunSlicer.getDependenciesSliceOutputFolder(transformOutputProvider, Format.DIRECTORY);
    }

    private static File getMainSliceOutputFolder(TransformOutputProvider outputProvider, String suffix) throws IOException {
        File outputFolder = outputProvider.getContentLocation(MAIN_SLICE_NAME + Strings.nullToEmpty((String)suffix), TransformManager.CONTENT_CLASS, (Set)Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.SUB_PROJECTS}), Format.JAR);
        Files.createParentDirs((File)outputFolder);
        return outputFolder;
    }

    private static File getDependenciesSliceOutputFolder(TransformOutputProvider outputProvider, Format format) {
        String name = format == Format.DIRECTORY ? "dep-classes" : "dependencies";
        return outputProvider.getContentLocation(name, TransformManager.CONTENT_CLASS, (Set)Sets.immutableEnumSet((Enum)QualifiedContent.Scope.EXTERNAL_LIBRARIES, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.SUB_PROJECTS_LOCAL_DEPS, QualifiedContent.Scope.PROJECT_LOCAL_DEPS}), format);
    }

    private static void createGuardClass(String name, File outputDir) throws IOException {
        ClassWriter cw = new ClassWriter(0);
        File packageDir = new File(outputDir, PACKAGE_FOR_GUARD_CLASSS);
        File outputFile = new File(packageDir, name + ".class");
        Files.createParentDirs((File)outputFile);
        String appInfoOwner = "com/android/tools/fd/dummy/" + name;
        cw.visit(50, 33, appInfoOwner, null, "java/lang/Object", null);
        cw.visitEnd();
        Files.write((byte[])cw.toByteArray(), (File)outputFile);
    }

    private static class Slice {
        private final String name;
        private final int hashBucket;
        private final List<SlicedElement> slicedElements;

        private Slice(String name, int hashBucket) {
            this.name = name;
            this.hashBucket = hashBucket;
            this.slicedElements = new ArrayList<SlicedElement>();
        }

        private void add(SlicedElement slicedElement) {
            if (this.hashBucket != slicedElement.getHashBucket()) {
                throw new RuntimeException("Wrong bucket for " + slicedElement);
            }
            this.slicedElements.add(slicedElement);
        }

        private void writeTo(TransformOutputProvider outputProvider) throws IOException {
            File sliceOutputLocation = outputProvider.getContentLocation(this.name, TransformManager.CONTENT_CLASS, (Set)Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.SUB_PROJECTS}), Format.DIRECTORY);
            InstantRunSlicer.createGuardClass(this.name, sliceOutputLocation);
            for (SlicedElement slicedElement : this.slicedElements) {
                File outputFile = new File(sliceOutputLocation, new File(slicedElement.packagePath, slicedElement.slicedFile.getName()).getPath());
                Files.createParentDirs((File)outputFile);
                Files.copy((File)slicedElement.slicedFile, (File)outputFile);
            }
        }

        private static class SlicedElement {
            private final String packagePath;
            private final File slicedFile;

            private SlicedElement(String packagePath, File slicedFile) {
                this.packagePath = packagePath;
                this.slicedFile = slicedFile;
            }

            public int getHashBucket() {
                String hashTarget = Strings.isNullOrEmpty((String)this.packagePath) ? this.slicedFile.getName() : this.packagePath;
                return Math.abs(hashTarget.hashCode() % 10);
            }

            public String toString() {
                return this.packagePath + this.slicedFile.getName();
            }
        }
    }

    private static class Slices {
        private final List<Slice> slices = new ArrayList<Slice>();

        private Slices() {
            for (int i = 0; i < 10; ++i) {
                Slice newSlice = new Slice("slice_" + i, i);
                this.slices.add(newSlice);
            }
        }

        private void addElement(String packagePath, File file) {
            Slice.SlicedElement slicedElement = new Slice.SlicedElement(packagePath, file);
            Slice slice = this.getSliceFor(slicedElement);
            slice.add(slicedElement);
        }

        private void writeTo(TransformOutputProvider outputProvider) throws IOException {
            for (Slice slice : this.slices) {
                slice.writeTo(outputProvider);
            }
        }

        private Slice getSliceFor(Slice.SlicedElement slicedElement) {
            return this.slices.get(slicedElement.getHashBucket());
        }
    }
}

