/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.SingleFileCopyTask;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;

public class FilteredJarCopyTask
extends SingleFileCopyTask {
    private List<String> excludes;

    @Input
    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = ImmutableList.copyOf(excludes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TaskAction
    public void copy() throws IOException {
        if (this.excludes.isEmpty()) {
            super.copy();
        }
        ArrayList patterns = Lists.newArrayListWithCapacity((int)this.excludes.size());
        for (String exclude : this.excludes) {
            patterns.add(Pattern.compile(exclude));
        }
        Closer closer = Closer.create();
        byte[] buffer = new byte[4096];
        try {
            ZipEntry entry;
            FileOutputStream fos = (FileOutputStream)closer.register((Closeable)new FileOutputStream(this.outputFile));
            BufferedOutputStream bos = (BufferedOutputStream)closer.register((Closeable)new BufferedOutputStream(fos));
            ZipOutputStream zos = (ZipOutputStream)closer.register((Closeable)new ZipOutputStream(bos));
            FileInputStream fis = (FileInputStream)closer.register((Closeable)new FileInputStream(this.inputFile));
            BufferedInputStream bis = (BufferedInputStream)closer.register((Closeable)new BufferedInputStream(fis));
            ZipInputStream zis = (ZipInputStream)closer.register((Closeable)new ZipInputStream(bis));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                String name = entry.getName();
                if (!FilteredJarCopyTask.checkEntry(patterns, name)) continue;
                JarEntry newEntry = entry.getMethod() == 0 ? new JarEntry(entry) : new JarEntry(name);
                zos.putNextEntry(newEntry);
                while ((count = zis.read(buffer)) != -1) {
                    zos.write(buffer, 0, count);
                }
                zos.closeEntry();
                zis.closeEntry();
            }
        }
        finally {
            closer.close();
        }
    }

    private static boolean checkEntry(List<Pattern> patterns, String name) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(name).matches()) continue;
            return false;
        }
        return true;
    }
}

