/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.process;

import com.android.build.gradle.internal.process.GradleProcessResult;
import com.android.build.gradle.internal.process.OutputHandlerFailedGradleProcessResult;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfo;
import com.android.ide.common.process.ProcessOutput;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;

public class GradleProcessExecutor
implements ProcessExecutor {
    private final Project project;

    public GradleProcessExecutor(Project project) {
        this.project = project;
    }

    public ProcessResult execute(ProcessInfo processInfo, ProcessOutputHandler processOutputHandler) {
        ProcessOutput output = processOutputHandler.createOutput();
        ExecResult result = this.project.exec((Action)new ExecAction(processInfo, output));
        try {
            processOutputHandler.handleOutput(output);
        }
        catch (ProcessException e) {
            return new OutputHandlerFailedGradleProcessResult(e);
        }
        return new GradleProcessResult(result);
    }

    private static class ExecAction
    implements Action<ExecSpec> {
        private final ProcessInfo processInfo;
        private final ProcessOutput processOutput;

        ExecAction(ProcessInfo processInfo, ProcessOutput processOutput) {
            this.processInfo = processInfo;
            this.processOutput = processOutput;
        }

        public void execute(ExecSpec execSpec) {
            execSpec.setExecutable((Object)this.processInfo.getExecutable());
            execSpec.args((Iterable)this.processInfo.getArgs());
            execSpec.environment(this.processInfo.getEnvironment());
            execSpec.setStandardOutput(this.processOutput.getStandardOutput());
            execSpec.setErrorOutput(this.processOutput.getErrorOutput());
            execSpec.setIgnoreExitValue(true);
        }
    }
}

