/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.builder.model.SourceProvider;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

class SourceProviderImpl
implements SourceProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private File manifestFile;
    private Collection<File> javaDirs;
    private Collection<File> resourcesDirs;
    private Collection<File> aidlDirs;
    private Collection<File> rsDirs;
    private Collection<File> cDirs;
    private Collection<File> cppDirs;
    private Collection<File> resDirs;
    private Collection<File> assetsDirs;
    private Collection<File> libsDirs;
    private Collection<File> shaderDirs;

    static SourceProviderImpl cloneProvider(SourceProvider sourceProvider) {
        SourceProviderImpl sourceProviderClone = new SourceProviderImpl();
        sourceProviderClone.name = sourceProvider.getName();
        sourceProviderClone.manifestFile = sourceProvider.getManifestFile();
        sourceProviderClone.javaDirs = sourceProvider.getJavaDirectories();
        sourceProviderClone.resourcesDirs = sourceProvider.getResourcesDirectories();
        sourceProviderClone.aidlDirs = sourceProvider.getAidlDirectories();
        sourceProviderClone.rsDirs = sourceProvider.getRenderscriptDirectories();
        sourceProviderClone.cDirs = sourceProvider.getCDirectories();
        sourceProviderClone.cppDirs = sourceProvider.getCDirectories();
        sourceProviderClone.resDirs = sourceProvider.getResDirectories();
        sourceProviderClone.assetsDirs = sourceProvider.getAssetsDirectories();
        sourceProviderClone.libsDirs = sourceProvider.getJniLibsDirectories();
        sourceProviderClone.shaderDirs = sourceProvider.getShadersDirectories();
        return sourceProviderClone;
    }

    static Collection<SourceProvider> cloneCollection(Collection<SourceProvider> sourceProviders) {
        ArrayList results = Lists.newArrayListWithCapacity((int)sourceProviders.size());
        for (SourceProvider sourceProvider : sourceProviders) {
            results.add(SourceProviderImpl.cloneProvider(sourceProvider));
        }
        return results;
    }

    private SourceProviderImpl() {
    }

    public String getName() {
        return this.name;
    }

    public File getManifestFile() {
        return this.manifestFile;
    }

    public Collection<File> getJavaDirectories() {
        return this.javaDirs;
    }

    public Collection<File> getResourcesDirectories() {
        return this.resourcesDirs;
    }

    public Collection<File> getAidlDirectories() {
        return this.aidlDirs;
    }

    public Collection<File> getRenderscriptDirectories() {
        return this.rsDirs;
    }

    public Collection<File> getCDirectories() {
        return this.cDirs;
    }

    public Collection<File> getCppDirectories() {
        return this.cppDirs;
    }

    public Collection<File> getResDirectories() {
        return this.resDirs;
    }

    public Collection<File> getAssetsDirectories() {
        return this.assetsDirs;
    }

    public Collection<File> getJniLibsDirectories() {
        return this.libsDirs;
    }

    public Collection<File> getShadersDirectories() {
        return this.shaderDirs;
    }

    public String toString() {
        return "SourceProviderImpl{manifestFile=" + this.manifestFile + ", javaDirs=" + this.javaDirs + ", resourcesDirs=" + this.resourcesDirs + ", aidlDirs=" + this.aidlDirs + ", rsDirs=" + this.rsDirs + ", cDirs=" + this.cDirs + ", cppDirs=" + this.cppDirs + ", resDirs=" + this.resDirs + ", assetsDirs=" + this.assetsDirs + ", libsDirs=" + this.libsDirs + ", shadersDirs=" + this.shaderDirs + '}';
    }
}

