/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.google.common.collect.Sets;
import java.util.Set;
import org.gradle.api.tasks.Input;

public class PackagingOptions
implements com.android.builder.model.PackagingOptions {
    private Set<String> excludes = Sets.newHashSet((Object[])new String[]{"META-INF/LICENSE", "META-INF/LICENSE.txt", "META-INF/NOTICE", "META-INF/NOTICE.txt", "NOTICE", "NOTICE.txt", "LICENSE.txt", "LICENSE"});
    private Set<String> pickFirsts = Sets.newHashSet();
    private Set<String> merges = Sets.newHashSet();

    @Input
    public Set<String> getExcludes() {
        return Sets.newHashSet(this.excludes);
    }

    public void setExcludes(Set<String> excludes) {
        this.excludes = Sets.newHashSet(excludes);
        this.pickFirsts.removeAll(excludes);
        this.merges.removeAll(excludes);
    }

    public void exclude(String path) {
        this.excludes.add(path);
        this.merges.remove(path);
        this.pickFirsts.remove(path);
    }

    @Input
    public Set<String> getPickFirsts() {
        return Sets.newHashSet(this.pickFirsts);
    }

    public void pickFirst(String path) {
        this.pickFirsts.add(path);
        this.merges.remove(path);
        this.excludes.remove(path);
    }

    public void setPickFirsts(Set<String> pickFirsts) {
        this.pickFirsts = Sets.newHashSet(pickFirsts);
        this.excludes.removeAll(pickFirsts);
        this.merges.removeAll(pickFirsts);
    }

    @Input
    public Set<String> getMerges() {
        return Sets.newHashSet(this.merges);
    }

    public void setMerges(Set<String> merges) {
        this.merges = Sets.newHashSet(merges);
        this.excludes.removeAll(merges);
        this.pickFirsts.removeAll(merges);
    }

    public void merge(String path) {
        this.merges.add(path);
        this.excludes.remove(path);
        this.pickFirsts.remove(path);
    }

    public Action getAction(String archivePath) {
        if (this.pickFirsts.contains(archivePath)) {
            return Action.PICK_FIRST;
        }
        if (this.merges.contains(archivePath)) {
            return Action.MERGE;
        }
        if (this.excludes.contains(archivePath)) {
            return Action.EXCLUDE;
        }
        return Action.NONE;
    }

    public static enum Action {
        NONE,
        MERGE,
        PICK_FIRST,
        EXCLUDE;

    }
}

