/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.builder.dependency.LibraryBundle;
import com.android.builder.dependency.LibraryDependency;
import com.android.builder.dependency.ManifestDependency;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.MavenCoordinates;
import com.google.common.base.Objects;
import java.io.File;
import java.util.Collections;
import java.util.List;

public class LibraryDependencyImpl
extends LibraryBundle {
    private final List<LibraryDependency> dependencies;
    private final String variantName;
    private final MavenCoordinates requestedCoordinates;
    private final MavenCoordinates resolvedCoordinates;
    private final boolean isOptional;

    public LibraryDependencyImpl(File bundle, File explodedBundle, List<LibraryDependency> dependencies, String name, String variantName, String projectPath, MavenCoordinates requestedCoordinates, MavenCoordinates resolvedCoordinates, boolean isOptional) {
        super(bundle, explodedBundle, name, projectPath);
        this.dependencies = dependencies;
        this.variantName = variantName;
        this.requestedCoordinates = requestedCoordinates;
        this.resolvedCoordinates = resolvedCoordinates;
        this.isOptional = isOptional;
    }

    public List<? extends AndroidLibrary> getLibraryDependencies() {
        return this.dependencies;
    }

    public List<LibraryDependency> getDependencies() {
        return this.dependencies;
    }

    public List<? extends ManifestDependency> getManifestDependencies() {
        return this.dependencies;
    }

    public String getProjectVariant() {
        return this.variantName;
    }

    public MavenCoordinates getRequestedCoordinates() {
        return this.requestedCoordinates;
    }

    public MavenCoordinates getResolvedCoordinates() {
        return this.resolvedCoordinates;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public LibraryDependencyImpl getNonTransitiveRepresentation() {
        return new LibraryDependencyImpl(this.getBundle(), this.getBundleFolder(), Collections.<LibraryDependency>emptyList(), this.getName(), this.variantName, this.getProject(), this.requestedCoordinates, this.resolvedCoordinates, this.isOptional);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LibraryDependencyImpl that = (LibraryDependencyImpl)((Object)o);
        return Objects.equal(this.dependencies, that.dependencies) && Objects.equal((Object)this.variantName, (Object)that.variantName) && Objects.equal((Object)this.resolvedCoordinates, (Object)that.resolvedCoordinates) && Objects.equal((Object)this.isOptional, (Object)that.isOptional());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.dependencies, this.variantName, this.resolvedCoordinates, this.isOptional});
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("dependencies", this.dependencies).add("variantName", (Object)this.variantName).add("requestedCoordinates", (Object)this.requestedCoordinates).add("resolvedCoordinates", (Object)this.resolvedCoordinates).add("isOptional", this.isOptional).add("super", (Object)super.toString()).toString();
    }
}

