/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.JarInfo;
import com.android.build.gradle.internal.dependency.LibraryDependencyImpl;
import com.android.builder.dependency.LibraryDependency;
import com.android.builder.model.MavenCoordinates;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;

public class LibInfo
extends LibraryDependencyImpl {
    private final Collection<JarInfo> jarDependencies;
    private boolean mutableIsOptional = false;

    public LibInfo(File bundle, File explodedBundle, List<LibraryDependency> dependencies, Collection<JarInfo> jarDependencies, String name, String variantName, String projectPath, MavenCoordinates requestedCoordinates, MavenCoordinates resolvedCoordinates) {
        super(bundle, explodedBundle, dependencies, name, variantName, projectPath, requestedCoordinates, resolvedCoordinates, false);
        this.jarDependencies = jarDependencies;
    }

    public void setIsOptional(boolean isOptional) {
        this.mutableIsOptional = isOptional;
        for (LibInfo libInfo : this.getLibInfoDependencies()) {
            libInfo.setIsOptional(isOptional);
        }
    }

    @Override
    public boolean isOptional() {
        return this.mutableIsOptional;
    }

    public List<LibInfo> getLibInfoDependencies() {
        ImmutableList.Builder libInfoBuilder = ImmutableList.builder();
        for (LibraryDependency libraryDependency : this.getDependencies()) {
            if (libraryDependency instanceof LibInfo) {
                libInfoBuilder.add((Object)((LibInfo)libraryDependency));
                continue;
            }
            throw new RuntimeException("Mixed LibInfo and LibraryDependencies instances !");
        }
        return libInfoBuilder.build();
    }

    public Collection<JarInfo> getJarDependencies() {
        return this.jarDependencies;
    }
}

