/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal.slf4j;

import org.gradle.api.logging.LogLevel;
import org.gradle.logging.internal.LoggingConfigurer;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.logging.internal.slf4j.OutputEventListenerBackedLoggerContext;
import org.slf4j.LoggerFactory;

public class Slf4jLoggingConfigurer
implements LoggingConfigurer {
    private final OutputEventListener outputEventListener;
    private LogLevel currentLevel;

    public Slf4jLoggingConfigurer(OutputEventListener outputListener) {
        this.outputEventListener = outputListener;
    }

    public void configure(LogLevel logLevel) {
        if (logLevel == this.currentLevel) {
            return;
        }
        OutputEventListenerBackedLoggerContext context = (OutputEventListenerBackedLoggerContext)LoggerFactory.getILoggerFactory();
        if (this.currentLevel == null) {
            context.setOutputEventListener(this.outputEventListener);
        }
        this.currentLevel = logLevel;
        context.setLevel(logLevel);
    }
}

