/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.progress;

import java.util.LinkedList;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.TimeProvider;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.progress.BuildOperationExecutor;
import org.gradle.internal.progress.BuildOperationInternal;
import org.gradle.internal.progress.BuildOperationType;
import org.gradle.internal.progress.InternalBuildListener;
import org.gradle.internal.progress.OperationResult;
import org.gradle.internal.progress.OperationStartEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBuildOperationExecutor
implements BuildOperationExecutor {
    private final InternalBuildListener listener;
    private final TimeProvider timeProvider;
    private LinkedList<Object> operationStack = new LinkedList();

    public DefaultBuildOperationExecutor(InternalBuildListener listener, TimeProvider timeProvider) {
        this.listener = listener;
        this.timeProvider = timeProvider;
    }

    @Override
    public Object getCurrentOperationId() {
        if (this.operationStack.isEmpty()) {
            throw new IllegalStateException("No operation is currently running.");
        }
        return this.operationStack.getFirst();
    }

    @Override
    public void run(Object id, BuildOperationType operationType, Runnable action) {
        this.run(id, operationType, Factories.toFactory((Runnable)action));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run(Object id, BuildOperationType operationType, Factory<T> factory) {
        Object parentId = this.operationStack.isEmpty() ? null : this.operationStack.getFirst();
        this.operationStack.addFirst(id);
        try {
            long startTime = this.timeProvider.getCurrentTime();
            BuildOperationInternal operation = new BuildOperationInternal(id, parentId, operationType);
            this.listener.started(operation, new OperationStartEvent(startTime));
            Object result = null;
            Throwable failure = null;
            try {
                result = factory.create();
            }
            catch (Throwable t) {
                failure = t;
            }
            long endTime = this.timeProvider.getCurrentTime();
            this.listener.finished(operation, new OperationResult(startTime, endTime, failure));
            if (failure != null) {
                throw UncheckedException.throwAsUncheckedException((Throwable)failure);
            }
            Object object = result;
            return (T)object;
        }
        finally {
            this.operationStack.removeFirst();
        }
    }
}

