/*
 * Decompiled with CFR 0.152.
 */
package org.java.ayatana;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.java.ayatana.AyatanaDesktop;

public final class AyatanaLibrary {
    public static final String LIB_VERSION = "1.2.4";
    public static final String JNI_VERSION = "1.2.0";
    private static boolean loaded = false;
    private static boolean successful = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUbuntuVersion() throws IOException {
        Properties prop = new Properties();
        File frel = new File("/etc/lsb-release");
        if (frel.exists()) {
            FileInputStream fis = new FileInputStream(frel);
            try {
                prop.load(fis);
            }
            finally {
                fis.close();
            }
        }
        return prop.getProperty("DISTRIB_RELEASE", "UNKNOW");
    }

    public static boolean load() {
        if (!loaded) {
            try {
                File targetLibrary;
                block18: {
                    block17: {
                        targetLibrary = new File("/usr/lib/jayatana/libjayatana.so.1.2.0");
                        if (!targetLibrary.exists()) {
                            File targetDirectory = new File(System.getProperty("user.home"), ".java/jayatana/1.2.0/" + System.getProperty("os.arch"));
                            targetLibrary = new File(targetDirectory, "libjayatana.so");
                            String sourceLibrary = "/native/" + AyatanaLibrary.getUbuntuVersion() + "/" + System.getProperty("os.arch") + "/libjayatana.so";
                            if (AyatanaLibrary.class.getResource(sourceLibrary) == null) {
                                sourceLibrary = "/native/UNKNOW/" + System.getProperty("os.arch") + "/libjayatana.so";
                            }
                            if (targetLibrary.exists()) {
                                FileInputStream fis = new FileInputStream(targetLibrary);
                                String chksum = AyatanaDesktop.getMD5Checksum(fis);
                                fis.close();
                                InputStream input = AyatanaLibrary.class.getResourceAsStream(sourceLibrary);
                                if (input == null) {
                                    throw new Exception("not library exists");
                                }
                                String chksumint = AyatanaDesktop.getMD5Checksum(input);
                                input.close();
                                if (!chksumint.equals(chksum)) {
                                    int read;
                                    targetLibrary.delete();
                                    input = AyatanaLibrary.class.getResourceAsStream(sourceLibrary);
                                    if (input == null) {
                                        throw new Exception("not library exists");
                                    }
                                    FileOutputStream fos = new FileOutputStream(targetLibrary);
                                    byte[] buff = new byte[1024];
                                    while ((read = input.read(buff)) > 0) {
                                        fos.write(buff, 0, read);
                                    }
                                    fos.flush();
                                    fos.close();
                                    input.close();
                                }
                            } else {
                                int read;
                                targetDirectory.mkdirs();
                                InputStream input = AyatanaLibrary.class.getResourceAsStream(sourceLibrary);
                                if (input == null) {
                                    throw new Exception("not library exists");
                                }
                                FileOutputStream fos = new FileOutputStream(targetLibrary);
                                byte[] buff = new byte[1024];
                                while ((read = input.read(buff)) > 0) {
                                    fos.write(buff, 0, read);
                                }
                                fos.flush();
                                fos.close();
                                input.close();
                            }
                        }
                        try {
                            System.loadLibrary("awt");
                        }
                        catch (UnsatisfiedLinkError e) {
                            if (e.getMessage().contains("loaded in another classloader")) break block17;
                            throw e;
                        }
                    }
                    try {
                        System.loadLibrary("jawt");
                    }
                    catch (UnsatisfiedLinkError e) {
                        if (e.getMessage().contains("loaded in another classloader")) break block18;
                        throw e;
                    }
                }
                System.load(targetLibrary.getCanonicalPath());
                successful = true;
            }
            catch (Exception e) {
                successful = false;
            }
            loaded = true;
        }
        return successful;
    }
}

