/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.DependencyManager;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dependency.ManifestDependencyImpl;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.ParallelizableTask;

@ParallelizableTask
public class ProcessTestManifest
extends ManifestProcessorTask {
    private File testManifestFile;
    private File tmpDir;
    private String testApplicationId;
    private String minSdkVersion;
    private String targetSdkVersion;
    private String testedApplicationId;
    private String instrumentationRunner;
    private Boolean handleProfiling;
    private Boolean functionalTest;
    private Map<String, Object> placeholdersValues;
    private List<ManifestDependencyImpl> libraries;

    @Override
    protected void doFullTaskAction() throws IOException {
        this.getBuilder().processTestManifest(this.getTestApplicationId(), this.getMinSdkVersion(), this.getTargetSdkVersion(), this.getTestedApplicationId(), this.getInstrumentationRunner(), this.getHandleProfiling(), this.getFunctionalTest(), this.getTestManifestFile(), this.getLibraries(), this.getPlaceholdersValues(), this.getManifestOutputFile(), this.getTmpDir());
    }

    @InputFile
    @Optional
    public File getTestManifestFile() {
        return this.testManifestFile;
    }

    public void setTestManifestFile(File testManifestFile) {
        this.testManifestFile = testManifestFile;
    }

    public File getTmpDir() {
        return this.tmpDir;
    }

    public void setTmpDir(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    @Input
    public String getTestApplicationId() {
        return this.testApplicationId;
    }

    public void setTestApplicationId(String testApplicationId) {
        this.testApplicationId = testApplicationId;
    }

    @Input
    public String getMinSdkVersion() {
        return this.minSdkVersion;
    }

    public void setMinSdkVersion(String minSdkVersion) {
        this.minSdkVersion = minSdkVersion;
    }

    @Input
    public String getTargetSdkVersion() {
        return this.targetSdkVersion;
    }

    public void setTargetSdkVersion(String targetSdkVersion) {
        this.targetSdkVersion = targetSdkVersion;
    }

    @Input
    public String getTestedApplicationId() {
        return this.testedApplicationId;
    }

    public void setTestedApplicationId(String testedApplicationId) {
        this.testedApplicationId = testedApplicationId;
    }

    @Input
    public String getInstrumentationRunner() {
        return this.instrumentationRunner;
    }

    public void setInstrumentationRunner(String instrumentationRunner) {
        this.instrumentationRunner = instrumentationRunner;
    }

    @Input
    public Boolean getHandleProfiling() {
        return this.handleProfiling;
    }

    public void setHandleProfiling(Boolean handleProfiling) {
        this.handleProfiling = handleProfiling;
    }

    @Input
    public Boolean getFunctionalTest() {
        return this.functionalTest;
    }

    public void setFunctionalTest(Boolean functionalTest) {
        this.functionalTest = functionalTest;
    }

    @Input
    public Map<String, Object> getPlaceholdersValues() {
        return this.placeholdersValues;
    }

    public void setPlaceholdersValues(Map<String, Object> placeholdersValues) {
        this.placeholdersValues = placeholdersValues;
    }

    public List<ManifestDependencyImpl> getLibraries() {
        return this.libraries;
    }

    public void setLibraries(List<ManifestDependencyImpl> libraries) {
        this.libraries = libraries;
    }

    @InputFiles
    public List<File> getLibraryManifests() {
        List<ManifestDependencyImpl> libs = this.getLibraries();
        if (libs == null || libs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList files = Lists.newArrayListWithCapacity((int)(libs.size() * 2));
        for (ManifestDependencyImpl mdi : libs) {
            files.addAll(mdi.getAllManifests());
        }
        return files;
    }

    public static class ConfigAction
    implements TaskConfigAction<ProcessTestManifest> {
        private VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("process", "Manifest");
        }

        @Override
        public Class<ProcessTestManifest> getType() {
            return ProcessTestManifest.class;
        }

        @Override
        public void execute(ProcessTestManifest processTestManifestTask) {
            final GradleVariantConfiguration config = this.scope.getVariantConfiguration();
            processTestManifestTask.setTestManifestFile(config.getMainManifest());
            processTestManifestTask.setTmpDir(new File(this.scope.getGlobalScope().getIntermediatesDir(), "manifest/tmp"));
            BaseVariantOutputData variantOutputData = this.scope.getVariantData().getOutputs().get(0);
            variantOutputData.manifestProcessorTask = processTestManifestTask;
            processTestManifestTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            processTestManifestTask.setVariantName(config.getFullName());
            processTestManifestTask.setTestApplicationId(config.getApplicationId());
            ConventionMappingHelper.map((Task)processTestManifestTask, "minSdkVersion", new Callable<String>(){

                @Override
                public String call() throws Exception {
                    if (ConfigAction.this.scope.getGlobalScope().getAndroidBuilder().isPreviewTarget()) {
                        return ConfigAction.this.scope.getGlobalScope().getAndroidBuilder().getTargetCodename();
                    }
                    return config.getMinSdkVersion().getApiString();
                }
            });
            ConventionMappingHelper.map((Task)processTestManifestTask, "targetSdkVersion", new Callable<String>(){

                @Override
                public String call() throws Exception {
                    if (ConfigAction.this.scope.getGlobalScope().getAndroidBuilder().isPreviewTarget()) {
                        return ConfigAction.this.scope.getGlobalScope().getAndroidBuilder().getTargetCodename();
                    }
                    return config.getTargetSdkVersion().getApiString();
                }
            });
            ConventionMappingHelper.map((Task)processTestManifestTask, "testedApplicationId", new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return config.getTestedApplicationId();
                }
            });
            ConventionMappingHelper.map((Task)processTestManifestTask, "instrumentationRunner", new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return config.getInstrumentationRunner();
                }
            });
            ConventionMappingHelper.map((Task)processTestManifestTask, "handleProfiling", new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return config.getHandleProfiling();
                }
            });
            ConventionMappingHelper.map((Task)processTestManifestTask, "functionalTest", new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return config.getFunctionalTest();
                }
            });
            ConventionMappingHelper.map((Task)processTestManifestTask, "libraries", new Callable<List<ManifestDependencyImpl>>(){

                @Override
                public List<ManifestDependencyImpl> call() throws Exception {
                    return DependencyManager.getManifestDependencies(config.getDirectLibraries());
                }
            });
            processTestManifestTask.setManifestOutputFile(variantOutputData.getScope().getManifestOutputFile());
            ConventionMappingHelper.map((Task)processTestManifestTask, "placeholdersValues", new Callable<Map<String, Object>>(){

                @Override
                public Map<String, Object> call() throws Exception {
                    return config.getManifestPlaceholders();
                }
            });
        }
    }
}

