/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.transform.Context;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.transforms.JarMerger;
import com.android.builder.signing.SignedJarBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class LibraryJarTransform
extends Transform {
    private final File mainClassLocation;
    private final File localJarsLocation;
    private final String packagePath;
    private final boolean packageBuildConfig;
    private List<ExcludeListProvider> excludeListProviders;

    public LibraryJarTransform(File mainClassLocation, File localJarsLocation, String packageName, boolean packageBuildConfig) {
        this.mainClassLocation = mainClassLocation;
        this.localJarsLocation = localJarsLocation;
        this.packagePath = packageName.replace(".", "/");
        this.packageBuildConfig = packageBuildConfig;
    }

    public void addExcludeListProvider(ExcludeListProvider provider) {
        if (this.excludeListProviders == null) {
            this.excludeListProviders = Lists.newArrayList();
        }
        this.excludeListProviders.add(provider);
    }

    public String getName() {
        return "syncLibJars";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_JARS;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return TransformManager.EMPTY_SCOPES;
    }

    public Set<QualifiedContent.Scope> getReferencedScopes() {
        return TransformManager.SCOPE_FULL_LIBRARY;
    }

    public boolean isIncremental() {
        return false;
    }

    public Collection<File> getSecondaryFileOutputs() {
        return ImmutableList.of((Object)this.mainClassLocation);
    }

    public Collection<File> getSecondaryDirectoryOutputs() {
        return ImmutableList.of((Object)this.localJarsLocation);
    }

    public void transform(Context context, Collection<TransformInput> unusedInputs, Collection<TransformInput> referencedInputs, TransformOutputProvider unusedOutputProvider, boolean isIncremental) throws IOException, TransformException, InterruptedException {
        ArrayList excludes = Lists.newArrayListWithExpectedSize((int)5);
        excludes.add(this.packagePath + "/R.class");
        excludes.add(this.packagePath + "/R\\$(.*).class");
        excludes.add(this.packagePath + "/Manifest.class");
        excludes.add(this.packagePath + "/Manifest\\$(.*).class");
        if (!this.packageBuildConfig) {
            excludes.add(this.packagePath + "/BuildConfig.class");
        }
        if (this.excludeListProviders != null) {
            for (ExcludeListProvider provider : this.excludeListProviders) {
                List<String> list = provider.getExcludeList();
                if (list == null) continue;
                excludes.addAll(list);
            }
        }
        ArrayList patterns = Lists.newArrayListWithCapacity((int)excludes.size());
        for (String exclude : excludes) {
            patterns.add(Pattern.compile(exclude));
        }
        ArrayList mainScope = Lists.newArrayList();
        ArrayList locaJlJarScope = Lists.newArrayList();
        for (TransformInput input : referencedInputs) {
            for (QualifiedContent qualifiedContent : Iterables.concat((Iterable)input.getJarInputs(), (Iterable)input.getDirectoryInputs())) {
                if (qualifiedContent.getScopes().contains(QualifiedContent.Scope.PROJECT)) {
                    mainScope.add(qualifiedContent);
                    continue;
                }
                locaJlJarScope.add(qualifiedContent);
            }
        }
        if (mainScope.isEmpty()) {
            throw new RuntimeException("Empty Main scope for " + this.getName());
        }
        if (mainScope.size() == 1) {
            QualifiedContent content = (QualifiedContent)mainScope.get(0);
            if (content instanceof JarInput) {
                LibraryJarTransform.copyJarWithContentFilter(content.getFile(), this.mainClassLocation, patterns);
            } else {
                this.jarFolderToRootLocation(content.getFile(), patterns);
            }
        } else {
            this.mergeToRootLocation(mainScope, patterns);
        }
        this.processLocalJars(locaJlJarScope);
    }

    private void mergeToRootLocation(List<QualifiedContent> qualifiedContentList, final List<Pattern> excludes) throws IOException {
        JarMerger jarMerger = new JarMerger(this.mainClassLocation);
        jarMerger.setFilter(new SignedJarBuilder.IZipEntryFilter(){

            public boolean checkEntry(String archivePath) throws SignedJarBuilder.IZipEntryFilter.ZipAbortException {
                return LibraryJarTransform.checkEntry(excludes, archivePath);
            }
        });
        for (QualifiedContent content : qualifiedContentList) {
            System.out.println(content);
            if (content instanceof JarInput) {
                jarMerger.addJar(content.getFile());
                continue;
            }
            jarMerger.addFolder(content.getFile());
        }
        jarMerger.close();
    }

    private void processLocalJars(List<QualifiedContent> qualifiedContentList) throws IOException {
        SignedJarBuilder.IZipEntryFilter classOnlyFilter = new SignedJarBuilder.IZipEntryFilter(){

            public boolean checkEntry(String archivePath) throws SignedJarBuilder.IZipEntryFilter.ZipAbortException {
                return archivePath.endsWith(".class");
            }
        };
        Iterator<QualifiedContent> iterator = qualifiedContentList.iterator();
        while (iterator.hasNext()) {
            QualifiedContent content = iterator.next();
            if (!(content instanceof JarInput)) continue;
            LibraryJarTransform.copyJarWithContentFilter(content.getFile(), new File(this.localJarsLocation, content.getFile().getName()), classOnlyFilter);
            iterator.remove();
        }
        if (!qualifiedContentList.isEmpty()) {
            JarMerger jarMerger = new JarMerger(new File(this.localJarsLocation, "otherclasses.jar"));
            jarMerger.setFilter(classOnlyFilter);
            for (QualifiedContent content : qualifiedContentList) {
                jarMerger.addFolder(content.getFile());
            }
            jarMerger.close();
        }
    }

    private void jarFolderToRootLocation(File file, final List<Pattern> excludes) throws IOException {
        JarMerger jarMerger = new JarMerger(this.mainClassLocation);
        jarMerger.setFilter(new SignedJarBuilder.IZipEntryFilter(){

            public boolean checkEntry(String archivePath) throws SignedJarBuilder.IZipEntryFilter.ZipAbortException {
                return LibraryJarTransform.checkEntry(excludes, archivePath);
            }
        });
        jarMerger.addFolder(file);
        jarMerger.close();
    }

    public static void copyJarWithContentFilter(File from, File to, final List<Pattern> excludes) throws IOException {
        LibraryJarTransform.copyJarWithContentFilter(from, to, new SignedJarBuilder.IZipEntryFilter(){

            public boolean checkEntry(String archivePath) throws SignedJarBuilder.IZipEntryFilter.ZipAbortException {
                return LibraryJarTransform.checkEntry(excludes, archivePath);
            }
        });
    }

    public static void copyJarWithContentFilter(File from, File to, SignedJarBuilder.IZipEntryFilter filter) throws IOException {
        Closer closer = Closer.create();
        byte[] buffer = new byte[4096];
        try {
            ZipEntry entry;
            FileOutputStream fos = (FileOutputStream)closer.register((Closeable)new FileOutputStream(to));
            BufferedOutputStream bos = (BufferedOutputStream)closer.register((Closeable)new BufferedOutputStream(fos));
            ZipOutputStream zos = (ZipOutputStream)closer.register((Closeable)new ZipOutputStream(bos));
            FileInputStream fis = (FileInputStream)closer.register((Closeable)new FileInputStream(from));
            BufferedInputStream bis = (BufferedInputStream)closer.register((Closeable)new BufferedInputStream(fis));
            ZipInputStream zis = (ZipInputStream)closer.register((Closeable)new ZipInputStream(bis));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                String name = entry.getName();
                if (filter != null && !filter.checkEntry(name)) continue;
                JarEntry newEntry = entry.getMethod() == 0 ? new JarEntry(entry) : new JarEntry(name);
                zos.putNextEntry(newEntry);
                while ((count = zis.read(buffer)) != -1) {
                    zos.write(buffer, 0, count);
                }
                zos.closeEntry();
                zis.closeEntry();
            }
        }
        catch (SignedJarBuilder.IZipEntryFilter.ZipAbortException e) {
            throw new IOException(e);
        }
        finally {
            closer.close();
        }
    }

    private static boolean checkEntry(List<Pattern> patterns, String name) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(name).matches()) continue;
            return false;
        }
        return true;
    }

    public static interface ExcludeListProvider {
        public List<String> getExcludeList();
    }
}

