/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.gradle.internal.pipeline.ImmutableJarInput;
import com.android.build.gradle.internal.pipeline.ImmutableTransformInput;
import com.android.build.gradle.internal.pipeline.MutableDirectoryInput;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

abstract class IncrementalTransformInput {
    private final Map<File, QualifiedContent> jarInputs = Maps.newHashMap();
    private final List<MutableDirectoryInput> folderInputs = Lists.newArrayList();
    private final List<JarInput> convertedJarInputs = Lists.newArrayList();

    protected IncrementalTransformInput() {
    }

    boolean checkForJar(File file, Status status) {
        if (this.jarInputs.containsKey(file)) {
            QualifiedContent jarContent = this.jarInputs.get(file);
            this.addImmutableJar(new ImmutableJarInput(jarContent, status));
            this.jarInputs.remove(file);
            return true;
        }
        return false;
    }

    boolean checkForFolder(File file, List<String> fileSegments, Status status) {
        for (MutableDirectoryInput folderInput : this.folderInputs) {
            if (!folderInput.processForChangedFile(file, fileSegments, status)) continue;
            return true;
        }
        return false;
    }

    boolean checkRemovedFolderFile(File file, List<String> fileSegments) {
        for (MutableDirectoryInput folderInput : this.folderInputs) {
            if (!folderInput.processForChangedFile(file, fileSegments, Status.REMOVED)) continue;
            return true;
        }
        return this.checkRemovedFolder(file, fileSegments);
    }

    abstract boolean checkRemovedJarFile(File var1, List<String> var2);

    protected abstract boolean checkRemovedFolder(File var1, List<String> var2);

    void addJarInput(QualifiedContent jarInput) {
        this.jarInputs.put(jarInput.getFile(), jarInput);
    }

    protected void addImmutableJar(ImmutableJarInput jarInput) {
        this.convertedJarInputs.add(jarInput);
    }

    void addFolderInput(MutableDirectoryInput folderInput) {
        this.folderInputs.add(folderInput);
    }

    ImmutableTransformInput asImmutable() {
        ArrayList immutableJarInputs = Lists.newArrayListWithCapacity((int)(this.jarInputs.size() + this.convertedJarInputs.size()));
        immutableJarInputs.addAll(this.convertedJarInputs);
        for (QualifiedContent jarContent : this.jarInputs.values()) {
            immutableJarInputs.add(new ImmutableJarInput(jarContent, Status.NOTCHANGED));
        }
        ArrayList immutableDirectoryInputs = Lists.newArrayListWithCapacity((int)this.folderInputs.size());
        for (MutableDirectoryInput folderInput : this.folderInputs) {
            immutableDirectoryInputs.add(folderInput.asImmutable());
        }
        return new ImmutableTransformInput(immutableJarInputs, immutableDirectoryInputs, null);
    }
}

