/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.build.gradle.internal.CompileOptions;
import com.android.build.gradle.internal.model.DefaultJavaCompileOptions;
import com.android.build.gradle.internal.model.VariantImpl;
import com.android.builder.model.AaptOptions;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ArtifactMetaData;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.JavaCompileOptions;
import com.android.builder.model.LintOptions;
import com.android.builder.model.NativeToolchain;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.SyncIssue;
import com.android.builder.model.Variant;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;

class DefaultAndroidProject
implements AndroidProject,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String modelVersion;
    private final String name;
    private final String compileTarget;
    private final Collection<String> bootClasspath;
    private final Collection<File> frameworkSource;
    private final Collection<SigningConfig> signingConfigs;
    private final AaptOptions aaptOptions;
    private final Collection<ArtifactMetaData> extraArtifacts;
    private final Collection<String> unresolvedDependencies;
    private final Collection<SyncIssue> syncIssues;
    private final JavaCompileOptions javaCompileOptions;
    private final LintOptions lintOptions;
    private final File buildFolder;
    private final String resourcePrefix;
    private final Collection<NativeToolchain> nativeToolchains;
    private final boolean isLibrary;
    private final int apiVersion;
    private final Collection<BuildTypeContainer> buildTypes = Lists.newArrayList();
    private final Collection<ProductFlavorContainer> productFlavors = Lists.newArrayList();
    private final Collection<Variant> variants = Lists.newArrayList();
    private ProductFlavorContainer defaultConfig;
    private final Collection<String> flavorDimensions;

    DefaultAndroidProject(String modelVersion, String name, Collection<String> flavorDimensions, String compileTarget, Collection<String> bootClasspath, Collection<File> frameworkSource, Collection<SigningConfig> signingConfigs, AaptOptions aaptOptions, Collection<ArtifactMetaData> extraArtifacts, Collection<String> unresolvedDependencies, Collection<SyncIssue> syncIssues, CompileOptions compileOptions, LintOptions lintOptions, File buildFolder, String resourcePrefix, Collection<NativeToolchain> nativeToolchains, boolean isLibrary, int apiVersion) {
        this.modelVersion = modelVersion;
        this.name = name;
        this.flavorDimensions = flavorDimensions;
        this.compileTarget = compileTarget;
        this.bootClasspath = bootClasspath;
        this.frameworkSource = frameworkSource;
        this.signingConfigs = signingConfigs;
        this.aaptOptions = aaptOptions;
        this.extraArtifacts = extraArtifacts;
        this.unresolvedDependencies = unresolvedDependencies;
        this.syncIssues = syncIssues;
        this.javaCompileOptions = new DefaultJavaCompileOptions(compileOptions);
        this.lintOptions = lintOptions;
        this.buildFolder = buildFolder;
        this.resourcePrefix = resourcePrefix;
        this.isLibrary = isLibrary;
        this.apiVersion = apiVersion;
        this.nativeToolchains = nativeToolchains;
    }

    DefaultAndroidProject setDefaultConfig(ProductFlavorContainer defaultConfigContainer) {
        this.defaultConfig = defaultConfigContainer;
        return this;
    }

    DefaultAndroidProject addBuildType(BuildTypeContainer buildTypeContainer) {
        this.buildTypes.add(buildTypeContainer);
        return this;
    }

    DefaultAndroidProject addProductFlavors(ProductFlavorContainer productFlavorContainer) {
        this.productFlavors.add(productFlavorContainer);
        return this;
    }

    DefaultAndroidProject addVariant(VariantImpl variant) {
        this.variants.add(variant);
        return this;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public int getApiVersion() {
        return this.apiVersion;
    }

    public String getName() {
        return this.name;
    }

    public ProductFlavorContainer getDefaultConfig() {
        return this.defaultConfig;
    }

    public Collection<BuildTypeContainer> getBuildTypes() {
        return this.buildTypes;
    }

    public Collection<ProductFlavorContainer> getProductFlavors() {
        return this.productFlavors;
    }

    public Collection<Variant> getVariants() {
        return this.variants;
    }

    public Collection<String> getFlavorDimensions() {
        return this.flavorDimensions;
    }

    public Collection<ArtifactMetaData> getExtraArtifacts() {
        return this.extraArtifacts;
    }

    public boolean isLibrary() {
        return this.isLibrary;
    }

    public String getCompileTarget() {
        return this.compileTarget;
    }

    public Collection<String> getBootClasspath() {
        return this.bootClasspath;
    }

    public Collection<File> getFrameworkSources() {
        return this.frameworkSource;
    }

    public Collection<SigningConfig> getSigningConfigs() {
        return this.signingConfigs;
    }

    public AaptOptions getAaptOptions() {
        return this.aaptOptions;
    }

    public LintOptions getLintOptions() {
        return this.lintOptions;
    }

    public Collection<String> getUnresolvedDependencies() {
        return this.unresolvedDependencies;
    }

    public Collection<SyncIssue> getSyncIssues() {
        return this.syncIssues;
    }

    public JavaCompileOptions getJavaCompileOptions() {
        return this.javaCompileOptions;
    }

    public File getBuildFolder() {
        return this.buildFolder;
    }

    public String getResourcePrefix() {
        return this.resourcePrefix;
    }

    public Collection<NativeToolchain> getNativeToolchains() {
        return this.nativeToolchains;
    }
}

