/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.util;

import com.esotericsoftware.kryo.util.ObjectMap;

public class IdentityObjectIntMap<K> {
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    public int size;
    K[] keyTable;
    int[] valueTable;
    int capacity;
    int stashSize;
    private float loadFactor;
    private int hashShift;
    private int mask;
    private int threshold;
    private int stashCapacity;
    private int pushIterations;

    public IdentityObjectIntMap() {
        this(32, 0.8f);
    }

    public IdentityObjectIntMap(int n) {
        this(n, 0.8f);
    }

    public IdentityObjectIntMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: " + n);
        }
        if (this.capacity > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: " + n);
        }
        this.capacity = ObjectMap.nextPowerOfTwo(n);
        if (f <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: " + f);
        }
        this.loadFactor = f;
        this.threshold = (int)((float)this.capacity * f);
        this.mask = this.capacity - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(this.capacity);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
        this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
        this.keyTable = new Object[this.capacity + this.stashCapacity];
        this.valueTable = new int[this.keyTable.length];
    }

    public void put(K k, int n) {
        int n2;
        if (k == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        K[] KArray = this.keyTable;
        int n3 = System.identityHashCode(k);
        int n4 = n3 & this.mask;
        K k2 = KArray[n4];
        if (k == k2) {
            this.valueTable[n4] = n;
            return;
        }
        int n5 = this.hash2(n3);
        K k3 = KArray[n5];
        if (k == k3) {
            this.valueTable[n5] = n;
            return;
        }
        int n6 = this.hash3(n3);
        K k4 = KArray[n6];
        if (k == k4) {
            this.valueTable[n6] = n;
            return;
        }
        int n7 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n7; ++n2) {
            if (KArray[n2] != k) continue;
            this.valueTable[n2] = n;
            return;
        }
        if (k2 == null) {
            KArray[n4] = k;
            this.valueTable[n4] = n;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        if (k3 == null) {
            KArray[n5] = k;
            this.valueTable[n5] = n;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        if (k4 == null) {
            KArray[n6] = k;
            this.valueTable[n6] = n;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(k, n, n4, k2, n5, k3, n6, k4);
    }

    private void putResize(K k, int n) {
        int n2 = System.identityHashCode(k);
        int n3 = n2 & this.mask;
        K k2 = this.keyTable[n3];
        if (k2 == null) {
            this.keyTable[n3] = k;
            this.valueTable[n3] = n;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n4 = this.hash2(n2);
        K k3 = this.keyTable[n4];
        if (k3 == null) {
            this.keyTable[n4] = k;
            this.valueTable[n4] = n;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n5 = this.hash3(n2);
        K k4 = this.keyTable[n5];
        if (k4 == null) {
            this.keyTable[n5] = k;
            this.valueTable[n5] = n;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(k, n, n3, k2, n4, k3, n5, k4);
    }

    private void push(K k, int n, int n2, K k2, int n3, K k3, int n4, K k4) {
        int n5;
        K k5;
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        int n6 = this.mask;
        int n7 = 0;
        int n8 = this.pushIterations;
        while (true) {
            switch (ObjectMap.random.nextInt(3)) {
                case 0: {
                    k5 = k2;
                    n5 = nArray[n2];
                    KArray[n2] = k;
                    nArray[n2] = n;
                    break;
                }
                case 1: {
                    k5 = k3;
                    n5 = nArray[n3];
                    KArray[n3] = k;
                    nArray[n3] = n;
                    break;
                }
                default: {
                    k5 = k4;
                    n5 = nArray[n4];
                    KArray[n4] = k;
                    nArray[n4] = n;
                }
            }
            int n9 = System.identityHashCode(k5);
            n2 = n9 & n6;
            k2 = KArray[n2];
            if (k2 == null) {
                KArray[n2] = k5;
                nArray[n2] = n5;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n3 = this.hash2(n9);
            k3 = KArray[n3];
            if (k3 == null) {
                KArray[n3] = k5;
                nArray[n3] = n5;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n4 = this.hash3(n9);
            k4 = KArray[n4];
            if (k4 == null) {
                KArray[n4] = k5;
                nArray[n4] = n5;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++n7 == n8) break;
            k = k5;
            n = n5;
        }
        this.putStash(k5, n5);
    }

    private void putStash(K k, int n) {
        if (this.stashSize == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.put(k, n);
            return;
        }
        int n2 = this.capacity + this.stashSize;
        this.keyTable[n2] = k;
        this.valueTable[n2] = n;
        ++this.stashSize;
        ++this.size;
    }

    public int get(K k, int n) {
        int n2 = System.identityHashCode(k);
        int n3 = n2 & this.mask;
        if (k != this.keyTable[n3] && k != this.keyTable[n3 = this.hash2(n2)] && k != this.keyTable[n3 = this.hash3(n2)]) {
            return this.getStash(k, n);
        }
        return this.valueTable[n3];
    }

    private int getStash(K k, int n) {
        int n2;
        K[] KArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (k != KArray[n2]) continue;
            return this.valueTable[n2];
        }
        return n;
    }

    public int getAndIncrement(K k, int n, int n2) {
        int n3 = System.identityHashCode(k);
        int n4 = n3 & this.mask;
        if (k != this.keyTable[n4] && k != this.keyTable[n4 = this.hash2(n3)] && k != this.keyTable[n4 = this.hash3(n3)]) {
            return this.getAndIncrementStash(k, n, n2);
        }
        int n5 = this.valueTable[n4];
        this.valueTable[n4] = n5 + n2;
        return n5;
    }

    private int getAndIncrementStash(K k, int n, int n2) {
        int n3;
        K[] KArray = this.keyTable;
        int n4 = n3 + this.stashSize;
        for (n3 = this.capacity; n3 < n4; ++n3) {
            if (k != KArray[n3]) continue;
            int n5 = this.valueTable[n3];
            this.valueTable[n3] = n5 + n2;
            return n5;
        }
        this.put(k, n + n2);
        return n;
    }

    public int remove(K k, int n) {
        int n2 = System.identityHashCode(k);
        int n3 = n2 & this.mask;
        if (k == this.keyTable[n3]) {
            this.keyTable[n3] = null;
            int n4 = this.valueTable[n3];
            --this.size;
            return n4;
        }
        n3 = this.hash2(n2);
        if (k == this.keyTable[n3]) {
            this.keyTable[n3] = null;
            int n5 = this.valueTable[n3];
            --this.size;
            return n5;
        }
        n3 = this.hash3(n2);
        if (k == this.keyTable[n3]) {
            this.keyTable[n3] = null;
            int n6 = this.valueTable[n3];
            --this.size;
            return n6;
        }
        return this.removeStash(k, n);
    }

    int removeStash(K k, int n) {
        int n2;
        K[] KArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (k != KArray[n2]) continue;
            int n4 = this.valueTable[n2];
            this.removeStashIndex(n2);
            --this.size;
            return n4;
        }
        return n;
    }

    void removeStashIndex(int n) {
        --this.stashSize;
        int n2 = this.capacity + this.stashSize;
        if (n < n2) {
            this.keyTable[n] = this.keyTable[n2];
            this.valueTable[n] = this.valueTable[n2];
        }
    }

    public void shrink(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + n);
        }
        if (this.size > n) {
            n = this.size;
        }
        if (this.capacity <= n) {
            return;
        }
        n = ObjectMap.nextPowerOfTwo(n);
        this.resize(n);
    }

    public void clear(int n) {
        if (this.capacity <= n) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(n);
    }

    public void clear() {
        K[] KArray = this.keyTable;
        int n = this.capacity + this.stashSize;
        while (n-- > 0) {
            KArray[n] = null;
        }
        this.size = 0;
        this.stashSize = 0;
    }

    public boolean containsValue(int n) {
        int[] nArray = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        while (n2-- > 0) {
            if (nArray[n2] != n) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(K k) {
        int n = System.identityHashCode(k);
        int n2 = n & this.mask;
        if (k != this.keyTable[n2] && k != this.keyTable[n2 = this.hash2(n)] && k != this.keyTable[n2 = this.hash3(n)]) {
            return this.containsKeyStash(k);
        }
        return true;
    }

    private boolean containsKeyStash(K k) {
        int n;
        K[] KArray = this.keyTable;
        int n2 = n + this.stashSize;
        for (n = this.capacity; n < n2; ++n) {
            if (k != KArray[n]) continue;
            return true;
        }
        return false;
    }

    public K findKey(int n) {
        int[] nArray = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        while (n2-- > 0) {
            if (nArray[n2] != n) continue;
            return this.keyTable[n2];
        }
        return null;
    }

    public void ensureCapacity(int n) {
        int n2 = this.size + n;
        if (n2 >= this.threshold) {
            this.resize(ObjectMap.nextPowerOfTwo((int)((float)n2 / this.loadFactor)));
        }
    }

    private void resize(int n) {
        int n2 = this.capacity + this.stashSize;
        this.capacity = n;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(n)) * 2);
        this.pushIterations = Math.max(Math.min(n, 8), (int)Math.sqrt(n) / 8);
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        this.keyTable = new Object[n + this.stashCapacity];
        this.valueTable = new int[n + this.stashCapacity];
        int n3 = this.size;
        this.size = 0;
        this.stashSize = 0;
        if (n3 > 0) {
            for (int i = 0; i < n2; ++i) {
                K k = KArray[i];
                if (k == null) continue;
                this.putResize(k, nArray[i]);
            }
        }
    }

    private int hash2(int n) {
        return ((n *= -1262997959) ^ n >>> this.hashShift) & this.mask;
    }

    private int hash3(int n) {
        return ((n *= -825114047) ^ n >>> this.hashShift) & this.mask;
    }

    public String toString() {
        K k;
        if (this.size == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('{');
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        int n = KArray.length;
        while (n-- > 0) {
            k = KArray[n];
            if (k == null) continue;
            stringBuilder.append(k);
            stringBuilder.append('=');
            stringBuilder.append(nArray[n]);
            break;
        }
        while (n-- > 0) {
            k = KArray[n];
            if (k == null) continue;
            stringBuilder.append(", ");
            stringBuilder.append(k);
            stringBuilder.append('=');
            stringBuilder.append(nArray[n]);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

