/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.PsiFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesStructureViewElement
implements StructureViewTreeElement,
ResourceBundleEditorViewElement {
    private final IProperty myProperty;
    private String myPresentableName;
    private static final TextAttributesKey GROUP_KEY;

    public PropertiesStructureViewElement(IProperty element) {
        this.myProperty = element;
    }

    public IProperty getValue() {
        return this.myProperty;
    }

    public void navigate(boolean requestFocus) {
        this.myProperty.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myProperty.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myProperty.canNavigateToSource();
    }

    @NotNull
    public StructureViewTreeElement[] getChildren() {
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/structureView/PropertiesStructureViewElement", "getChildren"));
        }
        return EMPTY_ARRAY;
    }

    @Override
    @Nullable
    public PsiFile[] getFiles() {
        return null;
    }

    @Override
    @NotNull
    public IProperty[] getProperties() {
        IProperty[] iPropertyArray = new IProperty[]{this.getValue()};
        if (iPropertyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/structureView/PropertiesStructureViewElement", "getProperties"));
        }
        return iPropertyArray;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        ColoredItemPresentation coloredItemPresentation = new ColoredItemPresentation(){

            @Nullable
            public TextAttributesKey getTextAttributesKey() {
                return PropertiesStructureViewElement.this.myPresentableName != null && PropertiesStructureViewElement.this.myPresentableName.isEmpty() ? GROUP_KEY : null;
            }

            public String getPresentableText() {
                return PropertiesStructureViewElement.this.myPresentableName == null ? PropertiesStructureViewElement.this.myProperty.getUnescapedKey() : (PropertiesStructureViewElement.this.myPresentableName.isEmpty() ? "<property>" : PropertiesStructureViewElement.this.myPresentableName);
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return PropertiesStructureViewElement.this.myProperty.getIcon(0);
            }
        };
        if (coloredItemPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/structureView/PropertiesStructureViewElement", "getPresentation"));
        }
        return coloredItemPresentation;
    }

    public void setPresentableName(String presentableName) {
        this.myPresentableName = presentableName;
    }

    static {
        TextAttributes attributes = new TextAttributes();
        attributes.setFontType(2);
        GROUP_KEY = TextAttributesKey.createTextAttributesKey((String)"STRUCTURE_GROUP_KEY", (TextAttributes)attributes);
    }
}

