/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.jcip.annotations.NotThreadSafe;
import org.gradle.api.Nullable;
import org.gradle.internal.BiActions;
import org.gradle.internal.Cast;
import org.gradle.model.ConfigurationCycleException;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.DuplicateModelException;
import org.gradle.model.internal.core.EmptyModelProjection;
import org.gradle.model.internal.core.ExtractedModelRule;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelAdapter;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelCreators;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRule;
import org.gradle.model.internal.core.ModelRuleExecutionException;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.ModelRuleExtractor;
import org.gradle.model.internal.registry.AnyStateBindingPredicate;
import org.gradle.model.internal.registry.BindingPredicate;
import org.gradle.model.internal.registry.CreatorRuleBinder;
import org.gradle.model.internal.registry.ModelBinding;
import org.gradle.model.internal.registry.ModelCreationListener;
import org.gradle.model.internal.registry.ModelGraph;
import org.gradle.model.internal.registry.ModelNodeInternal;
import org.gradle.model.internal.registry.ModelPathSuggestionProvider;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.registry.MutatorRuleBinder;
import org.gradle.model.internal.registry.NodeAtState;
import org.gradle.model.internal.registry.RuleBinder;
import org.gradle.model.internal.registry.RuleBindings;
import org.gradle.model.internal.registry.RuleContext;
import org.gradle.model.internal.registry.UnboundModelRulesException;
import org.gradle.model.internal.registry.UnboundRulesProcessor;
import org.gradle.model.internal.report.unbound.UnboundRule;
import org.gradle.model.internal.type.ModelType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class DefaultModelRegistry
implements ModelRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultModelRegistry.class);
    private final ModelGraph modelGraph;
    private final RuleBindings ruleBindings;
    private final ModelRuleExtractor ruleExtractor;
    private final Set<RuleBinder> unboundRules = Sets.newIdentityHashSet();
    boolean reset;

    public DefaultModelRegistry(ModelRuleExtractor ruleExtractor) {
        this.ruleExtractor = ruleExtractor;
        ModelCreator rootCreator = ModelCreators.of(ModelPath.ROOT, BiActions.doNothing()).descriptor("<root>").withProjection(EmptyModelProjection.INSTANCE).build();
        this.modelGraph = new ModelGraph(new ModelElementNode(this.toCreatorBinder(rootCreator, ModelPath.ROOT), null));
        this.modelGraph.getRoot().setState(ModelNode.State.Created);
        this.ruleBindings = new RuleBindings(this.modelGraph);
    }

    private static String toString(ModelRuleDescriptor descriptor) {
        StringBuilder stringBuilder = new StringBuilder();
        descriptor.describeTo(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public DefaultModelRegistry create(ModelCreator creator) {
        ModelPath path = creator.getPath();
        if (!ModelPath.ROOT.isDirectChild(path)) {
            throw new InvalidModelRuleDeclarationException(creator.getDescriptor(), "Cannot create element at '" + path + "', only top level is allowed (e.g. '" + path.getRootParent() + "')");
        }
        ModelNodeInternal root = this.modelGraph.getRoot();
        this.registerNode(root, new ModelElementNode(this.toCreatorBinder(creator, ModelPath.ROOT), root));
        return this;
    }

    private CreatorRuleBinder toCreatorBinder(ModelCreator creator, ModelPath scope) {
        BindingPredicate subject = new BindingPredicate(ModelReference.of(creator.getPath(), ModelType.untyped(), ModelNode.State.Created));
        List<BindingPredicate> inputs = this.mapInputs(creator.getInputs(), scope);
        return new CreatorRuleBinder(creator, subject, inputs, this.unboundRules);
    }

    private ModelNodeInternal registerNode(ModelNodeInternal parent, ModelNodeInternal child) {
        if (this.reset) {
            this.unboundRules.remove(child.getCreatorBinder());
            return child;
        }
        ModelCreator creator = child.getCreatorBinder().getCreator();
        ModelPath path = child.getPath();
        ModelNodeInternal node = this.modelGraph.find(path);
        if (node != null) {
            if (node.getState() == ModelNode.State.Known) {
                throw new DuplicateModelException(String.format("Cannot create '%s' using creation rule '%s' as the rule '%s' is already registered to create this model element.", path, DefaultModelRegistry.toString(creator.getDescriptor()), DefaultModelRegistry.toString(node.getDescriptor())));
            }
            throw new DuplicateModelException(String.format("Cannot create '%s' using creation rule '%s' as the rule '%s' has already been used to create this model element.", path, DefaultModelRegistry.toString(creator.getDescriptor()), DefaultModelRegistry.toString(node.getDescriptor())));
        }
        if (!parent.isMutable()) {
            throw new IllegalStateException(String.format("Cannot create '%s' using creation rule '%s' as model element '%s' is no longer mutable.", path, DefaultModelRegistry.toString(creator.getDescriptor()), parent.getPath()));
        }
        node = parent.addLink(child);
        this.ruleBindings.add(node);
        this.modelGraph.add(node);
        this.ruleBindings.add(node.getCreatorBinder());
        return node;
    }

    @Override
    public <T> DefaultModelRegistry configure(ModelActionRole role, ModelAction<T> action) {
        this.bind(action.getSubject(), role, action, ModelPath.ROOT);
        return this;
    }

    @Override
    public ModelRegistry apply(Class<? extends RuleSource> rules) {
        this.modelGraph.getRoot().applyToSelf(rules);
        return this;
    }

    private <T> void bind(ModelActionRole role, ModelAction<T> mutator, ModelPath scope) {
        this.bind(mutator.getSubject(), role, mutator, scope);
    }

    private <T> void bind(ModelReference<T> subject, ModelActionRole role, ModelAction<T> mutator, ModelPath scope) {
        if (this.reset) {
            return;
        }
        BindingPredicate mappedSubject = this.mapSubject(subject, role, scope);
        List<BindingPredicate> mappedInputs = this.mapInputs(mutator.getInputs(), scope);
        MutatorRuleBinder<T> binder = new MutatorRuleBinder<T>(mappedSubject, mappedInputs, mutator, this.unboundRules);
        this.ruleBindings.add(binder);
    }

    @Override
    public <T> T realize(ModelPath path, ModelType<T> type) {
        return this.toType(type, this.require(path), "get(ModelPath, ModelType)");
    }

    @Override
    public ModelNode atState(ModelPath path, ModelNode.State state) {
        return this.atStateOrMaybeLater(path, state, false);
    }

    @Override
    public ModelNode atStateOrLater(ModelPath path, ModelNode.State state) {
        return this.atStateOrMaybeLater(path, state, true);
    }

    private ModelNode atStateOrMaybeLater(ModelPath path, ModelNode.State state, boolean laterOk) {
        ModelNodeInternal node = this.modelGraph.find(path);
        if (node == null) {
            return null;
        }
        this.transition(node, state, laterOk);
        return node;
    }

    @Override
    public <T> T find(ModelPath path, ModelType<T> type) {
        return this.toType(type, this.get(path), "find(ModelPath, ModelType)");
    }

    private <T> T toType(ModelType<T> type, ModelNodeInternal node, String msg) {
        if (node == null) {
            return null;
        }
        return this.assertView(node, type, null, msg, new Object[0]).getInstance();
    }

    @Override
    public ModelNode realizeNode(ModelPath path) {
        return this.require(path);
    }

    private void registerListener(ModelCreationListener listener) {
        this.modelGraph.addListener(listener);
    }

    @Override
    public void remove(ModelPath path) {
        ModelNodeInternal node = this.modelGraph.find(path);
        if (node == null) {
            return;
        }
        Iterable<? extends ModelNode> dependents = node.getDependents();
        if (!Iterables.isEmpty(dependents)) {
            throw new RuntimeException("Tried to remove model " + path + " but it is depended on by: " + Joiner.on((String)", ").join(dependents));
        }
        this.modelGraph.remove(node);
        this.ruleBindings.remove(node);
        this.unboundRules.remove(node.getCreatorBinder());
    }

    @Override
    public ModelRegistry createOrReplace(ModelCreator newCreator) {
        ModelPath path = newCreator.getPath();
        ModelNodeInternal node = this.modelGraph.find(path);
        if (node == null) {
            ModelNodeInternal parent = this.modelGraph.find(path.getParent());
            if (parent == null) {
                throw new IllegalStateException("Cannot create '" + path + "' as its parent node does not exist");
            }
            parent.addLink(newCreator);
        } else {
            this.replace(newCreator);
        }
        return this;
    }

    @Override
    public ModelRegistry replace(ModelCreator newCreator) {
        ModelNodeInternal node = this.modelGraph.find(newCreator.getPath());
        if (node == null) {
            throw new IllegalStateException("can not replace node " + newCreator.getPath() + " as it does not exist");
        }
        node.replaceCreatorRuleBinder(this.toCreatorBinder(newCreator, ModelPath.ROOT));
        this.ruleBindings.add(node.getCreatorBinder());
        return this;
    }

    @Override
    public void bindAllReferences() throws UnboundModelRulesException {
        if (this.unboundRules.isEmpty()) {
            return;
        }
        GoalGraph graph = new GoalGraph();
        boolean newInputsBound = true;
        while (!this.unboundRules.isEmpty() && newInputsBound) {
            RuleBinder[] unboundBinders;
            newInputsBound = false;
            for (RuleBinder binder : unboundBinders = this.unboundRules.toArray(new RuleBinder[this.unboundRules.size()])) {
                this.transitionTo(graph, new TryBindInputs(binder));
                newInputsBound = newInputsBound || binder.isBound();
            }
        }
        if (!this.unboundRules.isEmpty()) {
            TreeSet<RuleBinder> sortedBinders = new TreeSet<RuleBinder>(new Comparator<RuleBinder>(){

                @Override
                public int compare(RuleBinder o1, RuleBinder o2) {
                    return o1.getDescriptor().toString().compareTo(o2.getDescriptor().toString());
                }
            });
            sortedBinders.addAll(this.unboundRules);
            throw this.unbound(sortedBinders);
        }
    }

    private UnboundModelRulesException unbound(Iterable<? extends RuleBinder> binders) {
        ModelPathSuggestionProvider suggestionsProvider = new ModelPathSuggestionProvider(this.modelGraph.getFlattened().keySet());
        List<? extends UnboundRule> unboundRules = new UnboundRulesProcessor(binders, suggestionsProvider).process();
        return new UnboundModelRulesException(unboundRules);
    }

    private ModelNodeInternal require(ModelPath path) {
        ModelNodeInternal node = this.get(path);
        if (node == null) {
            throw new IllegalStateException("No model node at '" + path + "'");
        }
        return node;
    }

    @Override
    public ModelNode.State state(ModelPath path) {
        ModelNodeInternal modelNode = this.modelGraph.find(path);
        return modelNode == null ? null : modelNode.getState();
    }

    private ModelNodeInternal get(ModelPath path) {
        ModelNodeInternal node = this.modelGraph.find(path);
        if (node == null) {
            return null;
        }
        this.close(node);
        return node;
    }

    private void close(ModelNodeInternal node) {
        this.transition(node, ModelNode.State.GraphClosed, false);
    }

    private void transitionTo(GoalGraph goalGraph, ModelGoal targetGoal) {
        LinkedList<ModelGoal> queue = new LinkedList<ModelGoal>();
        queue.add(targetGoal);
        while (!queue.isEmpty()) {
            ModelGoal goal = (ModelGoal)queue.getFirst();
            if (goal.state == ModelGoal.State.Achieved) {
                queue.removeFirst();
                continue;
            }
            if (goal.state == ModelGoal.State.NotSeen && goal.isAchieved()) {
                goal.state = ModelGoal.State.Achieved;
                queue.removeFirst();
                continue;
            }
            if (goal.state == ModelGoal.State.VisitingDependencies) {
                goal.apply();
                goal.state = ModelGoal.State.Achieved;
                queue.removeFirst();
                continue;
            }
            ArrayList<ModelGoal> newDependencies = new ArrayList<ModelGoal>();
            goal.attachNode();
            boolean done = goal.calculateDependencies(goalGraph, newDependencies);
            goal.state = done || newDependencies.isEmpty() ? ModelGoal.State.VisitingDependencies : ModelGoal.State.DiscoveringDependencies;
            for (int i = newDependencies.size() - 1; i >= 0; --i) {
                ModelGoal dependency = (ModelGoal)newDependencies.get(i);
                if (dependency.state == ModelGoal.State.Achieved) continue;
                if (dependency.state == ModelGoal.State.NotSeen) {
                    queue.addFirst(dependency);
                    continue;
                }
                throw this.ruleCycle(dependency, queue);
            }
        }
    }

    private ConfigurationCycleException ruleCycle(ModelGoal brokenGoal, LinkedList<ModelGoal> queue) {
        ArrayList<String> path = new ArrayList<String>();
        int pos = queue.indexOf(brokenGoal);
        ListIterator<ModelGoal> iterator = queue.listIterator(pos + 1);
        while (iterator.hasPrevious()) {
            ModelGoal goal = iterator.previous();
            goal.attachToCycle(path);
        }
        brokenGoal.attachToCycle(path);
        Formatter out = new Formatter();
        out.format("A cycle has been detected in model rule dependencies. References forming the cycle:", new Object[0]);
        String last = null;
        StringBuilder indent = new StringBuilder("");
        for (int i = 0; i < path.size(); ++i) {
            String node = (String)path.get(i);
            if (node.equals(last)) continue;
            last = node;
            if (i == 0) {
                out.format("%n%s%s", indent, node);
                continue;
            }
            out.format("%n%s\\- %s", indent, node);
            indent.append("   ");
        }
        return new ConfigurationCycleException(out.toString());
    }

    private void transition(ModelNodeInternal node, ModelNode.State desired, boolean laterOk) {
        ModelPath path = node.getPath();
        ModelNode.State state = node.getState();
        LOGGER.debug("Transitioning model element '{}' from state {} to {}", new Object[]{path, state.name(), desired.name()});
        if (desired.ordinal() < state.ordinal()) {
            if (laterOk) {
                return;
            }
            throw new IllegalStateException("Cannot lifecycle model node '" + path + "' to state " + desired.name() + " as it is already at " + state.name());
        }
        if (state == desired) {
            return;
        }
        GoalGraph goalGraph = new GoalGraph();
        this.transitionTo(goalGraph, goalGraph.nodeAtState(new NodeAtState(node.getPath(), desired)));
    }

    private <T> ModelView<? extends T> assertView(ModelNodeInternal node, ModelType<T> targetType, @Nullable ModelRuleDescriptor descriptor, String msg, Object ... msgArgs) {
        ModelAdapter adapter = node.getAdapter();
        ModelView<T> view = adapter.asReadOnly(targetType, node, descriptor);
        if (view == null) {
            throw new IllegalArgumentException("Model node '" + node.getPath().toString() + "' is not compatible with requested " + targetType + " (operation: " + String.format(msg, msgArgs) + ")");
        }
        return view;
    }

    private <T> ModelView<? extends T> assertView(ModelNodeInternal node, ModelReference<T> reference, ModelRuleDescriptor sourceDescriptor, List<ModelView<?>> inputs) {
        ModelAdapter adapter = node.getAdapter();
        ModelView<T> view = adapter.asWritable(reference.getType(), node, sourceDescriptor, inputs);
        if (view == null) {
            throw new IllegalArgumentException("Cannot project model element " + node.getPath() + " to writable type '" + reference.getType() + "' for rule " + sourceDescriptor);
        }
        return view;
    }

    private ModelNodeInternal doCreate(final ModelNodeInternal node, CreatorRuleBinder boundCreator) {
        final ModelCreator creator = boundCreator.getCreator();
        final List<ModelView<?>> views = this.toViews(boundCreator.getInputBindings(), boundCreator.getCreator());
        LOGGER.debug("Creating {} using {}", (Object)node.getPath(), (Object)creator.getDescriptor());
        try {
            RuleContext.run(creator.getDescriptor(), new Runnable(){

                public void run() {
                    creator.create(node, views);
                }
            });
        }
        catch (Exception e) {
            throw new ModelRuleExecutionException(creator.getDescriptor(), e);
        }
        return node;
    }

    private <T> void fireMutation(MutatorRuleBinder<T> boundMutator) {
        final List<ModelView<?>> inputs = this.toViews(boundMutator.getInputBindings(), boundMutator.getAction());
        final ModelNodeInternal node = boundMutator.getSubjectBinding().getNode();
        final ModelAction<T> mutator = boundMutator.getAction();
        ModelRuleDescriptor descriptor = mutator.getDescriptor();
        LOGGER.debug("Mutating {} using {}", (Object)node.getPath(), (Object)mutator.getDescriptor());
        ModelReference reference = (ModelReference)Cast.uncheckedCast(boundMutator.getSubjectReference().getReference());
        final ModelView<T> view = this.assertView(node, reference, descriptor, inputs);
        try {
            RuleContext.run(descriptor, new Runnable(){

                public void run() {
                    mutator.execute(node, view.getInstance(), inputs);
                }
            });
        }
        catch (Exception e) {
            throw new ModelRuleExecutionException(descriptor, e);
        }
        finally {
            view.close();
        }
    }

    private List<ModelView<?>> toViews(List<ModelBinding> bindings, ModelRule modelRule) {
        ModelView[] array = new ModelView[bindings.size()];
        int i = 0;
        for (ModelBinding binding : bindings) {
            ModelNodeInternal element = binding.getNode();
            ModelView<?> view = this.assertView(element, binding.getPredicate().getType(), modelRule.getDescriptor(), "toViews", new Object[0]);
            array[i++] = view;
        }
        List<ModelView<?>> views = Arrays.asList(array);
        return views;
    }

    @Override
    public MutableModelNode getRoot() {
        return this.modelGraph.getRoot();
    }

    @Override
    public MutableModelNode node(ModelPath path) {
        return this.modelGraph.find(path);
    }

    @Override
    public void prepareForReuse() {
        this.reset = true;
        LinkedList ephemerals = Lists.newLinkedList();
        this.collectEphemeralChildren(this.modelGraph.getRoot(), ephemerals);
        if (ephemerals.isEmpty()) {
            LOGGER.info("No ephemeral model nodes found to reset");
        } else {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Resetting ephemeral model nodes: " + Joiner.on((String)", ").join((Iterable)ephemerals));
            }
            for (ModelNodeInternal ephemeral : ephemerals) {
                ephemeral.reset();
            }
        }
    }

    private void collectEphemeralChildren(ModelNodeInternal node, Collection<ModelNodeInternal> ephemerals) {
        for (ModelNodeInternal modelNodeInternal : node.getLinks()) {
            if (modelNodeInternal.isEphemeral()) {
                ephemerals.add(modelNodeInternal);
                continue;
            }
            this.collectEphemeralChildren(modelNodeInternal, ephemerals);
        }
    }

    private BindingPredicate mapSubject(ModelReference<?> subjectReference, ModelActionRole role, ModelPath scope) {
        ModelReference<?> mappedReference = subjectReference.getPath() == null ? subjectReference.inScope(scope) : subjectReference.withPath(scope.descendant(subjectReference.getPath()));
        if (role.getTargetState() != null) {
            return new BindingPredicate(mappedReference.atState(role.getTargetState()));
        }
        return new AnyStateBindingPredicate(mappedReference);
    }

    private List<BindingPredicate> mapInputs(List<ModelReference<?>> inputs, ModelPath scope) {
        if (inputs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BindingPredicate> result = new ArrayList<BindingPredicate>(inputs.size());
        for (ModelReference<?> input : inputs) {
            if (input.getPath() != null) {
                result.add(new BindingPredicate(input.withPath(scope.descendant(input.getPath()))));
                continue;
            }
            result.add(new BindingPredicate(input.inScope(ModelPath.ROOT)));
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RunModelAction
    extends RunAction {
        private final MutatorRuleBinder<?> binder;

        public RunModelAction(ModelPath path, MutatorRuleBinder<?> binder) {
            super(path, binder);
            this.binder = binder;
        }

        @Override
        void apply() {
            LOGGER.debug("Running model element '{}' rule action {}", (Object)this.getPath(), (Object)this.binder.getDescriptor());
            DefaultModelRegistry.this.fireMutation(this.binder);
            this.node.notifyFired(this.binder);
        }
    }

    private class RunCreatorAction
    extends RunAction {
        public RunCreatorAction(ModelPath path, CreatorRuleBinder binder) {
            super(path, binder);
        }

        void apply() {
            CreatorRuleBinder creatorBinder = this.node.getCreatorBinder();
            LOGGER.debug("Running model element '{}' creator rule action {}", (Object)this.getPath(), (Object)creatorBinder.getDescriptor());
            DefaultModelRegistry.this.doCreate(this.node, creatorBinder);
            this.node.notifyFired(creatorBinder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class RunAction
    extends ModelNodeGoal {
        private final RuleBinder binder;
        private boolean bindInputs;

        public RunAction(ModelPath path, RuleBinder binder) {
            super(path);
            this.binder = binder;
        }

        public String toString() {
            return "run action for " + this.getPath() + ", rule: " + this.binder.getDescriptor() + ", state: " + (Object)((Object)this.state);
        }

        @Override
        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            if (!this.bindInputs) {
                dependencies.add(new TryBindInputs(this.binder));
                this.bindInputs = true;
                return false;
            }
            if (!this.binder.isBound()) {
                throw DefaultModelRegistry.this.unbound(Collections.singleton(this.binder));
            }
            for (ModelBinding binding : this.binder.getInputBindings()) {
                dependencies.add(graph.nodeAtState(new NodeAtState(binding.getNode().getPath(), binding.getPredicate().getState())));
            }
            return true;
        }

        @Override
        void attachToCycle(List<String> displayValue) {
            displayValue.add(this.binder.getDescriptor().toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TryBindInputs
    extends ModelGoal {
        private final RuleBinder binder;

        public TryBindInputs(RuleBinder binder) {
            this.binder = binder;
        }

        public String toString() {
            return "bind inputs for " + this.binder.getDescriptor() + ", state: " + (Object)((Object)this.state);
        }

        @Override
        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            if (this.binder.getSubjectBinding() != null) {
                this.maybeBind(this.binder.getSubjectBinding(), dependencies);
            }
            for (ModelBinding binding : this.binder.getInputBindings()) {
                this.maybeBind(binding, dependencies);
            }
            return true;
        }

        private void maybeBind(ModelBinding binding, Collection<ModelGoal> dependencies) {
            if (!binding.isBound()) {
                if (binding.getPredicate().getPath() != null) {
                    dependencies.add(new TryDefineChildren(binding.getPredicate().getPath().getParent()));
                } else {
                    dependencies.add(new TryDefineChildren(binding.getPredicate().getScope()));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TryDefineChildren
    extends ModelGoal {
        private final ModelPath path;
        private boolean attemptedParent;

        public TryDefineChildren(ModelPath path) {
            this.path = path;
        }

        public ModelPath getPath() {
            return this.path;
        }

        @Override
        public boolean isAchieved() {
            ModelNodeInternal node = DefaultModelRegistry.this.modelGraph.find(this.path);
            return node != null && node.getState().compareTo(ModelNode.State.SelfClosed) >= 0;
        }

        @Override
        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            if (this.path.getParent() != null && !this.attemptedParent) {
                dependencies.add(new TryDefineChildren(this.path.getParent()));
                this.attemptedParent = true;
                return false;
            }
            if (DefaultModelRegistry.this.modelGraph.find(this.path) != null) {
                dependencies.add(graph.nodeAtState(new NodeAtState(this.path, ModelNode.State.SelfClosed)));
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CloseGraph
    extends TransitionNodeToState {
        public CloseGraph(NodeAtState target) {
            super(target);
        }

        @Override
        boolean doCalculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            for (ModelNodeInternal modelNodeInternal : this.node.getLinks()) {
                dependencies.add(graph.nodeAtState(new NodeAtState(modelNodeInternal.getPath(), ModelNode.State.GraphClosed)));
            }
            return true;
        }

        @Override
        void doApply(ModelNodeInternal node) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ApplyActions
    extends TransitionNodeToState {
        private final Set<RuleBinder> seenRules;

        public ApplyActions(NodeAtState target) {
            super(target);
            this.seenRules = new HashSet<RuleBinder>();
        }

        @Override
        boolean doCalculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            MutatorRuleBinder mutator;
            if (this.seenRules.isEmpty() && this.getTargetState().equals((Object)ModelNode.State.DefaultsApplied)) {
                for (RuleBinder binder : DefaultModelRegistry.this.ruleBindings.getRulesWithSubject(this.getPath())) {
                    if (!this.seenRules.add(binder)) continue;
                    mutator = (MutatorRuleBinder)Cast.uncheckedCast((Object)binder);
                    dependencies.add(new RunModelAction(this.getPath(), mutator));
                }
            }
            for (RuleBinder binder : DefaultModelRegistry.this.ruleBindings.getRulesWithSubject(this.target)) {
                if (!this.seenRules.add(binder)) continue;
                mutator = (MutatorRuleBinder)Cast.uncheckedCast((Object)binder);
                dependencies.add(new RunModelAction(this.getPath(), mutator));
            }
            return false;
        }

        @Override
        void doApply(ModelNodeInternal node) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransitionDependents
    extends ModelGoal {
        private final NodeAtState input;

        public TransitionDependents(NodeAtState input) {
            this.input = input;
        }

        @Override
        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            for (RuleBinder rule : DefaultModelRegistry.this.ruleBindings.getRulesWithInput(this.input)) {
                if (rule.getSubjectBinding() == null || !rule.getSubjectBinding().isBound() || rule.getSubjectReference().getState() == null || rule.getSubjectBinding().getNode().getPath().equals(this.input.path)) continue;
                dependencies.add(graph.nodeAtState(new NodeAtState(rule.getSubjectBinding().getNode().getPath(), rule.getSubjectReference().getState())));
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Create
    extends TransitionNodeToState {
        public Create(NodeAtState target) {
            super(target);
        }

        @Override
        boolean doCalculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            dependencies.add(new RunCreatorAction(this.getPath(), this.node.getCreatorBinder()));
            return true;
        }

        @Override
        void doApply(ModelNodeInternal node) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class TransitionNodeToState
    extends ModelNodeGoal {
        final NodeAtState target;
        private boolean seenPredecessor;

        public TransitionNodeToState(NodeAtState target) {
            super(target.path);
            this.target = target;
        }

        public String toString() {
            return "transition " + this.getPath() + ", target: " + (Object)((Object)this.target.state) + ", state: " + (Object)((Object)this.state);
        }

        public ModelNode.State getTargetState() {
            return this.target.state;
        }

        @Override
        public boolean doIsAchieved() {
            return this.node.getState().compareTo(this.getTargetState()) >= 0;
        }

        @Override
        public final boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            if (!this.seenPredecessor) {
                NodeAtState predecessor = new NodeAtState(this.getPath(), this.getTargetState().previous());
                dependencies.add(graph.nodeAtState(predecessor));
                dependencies.add(new TransitionDependents(predecessor));
                this.seenPredecessor = true;
                return false;
            }
            if (this.node == null) {
                throw new IllegalStateException(String.format("Cannot transition model element '%s' to state %s as it does not exist.", this.getPath(), this.getTargetState().name()));
            }
            return this.doCalculateDependencies(graph, dependencies);
        }

        boolean doCalculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            return true;
        }

        @Override
        public final void apply() {
            if (!this.node.getState().equals((Object)this.getTargetState().previous())) {
                throw new IllegalStateException(String.format("Cannot transition model element '%s' to state %s as it is already at state %s.", new Object[]{this.node.getPath(), this.getTargetState(), this.node.getState()}));
            }
            LOGGER.debug("Transitioning model element '{}' to state {}.", (Object)this.node.getPath(), (Object)this.getTargetState().name());
            this.doApply(this.node);
            this.node.setState(this.getTargetState());
        }

        abstract void doApply(ModelNodeInternal var1);

        @Override
        void attachToCycle(List<String> displayValue) {
            displayValue.add(this.getPath().toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MakeKnown
    extends ModelNodeGoal {
        public MakeKnown(ModelPath path) {
            super(path);
        }

        public String toString() {
            return "make known " + this.getPath() + ", state: " + (Object)((Object)this.state);
        }

        @Override
        public boolean doIsAchieved() {
            return true;
        }

        @Override
        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            ModelPath parent = this.getPath().getParent();
            if (parent != null) {
                dependencies.add(graph.nodeAtState(new NodeAtState(parent, ModelNode.State.SelfClosed)));
            }
            return true;
        }
    }

    private abstract class ModelNodeGoal
    extends ModelGoal {
        public final ModelPath target;
        public ModelNodeInternal node;

        protected ModelNodeGoal(ModelPath target) {
            this.target = target;
        }

        public ModelPath getPath() {
            return this.target;
        }

        public final boolean isAchieved() {
            this.node = DefaultModelRegistry.this.modelGraph.find(this.target);
            return this.node != null && this.doIsAchieved();
        }

        protected boolean doIsAchieved() {
            return false;
        }

        public void attachNode() {
            if (this.node != null) {
                return;
            }
            this.node = DefaultModelRegistry.this.modelGraph.find(this.getPath());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ModelGoal {
        public State state = State.NotSeen;

        private ModelGoal() {
        }

        public boolean isAchieved() {
            return false;
        }

        public void attachNode() {
        }

        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            return true;
        }

        void apply() {
        }

        void attachToCycle(List<String> displayValue) {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum State {
            NotSeen,
            DiscoveringDependencies,
            VisitingDependencies,
            Achieved;

        }
    }

    private class GoalGraph {
        private final Map<NodeAtState, ModelGoal> nodeStates = new HashMap<NodeAtState, ModelGoal>();

        private GoalGraph() {
        }

        public ModelGoal nodeAtState(NodeAtState goal) {
            ModelGoal node = this.nodeStates.get(goal);
            if (node == null) {
                switch (goal.state) {
                    case Known: {
                        node = new MakeKnown(goal.path);
                        break;
                    }
                    case Created: {
                        node = new Create(goal);
                        break;
                    }
                    case GraphClosed: {
                        node = new CloseGraph(goal);
                        break;
                    }
                    default: {
                        node = new ApplyActions(goal);
                    }
                }
                this.nodeStates.put(goal, node);
            }
            return node;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModelElementNode
    extends ModelNodeInternal {
        private final Map<String, ModelNodeInternal> links;
        private final MutableModelNode parent;
        private Object privateData;
        private ModelType<?> privateDataType;

        public ModelElementNode(CreatorRuleBinder creatorRuleBinder, MutableModelNode parent) {
            super(creatorRuleBinder);
            this.links = Maps.newTreeMap();
            this.parent = parent;
        }

        @Override
        public MutableModelNode getParent() {
            return this.parent;
        }

        @Override
        public ModelNodeInternal addLink(ModelNodeInternal node) {
            this.links.put(node.getPath().getName(), node);
            return node;
        }

        @Override
        public <T> T getPrivateData(Class<T> type) {
            return this.getPrivateData(ModelType.of(type));
        }

        @Override
        public <T> T getPrivateData(ModelType<T> type) {
            if (this.privateData == null) {
                return null;
            }
            if (!type.isAssignableFrom(this.privateDataType)) {
                throw new ClassCastException("Cannot get private data '" + this.privateData + "' of type '" + this.privateDataType + "' as type '" + type);
            }
            return (T)Cast.uncheckedCast((Object)this.privateData);
        }

        @Override
        public Object getPrivateData() {
            return this.privateData;
        }

        @Override
        public <T> void setPrivateData(Class<? super T> type, T object) {
            this.setPrivateData(ModelType.of(type), object);
        }

        @Override
        public <T> void setPrivateData(ModelType<? super T> type, T object) {
            if (!this.isMutable()) {
                throw new IllegalStateException(String.format("Cannot set value for model element '%s' as this element is not mutable.", this.getPath()));
            }
            this.privateDataType = type;
            this.privateData = object;
        }

        @Override
        public boolean hasLink(String name) {
            return this.links.containsKey(name);
        }

        @Override
        @Nullable
        public ModelNodeInternal getLink(String name) {
            return this.links.get(name);
        }

        @Override
        public Iterable<? extends ModelNodeInternal> getLinks() {
            return this.links.values();
        }

        @Override
        public int getLinkCount(ModelType<?> type) {
            int count = 0;
            for (ModelNodeInternal linked : this.links.values()) {
                if (!linked.getPromise().canBeViewedAsWritable(type)) continue;
                ++count;
            }
            return count;
        }

        @Override
        public Set<String> getLinkNames(ModelType<?> type) {
            LinkedHashSet names = Sets.newLinkedHashSet();
            for (Map.Entry<String, ModelNodeInternal> entry : this.links.entrySet()) {
                if (!entry.getValue().getPromise().canBeViewedAsWritable(type)) continue;
                names.add(entry.getKey());
            }
            return names;
        }

        @Override
        public Iterable<? extends MutableModelNode> getLinks(final ModelType<?> type) {
            return Iterables.filter(this.links.values(), (Predicate)new Predicate<ModelNodeInternal>(){

                public boolean apply(ModelNodeInternal input) {
                    return input.getPromise().canBeViewedAsWritable(type);
                }
            });
        }

        @Override
        public int getLinkCount() {
            return this.links.size();
        }

        @Override
        public boolean hasLink(String name, ModelType<?> type) {
            ModelNodeInternal linked = this.getLink(name);
            return linked != null && linked.getPromise().canBeViewedAsWritable(type);
        }

        @Override
        public <T> void applyToSelf(ModelActionRole type, ModelAction<T> action) {
            if (!this.getPath().equals(action.getSubject().getPath())) {
                throw new IllegalArgumentException(String.format("Element action reference has path (%s) which does not reference this node (%s).", action.getSubject().getPath(), this.getPath()));
            }
            DefaultModelRegistry.this.bind(action.getSubject(), type, action, ModelPath.ROOT);
        }

        @Override
        public <T> void applyToLink(ModelActionRole type, ModelAction<T> action) {
            if (!this.getPath().isDirectChild(action.getSubject().getPath())) {
                throw new IllegalArgumentException(String.format("Linked element action reference has a path (%s) which is not a child of this node (%s).", action.getSubject().getPath(), this.getPath()));
            }
            DefaultModelRegistry.this.bind(action.getSubject(), type, action, ModelPath.ROOT);
        }

        @Override
        public void applyToLink(String name, Class<? extends RuleSource> rules) {
            this.apply(rules, this.getPath().child(name));
        }

        @Override
        public void applyToSelf(Class<? extends RuleSource> rules) {
            this.apply(rules, this.getPath());
        }

        @Override
        public void applyToLinks(final ModelType<?> type, final Class<? extends RuleSource> rules) {
            DefaultModelRegistry.this.registerListener(new ModelCreationListener(){

                @Override
                @Nullable
                public ModelPath getParent() {
                    return this.getPath();
                }

                @Override
                @Nullable
                public ModelType<?> getType() {
                    return type;
                }

                @Override
                public boolean onCreate(ModelNodeInternal node) {
                    node.applyToSelf(rules);
                    return false;
                }
            });
        }

        @Override
        public void applyToAllLinksTransitive(final ModelType<?> type, final Class<? extends RuleSource> rules) {
            DefaultModelRegistry.this.registerListener(new ModelCreationListener(){

                @Override
                public ModelPath getAncestor() {
                    return ModelElementNode.this.getPath();
                }

                @Override
                @Nullable
                public ModelType<?> getType() {
                    return type;
                }

                @Override
                public boolean onCreate(ModelNodeInternal node) {
                    node.applyToSelf(rules);
                    return false;
                }
            });
        }

        public void apply(Class<? extends RuleSource> rules, ModelPath scope) {
            Iterable<ExtractedModelRule> extractedRules = DefaultModelRegistry.this.ruleExtractor.extract(rules);
            for (ExtractedModelRule extractedRule : extractedRules) {
                if (!extractedRule.getRuleDependencies().isEmpty()) {
                    throw new IllegalStateException("Rule source " + rules + " cannot have plugin dependencies (introduced by rule " + extractedRule + ")");
                }
                if (extractedRule.getType().equals((Object)ExtractedModelRule.Type.CREATOR)) {
                    if (scope.equals(ModelPath.ROOT)) {
                        DefaultModelRegistry.this.create(extractedRule.getCreator());
                        continue;
                    }
                    throw new InvalidModelRuleDeclarationException("Rule " + extractedRule.getCreator().getDescriptor() + " cannot be applied at the scope of model element " + scope + " as creation rules cannot be used when applying rule sources to particular elements");
                }
                if (extractedRule.getType().equals((Object)ExtractedModelRule.Type.ACTION)) {
                    DefaultModelRegistry.this.bind(extractedRule.getActionRole(), extractedRule.getAction(), scope);
                    continue;
                }
                throw new IllegalStateException("unexpected extracted rule type: " + (Object)((Object)extractedRule.getType()));
            }
        }

        @Override
        public <T> void applyToAllLinks(final ModelActionRole type, final ModelAction<T> action) {
            if (action.getSubject().getPath() != null) {
                throw new IllegalArgumentException("Linked element action reference must have null path.");
            }
            DefaultModelRegistry.this.registerListener(new ModelCreationListener(){

                @Override
                @Nullable
                public ModelPath getParent() {
                    return ModelElementNode.this.getPath();
                }

                @Override
                @Nullable
                public ModelType<?> getType() {
                    return action.getSubject().getType();
                }

                @Override
                public boolean onCreate(ModelNodeInternal node) {
                    DefaultModelRegistry.this.bind(ModelReference.of(node.getPath(), action.getSubject().getType()), type, action, ModelPath.ROOT);
                    return false;
                }
            });
        }

        @Override
        public <T> void applyToAllLinksTransitive(final ModelActionRole type, final ModelAction<T> action) {
            if (action.getSubject().getPath() != null) {
                throw new IllegalArgumentException("Linked element action reference must have null path.");
            }
            DefaultModelRegistry.this.registerListener(new ModelCreationListener(){

                @Override
                @Nullable
                public ModelPath getAncestor() {
                    return ModelElementNode.this.getPath();
                }

                @Override
                @Nullable
                public ModelType<?> getType() {
                    return action.getSubject().getType();
                }

                @Override
                public boolean onCreate(ModelNodeInternal node) {
                    DefaultModelRegistry.this.bind(ModelReference.of(node.getPath(), action.getSubject().getType()), type, action, ModelPath.ROOT);
                    return false;
                }
            });
        }

        @Override
        public void addReference(ModelCreator creator) {
            if (!this.getPath().isDirectChild(creator.getPath())) {
                throw new IllegalArgumentException(String.format("Reference element creator has a path (%s) which is not a child of this node (%s).", creator.getPath(), this.getPath()));
            }
            DefaultModelRegistry.this.registerNode(this, new ModelReferenceNode(DefaultModelRegistry.this.toCreatorBinder(creator, ModelPath.ROOT)));
        }

        @Override
        public void addLink(ModelCreator creator) {
            if (!this.getPath().isDirectChild(creator.getPath())) {
                throw new IllegalArgumentException(String.format("Linked element creator has a path (%s) which is not a child of this node (%s).", creator.getPath(), this.getPath()));
            }
            DefaultModelRegistry.this.registerNode(this, new ModelElementNode(DefaultModelRegistry.this.toCreatorBinder(creator, ModelPath.ROOT), this));
        }

        @Override
        public void removeLink(String name) {
            if (this.links.remove(name) != null) {
                DefaultModelRegistry.this.remove(this.getPath().child(name));
            }
        }

        @Override
        public ModelNodeInternal getTarget() {
            return this;
        }

        @Override
        public void setTarget(ModelNode target) {
            throw new UnsupportedOperationException(String.format("This node (%s) is not a reference to another node.", this.getPath()));
        }

        @Override
        public void ensureUsable() {
            DefaultModelRegistry.this.transition(this, ModelNode.State.Initialized, true);
        }

        @Override
        public void realize() {
            DefaultModelRegistry.this.close(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModelReferenceNode
    extends ModelNodeInternal {
        private ModelNodeInternal target;

        public ModelReferenceNode(CreatorRuleBinder creatorBinder) {
            super(creatorBinder);
        }

        @Override
        public ModelNodeInternal getTarget() {
            return this.target;
        }

        @Override
        public void setTarget(ModelNode target) {
            this.target = (ModelNodeInternal)target;
        }

        @Override
        public ModelNodeInternal addLink(ModelNodeInternal node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addLink(ModelCreator creator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addReference(ModelCreator creator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeLink(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> void applyToSelf(ModelActionRole type, ModelAction<T> action) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> void applyToAllLinks(ModelActionRole type, ModelAction<T> action) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> void applyToAllLinksTransitive(ModelActionRole type, ModelAction<T> action) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> void applyToLink(ModelActionRole type, ModelAction<T> action) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void applyToLink(String name, Class<? extends RuleSource> rules) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void applyToLinks(ModelType<?> type, Class<? extends RuleSource> rules) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void applyToAllLinksTransitive(ModelType<?> type, Class<? extends RuleSource> rules) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void applyToSelf(Class<? extends RuleSource> rules) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLinkCount(ModelType<?> type) {
            return 0;
        }

        @Override
        public Set<String> getLinkNames(ModelType<?> type) {
            return Collections.emptySet();
        }

        @Override
        @Nullable
        public MutableModelNode getLink(String name) {
            return null;
        }

        @Override
        public Iterable<? extends ModelNodeInternal> getLinks() {
            return Collections.emptySet();
        }

        @Override
        public Iterable<? extends MutableModelNode> getLinks(ModelType<?> type) {
            return Collections.emptySet();
        }

        @Override
        public int getLinkCount() {
            return 0;
        }

        @Override
        public boolean hasLink(String name, ModelType<?> type) {
            return false;
        }

        @Override
        public boolean hasLink(String name) {
            return false;
        }

        @Override
        public <T> T getPrivateData(ModelType<T> type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> void setPrivateData(Class<? super T> type, T object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> void setPrivateData(ModelType<? super T> type, T object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getPrivateData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T getPrivateData(Class<T> type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void ensureUsable() {
        }

        @Override
        public void realize() {
        }

        @Override
        public MutableModelNode getParent() {
            return null;
        }
    }
}

