/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.collect.Lists;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.gradle.api.Action;
import org.gradle.api.Nullable;
import org.gradle.internal.Actions;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class ModelSchemaExtractionContext<T> {
    private final ModelSchemaExtractionContext<?> parent;
    private final ModelType<T> type;
    private final String description;
    private final List<Action<? super ModelSchemaExtractionContext<T>>> validators;

    private ModelSchemaExtractionContext(ModelSchemaExtractionContext<?> parent, ModelType<T> type, String description, Action<? super ModelSchemaExtractionContext<T>> validator) {
        this.parent = parent;
        this.type = type;
        this.description = description;
        this.validators = Lists.newArrayListWithCapacity((int)2);
        this.validators.add(validator);
    }

    public static <T> ModelSchemaExtractionContext<T> root(ModelType<T> type) {
        return new ModelSchemaExtractionContext<T>(null, type, null, Actions.doNothing());
    }

    public static <T> ModelSchemaExtractionContext<T> root(ModelType<T> type, Action<? super ModelSchemaExtractionContext<T>> validator) {
        return new ModelSchemaExtractionContext<T>(null, type, null, validator);
    }

    @Nullable
    public ModelSchemaExtractionContext<?> getParent() {
        return this.parent;
    }

    public ModelType<T> getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description == null ? this.type.toString() : String.format("%s (%s)", this.description, this.type);
    }

    public <C> ModelSchemaExtractionContext<C> child(ModelType<C> type, String description) {
        return this.child(type, description, Actions.doNothing());
    }

    public <C> ModelSchemaExtractionContext<C> child(ModelType<C> type, String description, Action<? super ModelSchemaExtractionContext<C>> validator) {
        return new ModelSchemaExtractionContext<C>(this, type, description, validator);
    }

    public void validate() {
        for (Action<? super ModelSchemaExtractionContext<T>> action : this.validators) {
            action.execute((Object)this);
        }
    }

    public void addValidator(Action<? super ModelSchemaExtractionContext<T>> validator) {
        this.validators.add(validator);
    }
}

