/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import net.jcip.annotations.ThreadSafe;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.Model;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.inspect.AbstractAnnotationDrivenModelRuleExtractor;
import org.gradle.model.internal.inspect.MethodRuleDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class AbstractModelCreationRuleExtractor
extends AbstractAnnotationDrivenModelRuleExtractor<Model> {
    protected String determineModelName(MethodRuleDefinition<?, ?> ruleDefinition) {
        String annotationValue = ruleDefinition.getAnnotation(Model.class).value();
        String modelName = annotationValue == null || annotationValue.isEmpty() ? ruleDefinition.getMethodName() : annotationValue;
        try {
            ModelPath.validatePath(modelName);
        }
        catch (Exception e) {
            throw new InvalidModelRuleDeclarationException(String.format("Path of declared model element created by rule %s is invalid.", ruleDefinition.getDescriptor()), (Throwable)e);
        }
        return modelName;
    }
}

