/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core.rule.describe;

import java.io.IOException;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.UncheckedIOException;
import org.gradle.model.internal.core.rule.describe.AbstractModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;

@ThreadSafe
public class NestedModelRuleDescriptor
extends AbstractModelRuleDescriptor {
    private final ModelRuleDescriptor parent;
    private final ModelRuleDescriptor child;

    public NestedModelRuleDescriptor(ModelRuleDescriptor parent, ModelRuleDescriptor child) {
        this.parent = parent;
        this.child = child;
    }

    public NestedModelRuleDescriptor(ModelRuleDescriptor parent, String child) {
        this(parent, new SimpleModelRuleDescriptor(child));
    }

    public void describeTo(Appendable appendable) {
        this.parent.describeTo(appendable);
        try {
            appendable.append(" > ");
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        this.child.describeTo(appendable);
    }

    public static ModelRuleDescriptor append(ModelRuleDescriptor parent, String str) {
        return new NestedModelRuleDescriptor(parent, new SimpleModelRuleDescriptor(str));
    }

    public static ModelRuleDescriptor append(ModelRuleDescriptor parent, String str, Object ... args) {
        return NestedModelRuleDescriptor.append(parent, String.format(str, args));
    }
}

