/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.google.common.base.Predicate;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.ui.UIUtil;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.ui.TerminalSession;
import com.jediterm.terminal.ui.TerminalWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.JBTabbedTerminalWidget;
import org.jetbrains.plugins.terminal.JBTerminalSystemSettingsProvider;
import org.jetbrains.plugins.terminal.TerminalView;

public abstract class AbstractTerminalRunner<T extends Process> {
    private static final Logger LOG = Logger.getInstance((String)AbstractTerminalRunner.class.getName());
    @NotNull
    protected final Project myProject;

    public AbstractTerminalRunner(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/terminal/AbstractTerminalRunner", "<init>"));
        }
        this.myProject = project;
    }

    public void run() {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Running the terminal", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/terminal/AbstractTerminalRunner$1", "run"));
                }
                indicator.setText("Running the terminal...");
                try {
                    AbstractTerminalRunner.this.doRun();
                }
                catch (Exception e) {
                    LOG.warn("Error running terminal", (Throwable)e);
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Messages.showErrorDialog((Project)AbstractTerminalRunner.this.getProject(), (String)e.getMessage(), (String)this.getTitle());
                        }
                    });
                }
            }
        });
    }

    private void doRun() {
        try {
            T process = this.createProcess(null);
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable((Process)process){
                final /* synthetic */ Process val$process;
                {
                    this.val$process = process;
                }

                @Override
                public void run() {
                    AbstractTerminalRunner.this.initConsoleUI(this.val$process);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected abstract T createProcess(@Nullable String var1) throws ExecutionException;

    protected abstract ProcessHandler createProcessHandler(T var1);

    @NotNull
    public JBTabbedTerminalWidget createTerminalWidget(@NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/plugins/terminal/AbstractTerminalRunner", "createTerminalWidget"));
        }
        JBTerminalSystemSettingsProvider provider = new JBTerminalSystemSettingsProvider();
        JBTabbedTerminalWidget terminalWidget = new JBTabbedTerminalWidget(this.myProject, provider, new Predicate<Pair<TerminalWidget, String>>(){

            public boolean apply(Pair<TerminalWidget, String> widget) {
                AbstractTerminalRunner.this.openSessionInDirectory((TerminalWidget)widget.getFirst(), (String)widget.getSecond());
                return true;
            }
        }, parent);
        this.openSessionInDirectory((TerminalWidget)terminalWidget, null);
        JBTabbedTerminalWidget jBTabbedTerminalWidget = terminalWidget;
        if (jBTabbedTerminalWidget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/terminal/AbstractTerminalRunner", "createTerminalWidget"));
        }
        return jBTabbedTerminalWidget;
    }

    private void initConsoleUI(T process) {
        Executor defaultExecutor = DefaultRunExecutor.getRunExecutorInstance();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)toolbarActions, false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)actionToolbar.getComponent(), "West");
        actionToolbar.setTargetComponent((JComponent)panel);
        ProcessHandler processHandler = this.createProcessHandler(process);
        RunContentDescriptor contentDescriptor = new RunContentDescriptor(null, processHandler, (JComponent)panel, this.getTerminalConnectionName(process));
        contentDescriptor.setAutoFocusContent(true);
        toolbarActions.add(this.createCloseAction(defaultExecutor, contentDescriptor));
        JBTerminalSystemSettingsProvider provider = new JBTerminalSystemSettingsProvider();
        JBTabbedTerminalWidget widget = new JBTabbedTerminalWidget(this.myProject, provider, new Predicate<Pair<TerminalWidget, String>>(){

            public boolean apply(Pair<TerminalWidget, String> widget) {
                AbstractTerminalRunner.this.openSessionInDirectory((TerminalWidget)widget.getFirst(), (String)widget.getSecond());
                return true;
            }
        }, (Disposable)contentDescriptor);
        AbstractTerminalRunner.createAndStartSession((TerminalWidget)widget, this.createTtyConnector(process));
        panel.add((Component)widget.getComponent(), "Center");
        this.showConsole(defaultExecutor, contentDescriptor, widget.getComponent());
        processHandler.startNotify();
    }

    public void openSession(@NotNull TerminalWidget terminal) {
        if (terminal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "terminal", "org/jetbrains/plugins/terminal/AbstractTerminalRunner", "openSession"));
        }
        this.openSessionInDirectory(terminal, null);
    }

    public static void createAndStartSession(@NotNull TerminalWidget terminal, @NotNull TtyConnector ttyConnector) {
        if (terminal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "terminal", "org/jetbrains/plugins/terminal/AbstractTerminalRunner", "createAndStartSession"));
        }
        if (ttyConnector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ttyConnector", "org/jetbrains/plugins/terminal/AbstractTerminalRunner", "createAndStartSession"));
        }
        TerminalSession session = terminal.createTerminalSession(ttyConnector);
        TerminalView.recordUsage(ttyConnector);
        session.start();
    }

    protected abstract String getTerminalConnectionName(T var1);

    protected abstract TtyConnector createTtyConnector(T var1);

    protected AnAction createCloseAction(Executor defaultExecutor, RunContentDescriptor myDescriptor) {
        return new CloseAction(defaultExecutor, myDescriptor, this.myProject);
    }

    protected void showConsole(Executor defaultExecutor, @NotNull RunContentDescriptor myDescriptor, final Component toFocus) {
        if (myDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myDescriptor", "org/jetbrains/plugins/terminal/AbstractTerminalRunner", "showConsole"));
        }
        ExecutionManager.getInstance((Project)this.myProject).getContentManager().showRunContent(defaultExecutor, myDescriptor);
        ToolWindow window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(defaultExecutor.getId());
        window.activate(new Runnable(){

            @Override
            public void run() {
                IdeFocusManager.getInstance((Project)AbstractTerminalRunner.this.myProject).requestFocus(toFocus, true);
            }
        });
    }

    @NotNull
    protected Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/terminal/AbstractTerminalRunner", "getProject"));
        }
        return project;
    }

    public abstract String runningTargetName();

    public void openSessionInDirectory(@NotNull TerminalWidget terminalWidget, @Nullable String directory) {
        if (terminalWidget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "terminalWidget", "org/jetbrains/plugins/terminal/AbstractTerminalRunner", "openSessionInDirectory"));
        }
        try {
            T process = this.createProcess(directory);
            AbstractTerminalRunner.createAndStartSession(terminalWidget, this.createTtyConnector(process));
        }
        catch (Exception e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)("Can't Open " + this.runningTargetName()));
        }
    }
}

