/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.ndk.internal;

import com.android.build.gradle.internal.NdkHandler;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.Toolchain;
import com.android.build.gradle.managed.NdkAbiOptions;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.model.ModelMap;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.toolchain.Clang;
import org.gradle.nativeplatform.toolchain.Gcc;
import org.gradle.nativeplatform.toolchain.GccCompatibleToolChain;
import org.gradle.nativeplatform.toolchain.GccPlatformToolChain;
import org.gradle.nativeplatform.toolchain.NativeToolChainRegistry;
import org.gradle.platform.base.PlatformContainer;

public class ToolchainConfiguration {
    public static void configurePlatforms(PlatformContainer platforms, NdkHandler ndkHandler) {
        for (Abi abi : ndkHandler.getSupportedAbis()) {
            NativePlatform platform = (NativePlatform)platforms.maybeCreate(abi.getName(), NativePlatform.class);
            platform.architecture("ppc");
            platform.operatingSystem("linux");
        }
    }

    public static void configureToolchain(NativeToolChainRegistry toolchainRegistry, String toolchainName, final ModelMap<NdkAbiOptions> abiConfigs, final NdkHandler ndkHandler) {
        final Toolchain ndkToolchain = Toolchain.getByName((String)toolchainName);
        toolchainRegistry.create("ndk-" + toolchainName, toolchainName.equals("gcc") ? Gcc.class : Clang.class, (Action)new Action<GccCompatibleToolChain>(){

            public void execute(GccCompatibleToolChain toolchain) {
                for (final Abi abi : ndkHandler.getSupportedAbis()) {
                    toolchain.target(abi.getName(), (Action)new Action<GccPlatformToolChain>(){

                        public void execute(GccPlatformToolChain targetPlatform) {
                            if (Toolchain.GCC.equals((Object)ndkToolchain)) {
                                String gccPrefix = abi.getGccExecutablePrefix();
                                targetPlatform.getcCompiler().setExecutable(gccPrefix + "-gcc");
                                targetPlatform.getCppCompiler().setExecutable(gccPrefix + "-g++");
                                targetPlatform.getLinker().setExecutable(gccPrefix + "-g++");
                                targetPlatform.getAssembler().setExecutable(gccPrefix + "-as");
                                targetPlatform.getStaticLibArchiver().setExecutable(gccPrefix + "-ar");
                            }
                            targetPlatform.getLinker().withArguments((Action)new Action<List<String>>(){

                                public void execute(List<String> args) {
                                    args.removeAll(Collections.singleton("-Xlinker"));
                                }
                            });
                            final NdkAbiOptions config = (NdkAbiOptions)abiConfigs.get(abi.getName());
                            if (config != null) {
                                targetPlatform.getcCompiler().withArguments((Action)new Action<List<String>>(){

                                    public void execute(List<String> args) {
                                        for (String flag : config.getCFlags()) {
                                            args.add(flag);
                                        }
                                    }
                                });
                                targetPlatform.getCppCompiler().withArguments((Action)new Action<List<String>>(){

                                    public void execute(List<String> args) {
                                        for (String flag : config.getCppFlags()) {
                                            args.add(flag);
                                        }
                                    }
                                });
                                targetPlatform.getLinker().withArguments((Action)new Action<List<String>>(){

                                    public void execute(List<String> args) {
                                        for (String flag : config.getLdFlags()) {
                                            args.add(flag);
                                        }
                                        for (String lib : config.getLdLibs()) {
                                            args.add("-l" + lib);
                                        }
                                    }
                                });
                            }
                        }
                    });
                    toolchain.path(new Object[]{ndkHandler.getCCompiler(abi).getParentFile()});
                }
            }
        });
    }
}

