/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.managed.adaptor;

import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreJackOptions;
import com.android.build.gradle.internal.dsl.CoreNdkOptions;
import com.android.build.gradle.internal.dsl.CoreShaderOptions;
import com.android.build.gradle.managed.BuildType;
import com.android.build.gradle.managed.adaptor.BaseConfigAdaptor;
import com.android.build.gradle.managed.adaptor.JackOptionsAdaptor;
import com.android.build.gradle.managed.adaptor.NdkOptionsAdaptor;
import com.android.build.gradle.managed.adaptor.ShaderOptionsAdaptor;
import com.android.build.gradle.managed.adaptor.SigningConfigAdaptor;
import com.android.builder.model.SigningConfig;
import com.google.common.base.Objects;

public class BuildTypeAdaptor
extends BaseConfigAdaptor
implements CoreBuildType {
    private final BuildType buildType;

    public BuildTypeAdaptor(BuildType buildType) {
        super(buildType);
        this.buildType = buildType;
    }

    public boolean isDebuggable() {
        return this.buildType.getDebuggable();
    }

    public boolean isTestCoverageEnabled() {
        return this.buildType.getTestCoverageEnabled();
    }

    public boolean isJniDebuggable() {
        return (Boolean)Objects.firstNonNull((Object)this.buildType.getNdk().getDebuggable(), (Object)false);
    }

    public boolean isPseudoLocalesEnabled() {
        return this.buildType.getPseudoLocalesEnabled();
    }

    public boolean isRenderscriptDebuggable() {
        return this.buildType.getRenderscriptDebuggable();
    }

    public int getRenderscriptOptimLevel() {
        return this.buildType.getRenderscriptOptimLevel();
    }

    public String getVersionNameSuffix() {
        return this.buildType.getVersionNameSuffix();
    }

    public boolean isMinifyEnabled() {
        return this.buildType.getMinifyEnabled();
    }

    public boolean isZipAlignEnabled() {
        return this.buildType.getZipAlignEnabled();
    }

    public boolean isEmbedMicroApp() {
        return this.buildType.getEmbedMicroApp();
    }

    public SigningConfig getSigningConfig() {
        return this.buildType.getSigningConfig() == null ? null : new SigningConfigAdaptor(this.buildType.getSigningConfig());
    }

    public CoreNdkOptions getNdkConfig() {
        return new NdkOptionsAdaptor(this.buildType.getNdk());
    }

    public CoreJackOptions getJackOptions() {
        return new JackOptionsAdaptor(this.buildType.getJackOptions());
    }

    public CoreShaderOptions getShaders() {
        return new ShaderOptionsAdaptor(this.buildType.getShaders());
    }

    public boolean isShrinkResources() {
        return this.buildType.getShrinkResources();
    }

    public boolean isUseProguard() {
        return this.buildType.getUseProguard();
    }
}

