/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.shrinker;

import com.android.builder.shrinker.DependencyType;
import com.android.builder.shrinker.Shrinker;
import com.android.builder.shrinker.ShrinkerGraph;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public abstract class DependencyFinderVisitor<T>
extends ClassVisitor {
    private final ShrinkerGraph<T> mGraph;
    private final Set<T> mVirtualMethods;
    private final Set<T> mMultipleInheritance;
    private final Set<Shrinker.UnresolvedReference<T>> mUnresolvedReferences;
    private String mClassName;
    private boolean mIsAnnotation;
    private T mKlass;

    public DependencyFinderVisitor(ShrinkerGraph<T> graph, ClassVisitor cv, Set<T> virtualMethods, Set<Shrinker.UnresolvedReference<T>> unresolvedReferences, Set<T> multipleInheritance) {
        super(327680, cv);
        this.mGraph = graph;
        this.mVirtualMethods = virtualMethods;
        this.mUnresolvedReferences = unresolvedReferences;
        this.mMultipleInheritance = multipleInheritance;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (interfaces == null) {
            interfaces = new String[]{};
        }
        this.mKlass = this.mGraph.getClassReference(name);
        if (!superName.equals("java/lang/Object")) {
            this.handleDependency(this.mKlass, this.mGraph.getClassReference(superName), DependencyType.REQUIRED);
        }
        if (interfaces.length > 0 && !this.mGraph.isLibraryClass(this.mGraph.getClassReference(superName))) {
            this.mMultipleInheritance.add(this.mKlass);
        }
        this.mClassName = name;
        boolean bl = this.mIsAnnotation = (access & 0x2000) != 0;
        if (signature != null) {
            this.handleClassSignature(this.mKlass, signature);
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        T method = this.mGraph.getMemberReference(this.mClassName, name, desc);
        if ((access & 8) == 0 && !name.equals("<init>") && this.mVirtualMethods != null) {
            this.mVirtualMethods.add(method);
        }
        Type methodType = Type.getMethodType((String)desc);
        this.handleDeclarationType(method, methodType.getReturnType());
        for (Type argType : methodType.getArgumentTypes()) {
            this.handleDeclarationType(method, argType);
        }
        if (name.equals("<clinit>")) {
            this.handleDependency(this.mKlass, method, DependencyType.REQUIRED);
        }
        if (this.mIsAnnotation) {
            this.handleDependency(this.mKlass, method, DependencyType.REQUIRED);
        }
        if (signature != null) {
            this.handleClassSignature(method, signature);
        }
        return new DependencyFinderMethodVisitor(method, super.visitMethod(access, name, desc, signature, exceptions));
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        T field = this.mGraph.getMemberReference(this.mClassName, name, desc);
        Type fieldType = Type.getType((String)desc);
        this.handleDeclarationType(field, fieldType);
        if (signature != null) {
            SignatureReader reader = new SignatureReader(signature);
            DependencyFinderSignatureVisitor visitor = new DependencyFinderSignatureVisitor(field);
            reader.acceptType((SignatureVisitor)visitor);
        }
        return super.visitField(access, name, desc, signature, value);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (!visible) {
            return super.visitAnnotation(desc, false);
        }
        Type type = Type.getType((String)desc);
        this.handleDeclarationType(this.mKlass, type);
        return new DependencyFinderAnnotationVisitor(type.getInternalName(), this.mKlass, super.visitAnnotation(desc, true));
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (this.mClassName.equals(name) && outerName != null) {
            this.handleDependency(this.mKlass, this.mGraph.getClassReference(outerName), DependencyType.REQUIRED);
        }
        super.visitInnerClass(name, outerName, innerName, access);
    }

    private T handleDeclarationType(T member, Type type) {
        String className = DependencyFinderVisitor.getClassName(type);
        if (className != null) {
            T classReference = this.mGraph.getClassReference(className);
            this.handleDependency(member, classReference, DependencyType.REQUIRED);
            return classReference;
        }
        return null;
    }

    private void handleClassSignature(T source, String signature) {
        SignatureReader reader = new SignatureReader(signature);
        DependencyFinderSignatureVisitor visitor = new DependencyFinderSignatureVisitor(source);
        reader.accept((SignatureVisitor)visitor);
    }

    private static String getClassName(String desc) {
        return DependencyFinderVisitor.getClassName(Type.getType((String)desc));
    }

    private static String getClassName(Type type) {
        switch (type.getSort()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                return null;
            }
            case 9: {
                return DependencyFinderVisitor.getClassName(type.getElementType());
            }
            case 10: {
                return type.getInternalName();
            }
        }
        throw new IllegalStateException();
    }

    protected abstract void handleDependency(T var1, T var2, DependencyType var3);

    private class DependencyFinderSignatureVisitor
    extends SignatureVisitor {
        private final T mSource;

        public DependencyFinderSignatureVisitor(T source) {
            super(327680);
            this.mSource = source;
        }

        public void visitClassType(String name) {
            if (!name.equals("java/lang/Object")) {
                DependencyFinderVisitor.this.handleDependency(this.mSource, DependencyFinderVisitor.this.mGraph.getClassReference(name), DependencyType.REQUIRED);
            }
            super.visitClassType(name);
        }

        public void visitInnerClassType(String name) {
            super.visitInnerClassType(name);
        }
    }

    private class DependencyFinderAnnotationVisitor
    extends AnnotationVisitor {
        private final String mAnnotationName;
        private final T mSource;

        public DependencyFinderAnnotationVisitor(String annotationName, T source, AnnotationVisitor av) {
            super(327680, av);
            this.mAnnotationName = annotationName;
            this.mSource = source;
        }

        public void visit(String name, Object value) {
            if (value instanceof Type) {
                DependencyFinderVisitor.this.handleDeclarationType(this.mSource, (Type)value);
            }
            super.visit(name, value);
        }

        public void visitEnum(String name, String desc, String value) {
            String internalName = DependencyFinderVisitor.getClassName(desc);
            DependencyFinderVisitor.this.handleDependency(this.mSource, DependencyFinderVisitor.this.mGraph.getClassReference(internalName), DependencyType.REQUIRED);
            DependencyFinderVisitor.this.handleDependency(this.mSource, DependencyFinderVisitor.this.mGraph.getMemberReference(internalName, value, desc), DependencyType.REQUIRED);
            super.visitEnum(name, desc, value);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            String internalName = DependencyFinderVisitor.getClassName(desc);
            DependencyFinderVisitor.this.handleDependency(this.mSource, DependencyFinderVisitor.this.mGraph.getClassReference(internalName), DependencyType.REQUIRED);
            return new DependencyFinderAnnotationVisitor(this.mAnnotationName, this.mSource, super.visitAnnotation(name, desc));
        }

        public AnnotationVisitor visitArray(String name) {
            return new DependencyFinderAnnotationVisitor(this.mAnnotationName, this.mSource, super.visitArray(name));
        }
    }

    private class DependencyFinderMethodVisitor
    extends MethodVisitor {
        private final T mMethod;

        public DependencyFinderMethodVisitor(T method, MethodVisitor mv) {
            super(327680, mv);
            this.mMethod = method;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (!visible) {
                return super.visitAnnotation(desc, false);
            }
            Type type = Type.getType((String)desc);
            DependencyFinderVisitor.this.handleDeclarationType(this.mMethod, type);
            return new DependencyFinderAnnotationVisitor(type.getInternalName(), this.mMethod, super.visitAnnotation(desc, true));
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return new DependencyFinderAnnotationVisitor(null, this.mMethod, super.visitAnnotationDefault());
        }

        public void visitTypeInsn(int opcode, String type) {
            Object classReference = DependencyFinderVisitor.this.mGraph.getClassReference(DependencyFinderVisitor.getClassName(Type.getObjectType((String)type)));
            if (classReference != null) {
                DependencyFinderVisitor.this.handleDependency(this.mMethod, classReference, DependencyType.REQUIRED);
            }
            super.visitTypeInsn(opcode, type);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            DependencyFinderVisitor.this.handleDependency(this.mMethod, DependencyFinderVisitor.this.mGraph.getClassReference(owner), DependencyType.REQUIRED);
            Object target = DependencyFinderVisitor.this.mGraph.getMemberReference(owner, name, desc);
            DependencyFinderVisitor.this.mUnresolvedReferences.add(new Shrinker.UnresolvedReference(this.mMethod, target, opcode));
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        public void visitLdcInsn(Object cst) {
            if (cst instanceof Type) {
                Type type = Type.getObjectType((String)((Type)cst).getInternalName());
                Object classReference = DependencyFinderVisitor.this.mGraph.getClassReference(DependencyFinderVisitor.getClassName(type));
                if (classReference != null) {
                    DependencyFinderVisitor.this.handleDependency(this.mMethod, classReference, DependencyType.REQUIRED);
                }
            }
            super.visitLdcInsn(cst);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            Type type = Type.getType((String)owner);
            if (!(type.getSort() == 9 || owner.startsWith("java/") || owner.startsWith("android/os/") || owner.startsWith("android/view/") || owner.startsWith("android/content/") || owner.startsWith("android/graphics/") || owner.startsWith("android/widget/"))) {
                DependencyFinderVisitor.this.handleDependency(this.mMethod, DependencyFinderVisitor.this.mGraph.getClassReference(owner), DependencyType.REQUIRED);
                Object target = DependencyFinderVisitor.this.mGraph.getMemberReference(owner, name, desc);
                if (opcode == 183 && (name.equals("<init>") || owner.equals(DependencyFinderVisitor.this.mClassName))) {
                    DependencyFinderVisitor.this.handleDependency(this.mMethod, target, DependencyType.REQUIRED);
                } else {
                    DependencyFinderVisitor.this.mUnresolvedReferences.add(new Shrinker.UnresolvedReference(this.mMethod, target, opcode));
                }
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            String className = DependencyFinderVisitor.getClassName(desc);
            if (className != null) {
                DependencyFinderVisitor.this.handleDependency(this.mMethod, DependencyFinderVisitor.this.mGraph.getClassReference(className), DependencyType.REQUIRED);
            }
            super.visitMultiANewArrayInsn(desc, dims);
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            if (type != null) {
                DependencyFinderVisitor.this.handleDependency(this.mMethod, DependencyFinderVisitor.this.mGraph.getClassReference(type), DependencyType.REQUIRED);
            }
            super.visitTryCatchBlock(start, end, handler, type);
        }
    }
}

