/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValue;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValueI;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SoftHashMap;
import com.intellij.util.messages.Topic;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.dialogs.WCInfoWithBranches;
import org.jetbrains.idea.svn.history.CopyData;
import org.jetbrains.idea.svn.history.FirstInBranch;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.mergeinfo.BranchInfo;
import org.jetbrains.idea.svn.mergeinfo.MergeInfoCached;

public class SvnMergeInfoCache {
    private static final Logger LOG = Logger.getInstance(SvnMergeInfoCache.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<String, MyCurrentUrlData> myCurrentUrlMapping;
    public static Topic<SvnMergeInfoCacheListener> SVN_MERGE_INFO_CACHE = new Topic("SVN_MERGE_INFO_CACHE", SvnMergeInfoCacheListener.class);

    private SvnMergeInfoCache(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/mergeinfo/SvnMergeInfoCache", "<init>"));
        }
        this.myProject = project;
        this.myCurrentUrlMapping = ContainerUtil.newHashMap();
    }

    public static SvnMergeInfoCache getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/mergeinfo/SvnMergeInfoCache", "getInstance"));
        }
        return (SvnMergeInfoCache)PeriodicalTasksCloser.getInstance().safeGetService(project, SvnMergeInfoCache.class);
    }

    public void clear(@NotNull WCInfoWithBranches info, String branchPath) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/mergeinfo/SvnMergeInfoCache", "clear"));
        }
        BranchInfo branchInfo = this.getBranchInfo(info, branchPath);
        if (branchInfo != null) {
            branchInfo.clear();
        }
    }

    @Nullable
    public MergeInfoCached getCachedState(@NotNull WCInfoWithBranches info, String branchPath) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/mergeinfo/SvnMergeInfoCache", "getCachedState"));
        }
        BranchInfo branchInfo = this.getBranchInfo(info, branchPath);
        return branchInfo != null ? branchInfo.getCached() : null;
    }

    public MergeCheckResult getState(@NotNull WCInfoWithBranches info, @NotNull SvnChangeList list, @NotNull WCInfoWithBranches.Branch selectedBranch, String branchPath) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/mergeinfo/SvnMergeInfoCache", "getState"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/idea/svn/mergeinfo/SvnMergeInfoCache", "getState"));
        }
        if (selectedBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedBranch", "org/jetbrains/idea/svn/mergeinfo/SvnMergeInfoCache", "getState"));
        }
        MyCurrentUrlData rootMapping = this.myCurrentUrlMapping.get(info.getRootUrl());
        BranchInfo mergeChecker = null;
        if (rootMapping == null) {
            rootMapping = new MyCurrentUrlData();
            this.myCurrentUrlMapping.put(info.getRootUrl(), rootMapping);
        } else {
            mergeChecker = rootMapping.getBranchInfo(branchPath);
        }
        if (mergeChecker == null) {
            mergeChecker = new BranchInfo(SvnVcs.getInstance(this.myProject), info, selectedBranch);
            rootMapping.addBranchInfo(branchPath, mergeChecker);
        }
        return mergeChecker.checkList(list, branchPath);
    }

    public boolean isMixedRevisions(@NotNull WCInfoWithBranches info, String branchPath) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/mergeinfo/SvnMergeInfoCache", "isMixedRevisions"));
        }
        BranchInfo branchInfo = this.getBranchInfo(info, branchPath);
        return branchInfo != null && branchInfo.isMixedRevisionsFound();
    }

    @Nullable
    private BranchInfo getBranchInfo(@NotNull WCInfoWithBranches info, String branchPath) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/mergeinfo/SvnMergeInfoCache", "getBranchInfo"));
        }
        MyCurrentUrlData rootMapping = this.myCurrentUrlMapping.get(info.getRootUrl());
        return rootMapping != null ? rootMapping.getBranchInfo(branchPath) : null;
    }

    public static interface SvnMergeInfoCacheListener {
        public void copyRevisionUpdated();
    }

    private static class MyCurrentUrlData {
        @NotNull
        private final Map<String, BranchInfo> myBranchInfo = new SoftHashMap();

        private MyCurrentUrlData() {
        }

        public BranchInfo getBranchInfo(String branchUrl) {
            return this.myBranchInfo.get(branchUrl);
        }

        public void addBranchInfo(@NotNull String branchUrl, @NotNull BranchInfo mergeChecker) {
            if (branchUrl == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchUrl", "org/jetbrains/idea/svn/mergeinfo/SvnMergeInfoCache$MyCurrentUrlData", "addBranchInfo"));
            }
            if (mergeChecker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeChecker", "org/jetbrains/idea/svn/mergeinfo/SvnMergeInfoCache$MyCurrentUrlData", "addBranchInfo"));
            }
            this.myBranchInfo.put(branchUrl, mergeChecker);
        }
    }

    static class CopyRevison {
        private final String myPath;
        private volatile long myRevision;

        CopyRevison(final SvnVcs vcs, String path, String repositoryRoot, String branchUrl, String trunkUrl) {
            this.myPath = path;
            this.myRevision = -1L;
            TransparentlyFailedValue<CopyData, VcsException> result = new TransparentlyFailedValue<CopyData, VcsException>(){

                public void set(CopyData copyData) {
                    if (copyData == null) {
                        return;
                    }
                    CopyRevison.this.myRevision = copyData.getCopySourceRevision();
                    if (CopyRevison.this.myRevision != -1L) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (vcs.getProject().isDisposed()) {
                                    return;
                                }
                                ((SvnMergeInfoCacheListener)vcs.getProject().getMessageBus().syncPublisher(SVN_MERGE_INFO_CACHE)).copyRevisionUpdated();
                            }
                        });
                    }
                }

                public void fail(VcsException e) {
                    LOG.info((Throwable)e);
                    VcsBalloonProblemNotifier.showOverChangesView((Project)vcs.getProject(), (String)e.getMessage(), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
                }

                public void failRuntime(RuntimeException e) {
                    LOG.info((Throwable)e);
                    VcsBalloonProblemNotifier.showOverChangesView((Project)vcs.getProject(), (String)e.getMessage(), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
                }
            };
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)new FirstInBranch(vcs, repositoryRoot, branchUrl, trunkUrl, (TransparentlyFailedValueI<CopyData, VcsException>)result));
        }

        public String getPath() {
            return this.myPath;
        }

        public long getRevision() {
            return this.myRevision;
        }
    }

    public static enum MergeCheckResult {
        COMMON,
        MERGED,
        NOT_MERGED,
        NOT_EXISTS;


        @NotNull
        public static MergeCheckResult getInstance(boolean merged) {
            MergeCheckResult mergeCheckResult = merged ? MERGED : NOT_MERGED;
            if (mergeCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/SvnMergeInfoCache$MergeCheckResult", "getInstance"));
            }
            return mergeCheckResult;
        }
    }
}

