/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browserCache;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;
import org.jetbrains.idea.svn.dialogs.browserCache.NodeLoadState;
import org.jetbrains.idea.svn.dialogs.browserCache.SvnRepositoryCache;

public abstract class Loader {
    @NotNull
    protected final SvnRepositoryCache myCache;

    protected Loader(@NotNull SvnRepositoryCache cache) {
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "org/jetbrains/idea/svn/dialogs/browserCache/Loader", "<init>"));
        }
        this.myCache = cache;
    }

    public abstract void load(@NotNull RepositoryTreeNode var1, @NotNull Expander var2);

    @NotNull
    protected abstract NodeLoadState getNodeLoadState();

    protected void refreshNodeError(@NotNull RepositoryTreeNode node, @NotNull String text) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/idea/svn/dialogs/browserCache/Loader", "refreshNodeError"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/idea/svn/dialogs/browserCache/Loader", "refreshNodeError"));
        }
        RepositoryTreeNode existingNode = Loader.findExistingNode(node);
        if (existingNode != null) {
            existingNode.setErrorNode(text);
        }
    }

    protected void refreshNode(@NotNull RepositoryTreeNode node, @NotNull List<DirectoryEntry> data, @NotNull Expander expander) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/idea/svn/dialogs/browserCache/Loader", "refreshNode"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/idea/svn/dialogs/browserCache/Loader", "refreshNode"));
        }
        if (expander == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expander", "org/jetbrains/idea/svn/dialogs/browserCache/Loader", "refreshNode"));
        }
        RepositoryTreeNode existingNode = Loader.findExistingNode(node);
        if (existingNode != null) {
            expander.onBeforeRefresh(existingNode);
            existingNode.setChildren(data, this.getNodeLoadState());
            expander.onAfterRefresh(existingNode);
        }
    }

    @Nullable
    private static RepositoryTreeNode findExistingNode(@NotNull RepositoryTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/idea/svn/dialogs/browserCache/Loader", "findExistingNode"));
        }
        RepositoryTreeNode result = null;
        if (!node.isDisposed()) {
            result = node.getNodeWithSamePathUnderModelRoot();
        }
        return result == null || result.isDisposed() ? null : result;
    }
}

