/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.Version;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.VersionClient;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;

public class CmdVersionClient
extends BaseSvnClient
implements VersionClient {
    private static final Pattern VERSION = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)");
    private static final int COMMAND_TIMEOUT = 30000;

    @Override
    @NotNull
    public Version getVersion() throws SvnBindException {
        Version version = CmdVersionClient.parseVersion(this.runCommand(true));
        if (version == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/CmdVersionClient", "getVersion"));
        }
        return version;
    }

    @NotNull
    public ProcessOutput runCommand(boolean quiet) throws SvnBindException {
        Command command = new Command(SvnCommandName.version);
        if (quiet) {
            command.put("--quiet");
        }
        ProcessOutput processOutput = this.newRuntime(this.myVcs).runLocal(command, 30000).getProcessOutput();
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/CmdVersionClient", "runCommand"));
        }
        return processOutput;
    }

    @NotNull
    private static Version parseVersion(@NotNull ProcessOutput output) throws SvnBindException {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "org/jetbrains/idea/svn/api/CmdVersionClient", "parseVersion"));
        }
        if (output.isTimeout()) {
            throw new SvnBindException(String.format("Exit code: %d, Error: %s", output.getExitCode(), output.getStderr()));
        }
        Version version = CmdVersionClient.parseVersion(output.getStdout());
        if (version == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/CmdVersionClient", "parseVersion"));
        }
        return version;
    }

    @NotNull
    public static Version parseVersion(@NotNull String versionText) throws SvnBindException {
        if (versionText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionText", "org/jetbrains/idea/svn/api/CmdVersionClient", "parseVersion"));
        }
        Version result = null;
        NumberFormatException cause = null;
        Matcher matcher = VERSION.matcher(versionText);
        boolean found = matcher.find();
        if (found) {
            try {
                result = new Version(CmdVersionClient.getInt(matcher.group(1)), CmdVersionClient.getInt(matcher.group(2)), CmdVersionClient.getInt(matcher.group(3)));
            }
            catch (NumberFormatException e) {
                cause = e;
            }
        }
        if (!found || cause != null) {
            throw new SvnBindException(String.format("Could not parse svn version: %s", versionText), cause);
        }
        Version version = result;
        if (version == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/CmdVersionClient", "parseVersion"));
        }
        return version;
    }

    private static int getInt(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/idea/svn/api/CmdVersionClient", "getInt"));
        }
        return Integer.parseInt(value);
    }
}

