/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.annotate;

import com.intellij.openapi.vcs.VcsException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.annotate.AnnotateClient;
import org.jetbrains.idea.svn.annotate.AnnotationConsumer;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.diff.DiffOptions;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdAnnotateClient
extends BaseSvnClient
implements AnnotateClient {
    @Override
    public void annotate(@NotNull SvnTarget target, @NotNull SVNRevision startRevision, @NotNull SVNRevision endRevision, boolean includeMergedRevisions, @Nullable DiffOptions diffOptions, @Nullable AnnotationConsumer handler) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/annotate/CmdAnnotateClient", "annotate"));
        }
        if (startRevision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startRevision", "org/jetbrains/idea/svn/annotate/CmdAnnotateClient", "annotate"));
        }
        if (endRevision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endRevision", "org/jetbrains/idea/svn/annotate/CmdAnnotateClient", "annotate"));
        }
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, target);
        CommandUtil.put(parameters, startRevision, endRevision);
        CommandUtil.put(parameters, includeMergedRevisions, "--use-merge-history");
        CommandUtil.put(parameters, diffOptions);
        parameters.add("--xml");
        CommandExecutor command = this.execute(this.myVcs, target, SvnCommandName.blame, parameters, null);
        this.parseOutput(command.getOutput(), handler);
    }

    public void parseOutput(@NotNull String output, @Nullable AnnotationConsumer handler) throws VcsException {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "org/jetbrains/idea/svn/annotate/CmdAnnotateClient", "parseOutput"));
        }
        try {
            BlameInfo info = CommandUtil.parse(output, BlameInfo.class);
            if (handler != null && info != null && info.target != null && info.target.lineEntries != null) {
                for (LineEntry entry : info.target.lineEntries) {
                    CmdAnnotateClient.invokeHandler(handler, entry);
                }
            }
        }
        catch (JAXBException e) {
            throw new VcsException((Throwable)e);
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private static void invokeHandler(@NotNull AnnotationConsumer handler, @NotNull LineEntry entry) throws SVNException {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "org/jetbrains/idea/svn/annotate/CmdAnnotateClient", "invokeHandler"));
        }
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/idea/svn/annotate/CmdAnnotateClient", "invokeHandler"));
        }
        if (entry.commit != null) {
            handler.consume(entry.lineNumber - 1, entry.commit.build(), entry.mergedCommit());
        }
    }

    public static class MergedEntry {
        @XmlAttribute(name="path")
        public String path;
        public CommitInfo.Builder commit;
    }

    public static class LineEntry {
        @XmlAttribute(name="line-number")
        public int lineNumber;
        public CommitInfo.Builder commit;
        @XmlElement(name="merged")
        public MergedEntry merged;

        @Nullable
        public CommitInfo mergedCommit() {
            return this.merged != null && this.merged.commit != null ? this.merged.commit.build() : null;
        }
    }

    public static class TargetEntry {
        @XmlElement(name="entry")
        List<LineEntry> lineEntries;
    }

    @XmlRootElement(name="blame")
    public static class BlameInfo {
        @XmlElement(name="target")
        public TargetEntry target;
    }
}

