/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;

public class SvnStatusUtil {
    private SvnStatusUtil() {
    }

    public static boolean isUnderControl(Project project, VirtualFile file) {
        ChangeListManager clManager = ChangeListManager.getInstance((Project)project);
        return !SvnStatusUtil.isIgnoredInAnySense(clManager, file) && !clManager.isUnversioned(file);
    }

    public static boolean isAdded(Project project, VirtualFile file) {
        FileStatus status = FileStatusManager.getInstance((Project)project).getStatus(file);
        return FileStatus.ADDED.equals(status);
    }

    public static boolean isExplicitlyLocked(Project project, VirtualFile file) {
        ChangeListManager clManager = ChangeListManager.getInstance((Project)project);
        return ((ChangeListManagerImpl)clManager).isLogicallyLocked(file);
    }

    public static boolean isIgnoredInAnySense(ChangeListManager clManager, VirtualFile file) {
        return clManager.isIgnoredFile(file) || FileStatus.IGNORED.equals(clManager.getStatus(file));
    }

    public static boolean fileCanBeAdded(Project project, VirtualFile file) {
        ChangeListManager clManager = ChangeListManager.getInstance((Project)project);
        return SvnStatusUtil.isIgnoredInAnySense(clManager, file) || clManager.isUnversioned(file);
    }
}

