/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRebaseParams {
    @Nullable
    private final String myBase;
    @NotNull
    private final Mode myMode;

    @NotNull
    public static GitRebaseParams abort() {
        GitRebaseParams gitRebaseParams = new GitRebaseParams(null, Mode.ABORT);
        if (gitRebaseParams == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitRebaseParams", "abort"));
        }
        return gitRebaseParams;
    }

    public GitRebaseParams(@NotNull String base) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "git4idea/branch/GitRebaseParams", "<init>"));
        }
        this(base, Mode.STANDARD);
    }

    private GitRebaseParams(@Nullable String base, @NotNull Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "git4idea/branch/GitRebaseParams", "<init>"));
        }
        this.myBase = base;
        this.myMode = mode;
    }

    @NotNull
    public GitRebaseParams withMode(@NotNull Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "git4idea/branch/GitRebaseParams", "withMode"));
        }
        GitRebaseParams gitRebaseParams = mode == this.myMode ? this : new GitRebaseParams(this.myBase, mode);
        if (gitRebaseParams == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitRebaseParams", "withMode"));
        }
        return gitRebaseParams;
    }

    @NotNull
    public String getBase() {
        String string = StringUtil.notNullize((String)this.myBase);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitRebaseParams", "getBase"));
        }
        return string;
    }

    @NotNull
    public Mode getMode() {
        Mode mode = this.myMode;
        if (mode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitRebaseParams", "getMode"));
        }
        return mode;
    }

    @NotNull
    public List<String> getCommandLineArguments() {
        if (this.myMode != Mode.STANDARD) {
            List<String> list = Collections.singletonList(this.myMode.asArgument());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitRebaseParams", "getCommandLineArguments"));
            }
            return list;
        }
        ArrayList args = ContainerUtil.newArrayList();
        args.add(this.myBase);
        ArrayList arrayList = args;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitRebaseParams", "getCommandLineArguments"));
        }
        return arrayList;
    }

    public static enum Mode {
        STANDARD,
        CONTINUE,
        SKIP,
        ABORT;


        @NotNull
        String asArgument() {
            if (this == STANDARD) {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitRebaseParams$Mode", "asArgument"));
                }
                return "";
            }
            String string = "--" + this.name().toLowerCase();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitRebaseParams$Mode", "asArgument"));
            }
            return string;
        }
    }
}

