/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import git4idea.GitReference;
import git4idea.branch.GitBranchUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class GitBranch
extends GitReference {
    @NonNls
    public static final String REFS_HEADS_PREFIX = "refs/heads/";
    @NonNls
    public static final String REFS_REMOTES_PREFIX = "refs/remotes/";
    @Deprecated
    public static final Hash DUMMY_HASH = HashImpl.build((String)"");
    private static final Logger LOG = Logger.getInstance(GitBranch.class);
    @NotNull
    private final Hash myHash;

    protected GitBranch(@NotNull String name, @NotNull Hash hash) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "git4idea/GitBranch", "<init>"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "git4idea/GitBranch", "<init>"));
        }
        super(GitBranchUtil.stripRefsPrefix(name));
        this.myHash = hash;
    }

    @NotNull
    public Hash getHash() {
        Hash hash = this.myHash;
        if (hash == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitBranch", "getHash"));
        }
        return hash;
    }

    public abstract boolean isRemote();

    @Override
    @NotNull
    public String getFullName() {
        String string = (this.isRemote() ? REFS_REMOTES_PREFIX : REFS_HEADS_PREFIX) + this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitBranch", "getFullName"));
        }
        return string;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @NotNull
    public String toLogString() {
        String string = String.format("%s:%s:%s", this.getFullName(), this.getHash(), this.isRemote() ? "remote" : "local");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitBranch", "toLogString"));
        }
        return string;
    }
}

