/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.git;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.common.annotations.VisibleForTesting;
import com.google.gct.idea.elysium.SelectUserDialog;
import com.google.gct.idea.util.GctBundle;
import com.google.gct.login.CredentialedUser;
import com.google.gct.login.GoogleLogin;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.util.AuthData;
import git4idea.DialogManager;
import git4idea.remote.GitHttpAuthDataProvider;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GcpHttpAuthDataProvider
implements GitHttpAuthDataProvider {
    private static final Logger LOG = Logger.getInstance(GcpHttpAuthDataProvider.class);
    public static final String GOOGLE_URL = "https://source.developers.google.com";
    public static final String GCP_USER = "com.google.gct.idea.git.username";
    private static final String GOOGLE_URL_ALT = "http://source.developers.google.com";
    private String mySelectedUser;
    private boolean myChooseManualLogin;
    private static Project ourCurrentProject;

    @Nullable
    public AuthData getAuthData(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/google/gct/idea/git/GcpHttpAuthDataProvider", "getAuthData"));
        }
        final Project currentProject = GcpHttpAuthDataProvider.getCurrentProject();
        if ((currentProject != null || Context.ourCurrentContext != null) && GcpHttpAuthDataProvider.isUrlGCP(url)) {
            CredentialedUser targetUser;
            String userEmail;
            Context currentContext = Context.ourCurrentContext;
            String string = userEmail = currentContext != null ? currentContext.myUserName : null;
            if (Strings.isNullOrEmpty((String)userEmail) && currentProject != null) {
                userEmail = PropertiesComponent.getInstance((Project)currentProject).getValue(GCP_USER, "");
            }
            if ((targetUser = GcpHttpAuthDataProvider.getUserFromEmail(userEmail)) == null) {
                ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SelectUserDialog dialog = new SelectUserDialog(currentProject, GctBundle.getString("httpauthprovider.chooselogin", new Object[0]));
                        DialogManager.show((DialogWrapper)dialog);
                        GcpHttpAuthDataProvider.this.myChooseManualLogin = !dialog.isOK();
                        GcpHttpAuthDataProvider.this.mySelectedUser = dialog.getSelectedUser();
                    }
                }, ModalityState.defaultModalityState());
                if (this.myChooseManualLogin) {
                    return null;
                }
                userEmail = this.mySelectedUser;
                targetUser = GcpHttpAuthDataProvider.getUserFromEmail(userEmail);
                if (targetUser != null && currentProject != null && Context.ourCurrentContext == null) {
                    PropertiesComponent.getInstance((Project)currentProject).setValue(GCP_USER, userEmail);
                }
            }
            if (targetUser != null) {
                try {
                    return new AuthData(targetUser.getEmail(), targetUser.getGoogleLoginState().fetchAccessToken());
                }
                catch (IOException ex) {
                    LOG.error("IOException creating authdata:" + ex.toString());
                }
            }
        }
        return null;
    }

    public static boolean isUrlGCP(@Nullable String url) {
        return url != null && (StringUtil.startsWithIgnoreCase((String)url, (String)GOOGLE_URL) || StringUtil.startsWithIgnoreCase((String)url, (String)GOOGLE_URL_ALT));
    }

    public static String getGcpUrl(String projectId) {
        return "https://source.developers.google.com/p/" + projectId + "/";
    }

    @Nullable
    public static String findGCPRemoteUrl(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/google/gct/idea/git/GcpHttpAuthDataProvider", "findGCPRemoteUrl"));
        }
        Pair<GitRemote, String> remote = GcpHttpAuthDataProvider.findGCPRemote(repository);
        if (remote == null) {
            return null;
        }
        return (String)remote.getSecond();
    }

    @Nullable
    public static Pair<GitRemote, String> findGCPRemote(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/google/gct/idea/git/GcpHttpAuthDataProvider", "findGCPRemote"));
        }
        for (GitRemote gitRemote : repository.getRemotes()) {
            for (String remoteUrl : gitRemote.getUrls()) {
                if (!GcpHttpAuthDataProvider.isUrlGCP(remoteUrl)) continue;
                return Pair.create((Object)gitRemote, (Object)remoteUrl);
            }
        }
        return null;
    }

    @NotNull
    public static Context createContext(@Nullable String userName) {
        Context context = Context.Create(userName);
        if (context == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/idea/git/GcpHttpAuthDataProvider", "createContext"));
        }
        return context;
    }

    @Nullable
    private static CredentialedUser getUserFromEmail(@Nullable String email) {
        if (Strings.isNullOrEmpty((String)email)) {
            return null;
        }
        for (CredentialedUser user : GoogleLogin.getInstance().getAllUsers().values()) {
            if (email == null || !email.equalsIgnoreCase(user.getEmail())) continue;
            return user;
        }
        return null;
    }

    public void forgetPassword(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/google/gct/idea/git/GcpHttpAuthDataProvider", "forgetPassword"));
        }
        Project currentProject = GcpHttpAuthDataProvider.getCurrentProject();
        if (currentProject != null) {
            PropertiesComponent.getInstance((Project)currentProject).unsetValue(GCP_USER);
        }
    }

    @Nullable
    private static Project getCurrentProject() {
        Project result = null;
        Window activeWindow = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        if (activeWindow != null) {
            result = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)activeWindow));
        }
        return result != null ? result : ourCurrentProject;
    }

    @VisibleForTesting
    static void setCurrentProject(Project project) {
        ourCurrentProject = project;
    }

    public static class Context {
        private static Context ourCurrentContext = null;
        private String myUserName;

        private Context(@Nullable String userName) {
            this.myUserName = userName;
        }

        public static Context Create(@Nullable String userName) {
            Context newContext = new Context(userName);
            assert (ourCurrentContext == null);
            ourCurrentContext = newContext;
            return newContext;
        }

        public void Close() {
            if (ourCurrentContext == this) {
                ourCurrentContext = null;
            }
        }
    }
}

