/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.elysium;

import com.google.gct.idea.elysium.ElysiumErrorModelItem;
import com.google.gct.idea.elysium.ElysiumLoadingModelItem;
import com.google.gct.idea.elysium.ElysiumNewProjectModelItem;
import com.google.gct.idea.elysium.ElysiumProjectModelItem;
import com.google.gct.idea.elysium.GoogleSignOnModelItem;
import com.google.gct.idea.elysium.GoogleUserModelItem;
import com.google.gct.idea.elysium.ProjectSelectorCredentialedUser;
import com.google.gct.idea.elysium.ProjectSelectorErrorItem;
import com.google.gct.idea.elysium.ProjectSelectorGoogleLogin;
import com.google.gct.idea.elysium.ProjectSelectorItem;
import com.google.gct.idea.elysium.ProjectSelectorLoadingItem;
import com.google.gct.idea.elysium.ProjectSelectorNewProjectItem;
import com.intellij.ui.JBColor;
import com.intellij.util.ConcurrencyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProjectSelectorRenderer
implements TreeCellRenderer,
MouseListener,
MouseMotionListener {
    private static final Cursor NORMAL_CURSOR = Cursor.getPredefinedCursor(0);
    private static final Color ERROR_COLOR = JBColor.RED;
    private final ScheduledExecutorService myLoadingAnimationScheduler;
    private ScheduledFuture<?> myTicker;
    private JTree myTree;
    private DefaultTreeCellRenderer myDefaultRenderer;
    private ProjectSelectorGoogleLogin myProjectSelectorGoogleLogin;
    private ProjectSelectorNewProjectItem myProjectSelectorNewProjectItem;
    private ProjectSelectorItem myProjectSelectorItem;
    private ProjectSelectorCredentialedUser myProjectSelectorCredentialedUser;
    private ProjectSelectorLoadingItem myProjectSelectorLoadingItem;
    private ProjectSelectorErrorItem mySelectorErrorItem;
    private DefaultMutableTreeNode myLastHoveredNode;

    public ProjectSelectorRenderer(@NotNull JTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/google/gct/idea/elysium/ProjectSelectorRenderer", "<init>"));
        }
        this.myLoadingAnimationScheduler = ConcurrencyUtil.newSingleScheduledThreadExecutor((String)"Animations");
        this.myDefaultRenderer = new DefaultTreeCellRenderer();
        this.myProjectSelectorGoogleLogin = new ProjectSelectorGoogleLogin();
        this.myProjectSelectorCredentialedUser = new ProjectSelectorCredentialedUser();
        this.myTree = tree;
        Color backgroundNonSelectionColor = this.myDefaultRenderer.getBackgroundNonSelectionColor();
        Color textNonSelectionColor = this.myDefaultRenderer.getTextNonSelectionColor();
        this.myProjectSelectorItem = new ProjectSelectorItem(backgroundNonSelectionColor, this.myDefaultRenderer.getTextSelectionColor(), textNonSelectionColor);
        this.myProjectSelectorLoadingItem = new ProjectSelectorLoadingItem(backgroundNonSelectionColor, textNonSelectionColor);
        this.myProjectSelectorNewProjectItem = new ProjectSelectorNewProjectItem(this.myTree);
        this.mySelectorErrorItem = new ProjectSelectorErrorItem(ERROR_COLOR);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component returnValue = null;
        if (value != null && value instanceof DefaultMutableTreeNode) {
            returnValue = this.getComponentForNode(value, selected);
        }
        if (returnValue == null) {
            returnValue = this.myDefaultRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        return returnValue;
    }

    public int getMaximumWidth() {
        return this.myProjectSelectorNewProjectItem.getPreferredSize().width;
    }

    private void repaintLoadingNodes() {
        boolean hasLoadingNode = false;
        DefaultTreeModel model = (DefaultTreeModel)this.myTree.getModel();
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)model.getRoot();
        for (int index = 0; index < rootNode.getChildCount(); ++index) {
            TreePath path;
            Rectangle rect;
            GoogleUserModelItem userModelItem = (GoogleUserModelItem)rootNode.getChildAt(index);
            if (!userModelItem.isSynchronizing() || userModelItem.getChildCount() != 1 || !(userModelItem.getChildAt(0) instanceof ElysiumLoadingModelItem) || (rect = this.myTree.getPathBounds(path = new TreePath(model.getPathToRoot(userModelItem.getChildAt(0))))) == null) continue;
            this.myTree.repaint(rect);
            hasLoadingNode = true;
        }
        if (!hasLoadingNode) {
            this.myTicker.cancel(false);
            this.myTicker = null;
        }
    }

    @Nullable
    private Component getComponentForNode(Object userObject, boolean selected) {
        if (userObject instanceof GoogleSignOnModelItem) {
            return this.myProjectSelectorGoogleLogin;
        }
        if (userObject instanceof ElysiumNewProjectModelItem) {
            return this.myProjectSelectorNewProjectItem;
        }
        if (userObject instanceof ElysiumLoadingModelItem) {
            if (this.myTicker == null) {
                this.myTicker = this.myLoadingAnimationScheduler.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        ProjectSelectorRenderer.this.repaintLoadingNodes();
                    }
                }, 100L, 100L, TimeUnit.MILLISECONDS);
            }
            this.myProjectSelectorLoadingItem.snap();
            return this.myProjectSelectorLoadingItem;
        }
        if (userObject instanceof ElysiumErrorModelItem) {
            this.mySelectorErrorItem.setText(((ElysiumErrorModelItem)userObject).getErrorMessage());
            return this.mySelectorErrorItem;
        }
        if (userObject instanceof ElysiumProjectModelItem) {
            this.myProjectSelectorItem.initialize(((ElysiumProjectModelItem)userObject).getDescription(), ((ElysiumProjectModelItem)userObject).getProjectId(), selected, this.myLastHoveredNode == userObject);
            return this.myProjectSelectorItem;
        }
        if (userObject instanceof GoogleUserModelItem) {
            GoogleUserModelItem userModelItem = (GoogleUserModelItem)userObject;
            this.myProjectSelectorCredentialedUser.initialize(userModelItem.getImage(), userModelItem.getName(), userModelItem.getEmail());
            return this.myProjectSelectorCredentialedUser;
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TreePath path = this.myTree.getPathForLocation(e.getX(), e.getY());
        if (path != null && path.getLastPathComponent() instanceof GoogleUserModelItem) {
            if (this.myTree.isCollapsed(path)) {
                this.myTree.expandPath(path);
            } else {
                this.myTree.collapsePath(path);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Component component = this.getComponentFromXY(e.getX(), e.getY(), false);
        if (component instanceof MouseListener) {
            ((MouseListener)((Object)component)).mousePressed(new MouseEvent(component, e.getID(), e.getWhen(), e.getModifiers(), this.getXTranslation(e.getX(), e.getY()), this.getYTranslation(e.getX(), e.getY()), e.getClickCount(), e.isPopupTrigger(), e.getButton()));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        boolean mouseMovedHandled = false;
        TreePath path = this.myTree.getPathForLocation(e.getX(), e.getY());
        if (path != null && path.getLastPathComponent() instanceof DefaultMutableTreeNode) {
            Component component;
            DefaultMutableTreeNode newHoveredNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (newHoveredNode != this.myLastHoveredNode) {
                Rectangle rect;
                if (this.myLastHoveredNode != null && (rect = this.myTree.getPathBounds(new TreePath(this.myLastHoveredNode.getPath()))) != null) {
                    this.myTree.repaint(rect);
                }
                this.myLastHoveredNode = newHoveredNode;
                rect = this.myTree.getPathBounds(new TreePath(this.myLastHoveredNode.getPath()));
                if (rect != null) {
                    this.myTree.repaint(rect);
                }
            }
            if ((component = this.getComponentForNode(newHoveredNode, false)) instanceof MouseMotionListener) {
                ((MouseMotionListener)((Object)component)).mouseMoved(new MouseEvent(component, e.getID(), e.getWhen(), e.getModifiers(), this.getXTranslation(e.getX(), e.getY()), this.getYTranslation(e.getX(), e.getY()), e.getClickCount(), e.isPopupTrigger(), e.getButton()));
                mouseMovedHandled = true;
            }
        }
        if (!mouseMovedHandled) {
            this.myTree.setCursor(NORMAL_CURSOR);
        }
    }

    @Nullable
    private Component getComponentFromXY(int x, int y, boolean selected) {
        Object node;
        TreePath path = this.myTree.getPathForLocation(x, y);
        if (path != null && (node = path.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
            return this.getComponentForNode(node, selected);
        }
        return null;
    }

    private int getXTranslation(int x, int y) {
        TreePath path = this.myTree.getPathForLocation(x, y);
        Rectangle nodeBounds = this.myTree.getPathBounds(path);
        return x - (nodeBounds != null ? nodeBounds.x : 0);
    }

    private int getYTranslation(int x, int y) {
        TreePath path = this.myTree.getPathForLocation(x, y);
        Rectangle nodeBounds = this.myTree.getPathBounds(path);
        return y - (nodeBounds != null ? nodeBounds.y : 0);
    }
}

