/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.elysium;

import com.google.gct.idea.elysium.ProjectSelector;
import com.google.gct.login.stats.UsageTrackerService;
import com.intellij.ide.BrowserUtil;
import com.intellij.ui.UI;
import com.intellij.ui.components.JBLabel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.MouseInputListener;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;

class ProjectSelectorNewProjectItem
extends JPanel
implements MouseListener,
MouseInputListener {
    private static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    private static final Cursor NORMAL_CURSOR = Cursor.getPredefinedCursor(0);
    private JLabel myClickHere;
    private JTree myTree;
    private JPanel myPanel1;

    public ProjectSelectorNewProjectItem(@NotNull JTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/google/gct/idea/elysium/ProjectSelectorNewProjectItem", "<init>"));
        }
        this.setLayout(new FlowLayout(0, 0, 5));
        this.myTree = tree;
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 0));
        this.myClickHere = new JBLabel();
        this.myClickHere.setHorizontalAlignment(2);
        this.myClickHere.setForeground(UI.getColor((String)"link.foreground"));
        this.myClickHere.setText("<HTML><U>Click here</U></HTML>");
        this.myClickHere.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.add(this.myClickHere);
        JBLabel continuation = new JBLabel();
        continuation.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        continuation.setHorizontalAlignment(2);
        continuation.setText(" to create a new Google Developers Console project.");
        this.add((Component)continuation);
    }

    private boolean isOverLink(int x, int y) {
        return x <= this.myClickHere.getPreferredSize().width + 15;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.isOverLink(e.getX(), e.getY())) {
            TreeModel model = this.myTree.getModel();
            if (model instanceof ProjectSelector.SelectorTreeModel) {
                ((ProjectSelector.SelectorTreeModel)model).setModelNeedsRefresh(true);
            }
            BrowserUtil.browse((String)"https://console.developers.google.com/project");
            UsageTrackerService.getInstance().trackEvent("com.google.cloud.tools", "project.selection", "create.new.project", null);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.isOverLink(e.getX(), e.getY())) {
            this.myTree.setCursor(HAND_CURSOR);
        } else {
            this.myTree.setCursor(NORMAL_CURSOR);
        }
    }
}

